/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectFailedException;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.FeatureNotSupportedException;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.NetworkProxy;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;

public final class SOCKSNetworkProxy
implements NetworkProxy {
    private String _host;
    private int _port;
    private InetSocketAddress _address;

    public SOCKSNetworkProxy(String host, int port) {
        this._host = host;
        this._port = port;
    }

    private SOCKSNetworkProxy(InetSocketAddress address) {
        this._address = address;
    }

    @Override
    public void beginWrite(InetSocketAddress endpoint, Buffer buf) {
        InetAddress addr = endpoint.getAddress();
        if (addr == null) {
            throw new FeatureNotSupportedException("SOCKS4 does not support domain names");
        }
        if (!(addr instanceof Inet4Address)) {
            throw new FeatureNotSupportedException("SOCKS4 only supports IPv4 addresses");
        }
        buf.resize(9, false);
        ByteOrder order = buf.b.order();
        buf.b.order(ByteOrder.BIG_ENDIAN);
        buf.position(0);
        buf.b.put((byte)4);
        buf.b.put((byte)1);
        buf.b.putShort((short)endpoint.getPort());
        buf.b.put(addr.getAddress());
        buf.b.put((byte)0);
        buf.position(0);
        buf.limit(buf.size());
        buf.b.order(order);
    }

    @Override
    public int endWrite(Buffer buf) {
        return buf.b.hasRemaining() ? 4 : 1;
    }

    @Override
    public void beginRead(Buffer buf) {
        if (!buf.b.hasRemaining()) {
            buf.resize(8, true);
            buf.position(0);
        }
    }

    @Override
    public int endRead(Buffer buf) {
        return buf.b.hasRemaining() ? 1 : 0;
    }

    @Override
    public void finish(Buffer readBuffer, Buffer writeBuffer) {
        readBuffer.position(0);
        byte b1 = readBuffer.b.get();
        byte b2 = readBuffer.b.get();
        if (b1 != 0 || b2 != 90) {
            throw new ConnectFailedException();
        }
    }

    @Override
    public NetworkProxy resolveHost(int protocolSupport) {
        assert (this._host != null);
        return new SOCKSNetworkProxy(Network.getAddresses(this._host, this._port, protocolSupport, EndpointSelectionType.Random, false, true).get(0));
    }

    @Override
    public InetSocketAddress getAddress() {
        assert (this._address != null);
        return this._address;
    }

    @Override
    public String getName() {
        return "SOCKS";
    }

    @Override
    public int getProtocolSupport() {
        return 0;
    }
}

