/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.util.Enumeration;
import org.apache.tomcat.util.http.MimeHeaders;

class NamesEnumerator
implements Enumeration<String> {
    private int pos;
    private final int size;
    private String next;
    private final MimeHeaders headers;

    NamesEnumerator(MimeHeaders mimeHeaders) {
        this.headers = mimeHeaders;
        this.pos = 0;
        this.size = mimeHeaders.size();
        this.findNext();
    }

    private void findNext() {
        this.next = null;
        while (this.pos < this.size) {
            this.next = this.headers.getName(this.pos).toStringType();
            for (int i = 0; i < this.pos; ++i) {
                if (!this.headers.getName(i).equalsIgnoreCase(this.next)) continue;
                this.next = null;
                break;
            }
            if (this.next != null) break;
            ++this.pos;
        }
        ++this.pos;
    }

    @Override
    public boolean hasMoreElements() {
        return this.next != null;
    }

    @Override
    public String nextElement() {
        String string = this.next;
        this.findNext();
        return string;
    }
}

