/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp.rtcp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12InetAddressAction;
import com.sun.media.util.jdk12PropertyAction;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;

public class SourceDescription
implements Serializable {
    public static final int SOURCE_DESC_CNAME = 1;
    public static final int SOURCE_DESC_NAME = 2;
    public static final int SOURCE_DESC_EMAIL = 3;
    public static final int SOURCE_DESC_PHONE = 4;
    public static final int SOURCE_DESC_LOC = 5;
    public static final int SOURCE_DESC_TOOL = 6;
    public static final int SOURCE_DESC_NOTE = 7;
    public static final int SOURCE_DESC_PRIV = 8;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private static Method[] m = new Method[1];
    private static Class[] cl = new Class[1];
    private static Object[][] args = new Object[1][0];
    private int m_type;
    private String m_description = null;
    private int m_frequency;
    private boolean m_encrypted = false;

    public SourceDescription(int type, String description, int frequency, boolean encrypted) {
        this.m_type = type;
        this.m_description = description;
        this.m_frequency = frequency;
        this.m_encrypted = encrypted;
    }

    public int getType() {
        return this.m_type;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String desc) {
        this.m_description = desc;
    }

    public int getFrequency() {
        return this.m_frequency;
    }

    public boolean getEncrypted() {
        return this.m_encrypted;
    }

    public static String generateCNAME() {
        String hostname = null;
        String cname = "";
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "connect";
                    jmfSecurity.requestPermission(m, cl, args, 128);
                    m[0].invoke((Object)cl[0], args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12InetAddressAction.cons;
                InetAddress host = (InetAddress)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(null, "getLocalHost", null));
                hostname = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(host, "getHostName", null));
            } else {
                InetAddress host = InetAddress.getLocalHost();
                hostname = host.getHostName();
            }
        }
        catch (Throwable e) {
            System.err.println("InitSession : UnknownHostExcpetion " + e.getMessage());
        }
        cname = SourceDescription.getProperty("user.name");
        if (cname == null) {
            return hostname;
        }
        return cname + "@" + hostname;
    }

    private static String getProperty(String prop) {
        String value = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(m, cl, args, 1);
                    m[0].invoke((Object)cl[0], args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                }
            }
            catch (Throwable e) {
                jmfSecurity.permissionFailureNotification(1);
            }
        }
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12PropertyAction.cons;
                value = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(prop));
            } else {
                value = System.getProperty(prop);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

