/*
 * This declarations of the PIC16LF1559 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:08 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1559_H__
#define __PIC16LF1559_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define APFCON_ADDR             0x011D
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define RCREG_ADDR              0x0199
#define TXREG_ADDR              0x019A
#define SPBRG_ADDR              0x019B
#define SPBRGL_ADDR             0x019B
#define SPBRGH_ADDR             0x019C
#define RCSTA_ADDR              0x019D
#define TXSTA_ADDR              0x019E
#define BAUDCON_ADDR            0x019F
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define PWM1DCL_ADDR            0x0611
#define PWM1DCH_ADDR            0x0612
#define PWM1CON_ADDR            0x0613
#define PWM1CON0_ADDR           0x0613
#define PWM2DCL_ADDR            0x0614
#define PWM2DCH_ADDR            0x0615
#define PWM2CON_ADDR            0x0616
#define PWM2CON0_ADDR           0x0616
#define AAD1CON0_ADDR           0x0711
#define AADCON0_ADDR            0x0711
#define AD1CON0_ADDR            0x0711
#define AADCON1_ADDR            0x0712
#define ADCOMCON_ADDR           0x0712
#define AAD1CON2_ADDR           0x0713
#define AADCON2_ADDR            0x0713
#define AD1CON2_ADDR            0x0713
#define AAD1CON3_ADDR           0x0714
#define AADCON3_ADDR            0x0714
#define AD1CON3_ADDR            0x0714
#define AADSTAT_ADDR            0x0715
#define ADSTAT_ADDR             0x0715
#define AAD1PRE_ADDR            0x0716
#define AADPRE_ADDR             0x0716
#define AD1PRE_ADDR             0x0716
#define AD1PRECON_ADDR          0x0716
#define AAD1ACQ_ADDR            0x0717
#define AADACQ_ADDR             0x0717
#define AD1ACQ_ADDR             0x0717
#define AD1ACQCON_ADDR          0x0717
#define AAD1GRD_ADDR            0x0718
#define AADGRD_ADDR             0x0718
#define AD1GRD_ADDR             0x0718
#define AAD1CAP_ADDR            0x0719
#define AAD1CAPCON_ADDR         0x0719
#define AADCAP_ADDR             0x0719
#define AD1CAPCON_ADDR          0x0719
#define AAD1RES0_ADDR           0x071A
#define AAD1RES0L_ADDR          0x071A
#define AD1RES0_ADDR            0x071A
#define AD1RES0L_ADDR           0x071A
#define ADRES0_ADDR             0x071A
#define AAD1RES0H_ADDR          0x071B
#define AD1RES0H_ADDR           0x071B
#define AAD1RES1_ADDR           0x071C
#define AAD1RES1L_ADDR          0x071C
#define AD1RES1_ADDR            0x071C
#define AD1RES1L_ADDR           0x071C
#define ADRES1_ADDR             0x071C
#define AAD1RES1H_ADDR          0x071D
#define AD1RES1H_ADDR           0x071D
#define AAD1CH_ADDR             0x071E
#define AD1CH_ADDR              0x071E
#define AAD2CON0_ADDR           0x0791
#define AD2CON0_ADDR            0x0791
#define AAD2CON2_ADDR           0x0793
#define AD2CON2_ADDR            0x0793
#define AAD2CON3_ADDR           0x0794
#define AD2CON3_ADDR            0x0794
#define AAD2PRE_ADDR            0x0796
#define AD2PRE_ADDR             0x0796
#define AD2PRECON_ADDR          0x0796
#define AAD2ACQ_ADDR            0x0797
#define AD2ACQ_ADDR             0x0797
#define AD2ACQCON_ADDR          0x0797
#define AAD2GRD_ADDR            0x0798
#define AD2GRD_ADDR             0x0798
#define AAD2CAP_ADDR            0x0799
#define AAD2CAPCON_ADDR         0x0799
#define AD2CAPCON_ADDR          0x0799
#define AAD2RES0_ADDR           0x079A
#define AAD2RES0L_ADDR          0x079A
#define AD2RES0_ADDR            0x079A
#define AAD2RES0H_ADDR          0x079B
#define AAD2RES1_ADDR           0x079C
#define AAD2RES1L_ADDR          0x079C
#define AD2RES1_ADDR            0x079C
#define AAD2RES1H_ADDR          0x079D
#define AAD2CH_ADDR             0x079E
#define AD2CH_ADDR              0x079E
#define ICDIO_ADDR              0x0F8C
#define ICDCON0_ADDR            0x0F8D
#define ICDSTAT_ADDR            0x0F91
#define ICDINSTL_ADDR           0x0F96
#define ICDINSTH_ADDR           0x0F97
#define ICDBK0CON_ADDR          0x0F9C
#define ICDBK0L_ADDR            0x0F9D
#define ICDBK0H_ADDR            0x0F9E
#define BSRICDSHAD_ADDR         0x0FE3
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned                    : 1;
    unsigned SSP1IF             : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned ADIF               : 1;
    unsigned TMR1GIF            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IF              : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _AD1IF                  0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned AD2IF                : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _BCL1IF                 0x08
#define _AD2IF                  0x40

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned                    : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GCON_T1GSS0          0x01
#define _T1GCON_T1GSS1          0x02
#define _T1GCON_T1GVAL          0x04
#define _T1GCON_T1GGO_NOT_DONE  0x08
#define _T1GCON_GO              0x08
#define _T1GCON_T1GSPM          0x10
#define _T1GCON_T1GTM           0x20
#define _T1GCON_T1GPOL          0x40
#define _T1GCON_TMR1GE          0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned                    : 1;
    unsigned SSP1IE             : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned ADIE               : 1;
    unsigned TMR1GIE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IE              : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _AD1IE                  0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned AD2IE                : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _BCL1IE                 0x08
#define _AD2IE                  0x40

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned HFIOFR               : 1;
  unsigned                      : 1;
  unsigned PLLSR                : 1;
  unsigned                      : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _HFIOFR                 0x10
#define _PLLSR                  0x40

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AD1ON              : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADCON0_ADON            0x01
#define _ADCON0_AD1ON           0x01
#define _ADCON0_GO_NOT_DONE     0x02
#define _ADCON0_ADGO            0x02
#define _ADCON0_GO              0x02
#define _ADCON0_CHS0            0x04
#define _ADCON0_CHS1            0x08
#define _ADCON0_CHS2            0x10
#define _ADCON0_CHS3            0x20
#define _ADCON0_CHS4            0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned GO_NOT_DONE_ALL    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_ALL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADCON1_ADPREF0         0x01
#define _ADCON1_ADPREF1         0x02
#define _ADCON1_GO_NOT_DONE_ALL 0x04
#define _ADCON1_GO_ALL          0x04
#define _ADCON1_ADFM            0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _ADCON2_TRIGSEL0        0x10
#define _ADCON2_TRIGSEL1        0x20
#define _ADCON2_TRIGSEL2        0x40

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned GRDASEL              : 1;
  unsigned GRDBSEL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SDSEL                : 1;
  unsigned SSSEL                : 1;
  unsigned SDOSEL               : 1;
  unsigned RXDTSEL              : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _GRDASEL                0x01
#define _GRDBSEL                0x02
#define _SDSEL                  0x10
#define _SSSEL                  0x20
#define _SDOSEL                 0x40
#define _RXDTSEL                0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned ANSB6                : 1;
  unsigned ANSB7                : 1;
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40
#define _ANSB7                  0x80

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned ANSC4                : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;
extern __at(0x0199) __sfr RCREG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SPBRGH;

//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================

extern __at(0x0211) __sfr SSP1BUF;
extern __at(0x0211) __sfr SSPBUF;
extern __at(0x0212) __sfr SSP1ADD;
extern __at(0x0212) __sfr SSPADD;
extern __at(0x0213) __sfr SSP1MSK;
extern __at(0x0213) __sfr SSPMSK;

//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        PWM1DCL Bits

extern __at(0x0611) __sfr PWM1DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1DCL0           : 1;
    unsigned PWM1DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM1DCL            : 2;
    };
  } __PWM1DCLbits_t;

extern __at(0x0611) volatile __PWM1DCLbits_t PWM1DCLbits;

#define _PWM1DCL0               0x40
#define _PWM1DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM1DCH Bits

extern __at(0x0612) __sfr PWM1DCH;

typedef struct
  {
  unsigned PWM1DCH0             : 1;
  unsigned PWM1DCH1             : 1;
  unsigned PWM1DCH2             : 1;
  unsigned PWM1DCH3             : 1;
  unsigned PWM1DCH4             : 1;
  unsigned PWM1DCH5             : 1;
  unsigned PWM1DCH6             : 1;
  unsigned PWM1DCH7             : 1;
  } __PWM1DCHbits_t;

extern __at(0x0612) volatile __PWM1DCHbits_t PWM1DCHbits;

#define _PWM1DCH0               0x01
#define _PWM1DCH1               0x02
#define _PWM1DCH2               0x04
#define _PWM1DCH3               0x08
#define _PWM1DCH4               0x10
#define _PWM1DCH5               0x20
#define _PWM1DCH6               0x40
#define _PWM1DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0613) __sfr PWM1CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CONbits_t;

extern __at(0x0613) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1POL                0x10
#define _PWM1OUT                0x20
#define _PWM1OE                 0x40
#define _PWM1EN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON0 Bits

extern __at(0x0613) __sfr PWM1CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CON0bits_t;

extern __at(0x0613) volatile __PWM1CON0bits_t PWM1CON0bits;

#define _PWM1CON0_PWM1POL       0x10
#define _PWM1CON0_PWM1OUT       0x20
#define _PWM1CON0_PWM1OE        0x40
#define _PWM1CON0_PWM1EN        0x80

//==============================================================================


//==============================================================================
//        PWM2DCL Bits

extern __at(0x0614) __sfr PWM2DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2DCL0           : 1;
    unsigned PWM2DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM2DCL            : 2;
    };
  } __PWM2DCLbits_t;

extern __at(0x0614) volatile __PWM2DCLbits_t PWM2DCLbits;

#define _PWM2DCL0               0x40
#define _PWM2DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM2DCH Bits

extern __at(0x0615) __sfr PWM2DCH;

typedef struct
  {
  unsigned PWM2DCH0             : 1;
  unsigned PWM2DCH1             : 1;
  unsigned PWM2DCH2             : 1;
  unsigned PWM2DCH3             : 1;
  unsigned PWM2DCH4             : 1;
  unsigned PWM2DCH5             : 1;
  unsigned PWM2DCH6             : 1;
  unsigned PWM2DCH7             : 1;
  } __PWM2DCHbits_t;

extern __at(0x0615) volatile __PWM2DCHbits_t PWM2DCHbits;

#define _PWM2DCH0               0x01
#define _PWM2DCH1               0x02
#define _PWM2DCH2               0x04
#define _PWM2DCH3               0x08
#define _PWM2DCH4               0x10
#define _PWM2DCH5               0x20
#define _PWM2DCH6               0x40
#define _PWM2DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0616) __sfr PWM2CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CONbits_t;

extern __at(0x0616) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2POL                0x10
#define _PWM2OUT                0x20
#define _PWM2OE                 0x40
#define _PWM2EN                 0x80

//==============================================================================


//==============================================================================
//        PWM2CON0 Bits

extern __at(0x0616) __sfr PWM2CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CON0bits_t;

extern __at(0x0616) volatile __PWM2CON0bits_t PWM2CON0bits;

#define _PWM2CON0_PWM2POL       0x10
#define _PWM2CON0_PWM2OUT       0x20
#define _PWM2CON0_PWM2OE        0x40
#define _PWM2CON0_PWM2EN        0x80

//==============================================================================


//==============================================================================
//        AAD1CON0 Bits

extern __at(0x0711) __sfr AAD1CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE1       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __AAD1CON0bits_t;

extern __at(0x0711) volatile __AAD1CON0bits_t AAD1CON0bits;

#define _ADON                   0x01
#define _GO                     0x02
#define _GO_NOT_DONE            0x02
#define _GO_NOT_DONE1           0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        AADCON0 Bits

extern __at(0x0711) __sfr AADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE1       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __AADCON0bits_t;

extern __at(0x0711) volatile __AADCON0bits_t AADCON0bits;

#define _AADCON0_ADON           0x01
#define _AADCON0_GO             0x02
#define _AADCON0_GO_NOT_DONE    0x02
#define _AADCON0_GO_NOT_DONE1   0x02
#define _AADCON0_CHS0           0x04
#define _AADCON0_CHS1           0x08
#define _AADCON0_CHS2           0x10
#define _AADCON0_CHS3           0x20
#define _AADCON0_CHS4           0x40

//==============================================================================


//==============================================================================
//        AD1CON0 Bits

extern __at(0x0711) __sfr AD1CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE1       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __AD1CON0bits_t;

extern __at(0x0711) volatile __AD1CON0bits_t AD1CON0bits;

#define _AD1CON0_ADON           0x01
#define _AD1CON0_GO             0x02
#define _AD1CON0_GO_NOT_DONE    0x02
#define _AD1CON0_GO_NOT_DONE1   0x02
#define _AD1CON0_CHS0           0x04
#define _AD1CON0_CHS1           0x08
#define _AD1CON0_CHS2           0x10
#define _AD1CON0_CHS3           0x20
#define _AD1CON0_CHS4           0x40

//==============================================================================


//==============================================================================
//        AADCON1 Bits

extern __at(0x0712) __sfr AADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned GO_NOT_DONE_ALL    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_ALL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __AADCON1bits_t;

extern __at(0x0712) volatile __AADCON1bits_t AADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _GO_NOT_DONE_ALL        0x04
#define _GO_ALL                 0x04
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCOMCON Bits

extern __at(0x0712) __sfr ADCOMCON;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned GO_NOT_DONE_ALL    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_ALL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCOMCONbits_t;

extern __at(0x0712) volatile __ADCOMCONbits_t ADCOMCONbits;

#define _ADCOMCON_ADPREF0       0x01
#define _ADCOMCON_ADPREF1       0x02
#define _ADCOMCON_GO_NOT_DONE_ALL 0x04
#define _ADCOMCON_GO_ALL        0x04
#define _ADCOMCON_ADCS0         0x10
#define _ADCOMCON_ADCS1         0x20
#define _ADCOMCON_ADCS2         0x40
#define _ADCOMCON_ADFM          0x80

//==============================================================================


//==============================================================================
//        AAD1CON2 Bits

extern __at(0x0713) __sfr AAD1CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AAD1CON2bits_t;

extern __at(0x0713) volatile __AAD1CON2bits_t AAD1CON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40

//==============================================================================


//==============================================================================
//        AADCON2 Bits

extern __at(0x0713) __sfr AADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AADCON2bits_t;

extern __at(0x0713) volatile __AADCON2bits_t AADCON2bits;

#define _AADCON2_TRIGSEL0       0x10
#define _AADCON2_TRIGSEL1       0x20
#define _AADCON2_TRIGSEL2       0x40

//==============================================================================


//==============================================================================
//        AD1CON2 Bits

extern __at(0x0713) __sfr AD1CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AD1CON2bits_t;

extern __at(0x0713) volatile __AD1CON2bits_t AD1CON2bits;

#define _AD1CON2_TRIGSEL0       0x10
#define _AD1CON2_TRIGSEL1       0x20
#define _AD1CON2_TRIGSEL2       0x40

//==============================================================================


//==============================================================================
//        AAD1CON3 Bits

extern __at(0x0714) __sfr AAD1CON3;

typedef union
  {
  struct
    {
    unsigned AD1DSEN            : 1;
    unsigned AD1IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IPPOL           : 1;
    unsigned AD1EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AAD1CON3bits_t;

extern __at(0x0714) volatile __AAD1CON3bits_t AAD1CON3bits;

#define _AD1DSEN                0x01
#define _ADDSEN                 0x01
#define _AD1IPEN                0x02
#define _ADIPEN                 0x02
#define _AD1IPPOL               0x40
#define _ADIPPOL                0x40
#define _AD1EPPOL               0x80
#define _ADEPPOL                0x80

//==============================================================================


//==============================================================================
//        AADCON3 Bits

extern __at(0x0714) __sfr AADCON3;

typedef union
  {
  struct
    {
    unsigned AD1DSEN            : 1;
    unsigned AD1IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IPPOL           : 1;
    unsigned AD1EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AADCON3bits_t;

extern __at(0x0714) volatile __AADCON3bits_t AADCON3bits;

#define _AADCON3_AD1DSEN        0x01
#define _AADCON3_ADDSEN         0x01
#define _AADCON3_AD1IPEN        0x02
#define _AADCON3_ADIPEN         0x02
#define _AADCON3_AD1IPPOL       0x40
#define _AADCON3_ADIPPOL        0x40
#define _AADCON3_AD1EPPOL       0x80
#define _AADCON3_ADEPPOL        0x80

//==============================================================================


//==============================================================================
//        AD1CON3 Bits

extern __at(0x0714) __sfr AD1CON3;

typedef union
  {
  struct
    {
    unsigned AD1DSEN            : 1;
    unsigned AD1IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IPPOL           : 1;
    unsigned AD1EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AD1CON3bits_t;

extern __at(0x0714) volatile __AD1CON3bits_t AD1CON3bits;

#define _AD1CON3_AD1DSEN        0x01
#define _AD1CON3_ADDSEN         0x01
#define _AD1CON3_AD1IPEN        0x02
#define _AD1CON3_ADIPEN         0x02
#define _AD1CON3_AD1IPPOL       0x40
#define _AD1CON3_ADIPPOL        0x40
#define _AD1CON3_AD1EPPOL       0x80
#define _AD1CON3_ADEPPOL        0x80

//==============================================================================


//==============================================================================
//        AADSTAT Bits

extern __at(0x0715) __sfr AADSTAT;

typedef union
  {
  struct
    {
    unsigned AD1STG0            : 1;
    unsigned AD1STG1            : 1;
    unsigned AD1CONV            : 1;
    unsigned                    : 1;
    unsigned AD2STG0            : 1;
    unsigned AD2STG1            : 1;
    unsigned AD2CONV            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCONV             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AD1STG             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned AD2STG             : 2;
    unsigned                    : 2;
    };
  } __AADSTATbits_t;

extern __at(0x0715) volatile __AADSTATbits_t AADSTATbits;

#define _AD1STG0                0x01
#define _AD1STG1                0x02
#define _AD1CONV                0x04
#define _ADCONV                 0x04
#define _AD2STG0                0x10
#define _AD2STG1                0x20
#define _AD2CONV                0x40

//==============================================================================


//==============================================================================
//        ADSTAT Bits

extern __at(0x0715) __sfr ADSTAT;

typedef union
  {
  struct
    {
    unsigned AD1STG0            : 1;
    unsigned AD1STG1            : 1;
    unsigned AD1CONV            : 1;
    unsigned                    : 1;
    unsigned AD2STG0            : 1;
    unsigned AD2STG1            : 1;
    unsigned AD2CONV            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCONV             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AD1STG             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned AD2STG             : 2;
    unsigned                    : 2;
    };
  } __ADSTATbits_t;

extern __at(0x0715) volatile __ADSTATbits_t ADSTATbits;

#define _ADSTAT_AD1STG0         0x01
#define _ADSTAT_AD1STG1         0x02
#define _ADSTAT_AD1CONV         0x04
#define _ADSTAT_ADCONV          0x04
#define _ADSTAT_AD2STG0         0x10
#define _ADSTAT_AD2STG1         0x20
#define _ADSTAT_AD2CONV         0x40

//==============================================================================


//==============================================================================
//        AAD1PRE Bits

extern __at(0x0716) __sfr AAD1PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AAD1PREbits_t;

extern __at(0x0716) volatile __AAD1PREbits_t AAD1PREbits;

#define _ADPRE0                 0x01
#define _ADPRE1                 0x02
#define _ADPRE2                 0x04
#define _ADPRE3                 0x08
#define _ADPRE4                 0x10
#define _ADPRE5                 0x20
#define _ADPRE6                 0x40

//==============================================================================


//==============================================================================
//        AADPRE Bits

extern __at(0x0716) __sfr AADPRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AADPREbits_t;

extern __at(0x0716) volatile __AADPREbits_t AADPREbits;

#define _AADPRE_ADPRE0          0x01
#define _AADPRE_ADPRE1          0x02
#define _AADPRE_ADPRE2          0x04
#define _AADPRE_ADPRE3          0x08
#define _AADPRE_ADPRE4          0x10
#define _AADPRE_ADPRE5          0x20
#define _AADPRE_ADPRE6          0x40

//==============================================================================


//==============================================================================
//        AD1PRE Bits

extern __at(0x0716) __sfr AD1PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD1PREbits_t;

extern __at(0x0716) volatile __AD1PREbits_t AD1PREbits;

#define _AD1PRE_ADPRE0          0x01
#define _AD1PRE_ADPRE1          0x02
#define _AD1PRE_ADPRE2          0x04
#define _AD1PRE_ADPRE3          0x08
#define _AD1PRE_ADPRE4          0x10
#define _AD1PRE_ADPRE5          0x20
#define _AD1PRE_ADPRE6          0x40

//==============================================================================


//==============================================================================
//        AD1PRECON Bits

extern __at(0x0716) __sfr AD1PRECON;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD1PRECONbits_t;

extern __at(0x0716) volatile __AD1PRECONbits_t AD1PRECONbits;

#define _AD1PRECON_ADPRE0       0x01
#define _AD1PRECON_ADPRE1       0x02
#define _AD1PRECON_ADPRE2       0x04
#define _AD1PRECON_ADPRE3       0x08
#define _AD1PRECON_ADPRE4       0x10
#define _AD1PRECON_ADPRE5       0x20
#define _AD1PRECON_ADPRE6       0x40

//==============================================================================


//==============================================================================
//        AAD1ACQ Bits

extern __at(0x0717) __sfr AAD1ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AAD1ACQbits_t;

extern __at(0x0717) volatile __AAD1ACQbits_t AAD1ACQbits;

#define _ADACQ0                 0x01
#define _ADACQ1                 0x02
#define _ADACQ2                 0x04
#define _ADACQ3                 0x08
#define _ADACQ4                 0x10
#define _ADACQ5                 0x20
#define _ADACQ6                 0x40

//==============================================================================


//==============================================================================
//        AADACQ Bits

extern __at(0x0717) __sfr AADACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AADACQbits_t;

extern __at(0x0717) volatile __AADACQbits_t AADACQbits;

#define _AADACQ_ADACQ0          0x01
#define _AADACQ_ADACQ1          0x02
#define _AADACQ_ADACQ2          0x04
#define _AADACQ_ADACQ3          0x08
#define _AADACQ_ADACQ4          0x10
#define _AADACQ_ADACQ5          0x20
#define _AADACQ_ADACQ6          0x40

//==============================================================================


//==============================================================================
//        AD1ACQ Bits

extern __at(0x0717) __sfr AD1ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD1ACQbits_t;

extern __at(0x0717) volatile __AD1ACQbits_t AD1ACQbits;

#define _AD1ACQ_ADACQ0          0x01
#define _AD1ACQ_ADACQ1          0x02
#define _AD1ACQ_ADACQ2          0x04
#define _AD1ACQ_ADACQ3          0x08
#define _AD1ACQ_ADACQ4          0x10
#define _AD1ACQ_ADACQ5          0x20
#define _AD1ACQ_ADACQ6          0x40

//==============================================================================


//==============================================================================
//        AD1ACQCON Bits

extern __at(0x0717) __sfr AD1ACQCON;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD1ACQCONbits_t;

extern __at(0x0717) volatile __AD1ACQCONbits_t AD1ACQCONbits;

#define _AD1ACQCON_ADACQ0       0x01
#define _AD1ACQCON_ADACQ1       0x02
#define _AD1ACQCON_ADACQ2       0x04
#define _AD1ACQCON_ADACQ3       0x08
#define _AD1ACQCON_ADACQ4       0x10
#define _AD1ACQCON_ADACQ5       0x20
#define _AD1ACQCON_ADACQ6       0x40

//==============================================================================


//==============================================================================
//        AAD1GRD Bits

extern __at(0x0718) __sfr AAD1GRD;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD1POL            : 1;
    unsigned GRD1AOE            : 1;
    unsigned GRD1BOE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AAD1GRDbits_t;

extern __at(0x0718) volatile __AAD1GRDbits_t AAD1GRDbits;

#define _GRD1POL                0x20
#define _GRDPOL                 0x20
#define _GRD1AOE                0x40
#define _GRDAOE                 0x40
#define _GRD1BOE                0x80
#define _GRDBOE                 0x80

//==============================================================================


//==============================================================================
//        AADGRD Bits

extern __at(0x0718) __sfr AADGRD;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD1POL            : 1;
    unsigned GRD1AOE            : 1;
    unsigned GRD1BOE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AADGRDbits_t;

extern __at(0x0718) volatile __AADGRDbits_t AADGRDbits;

#define _AADGRD_GRD1POL         0x20
#define _AADGRD_GRDPOL          0x20
#define _AADGRD_GRD1AOE         0x40
#define _AADGRD_GRDAOE          0x40
#define _AADGRD_GRD1BOE         0x80
#define _AADGRD_GRDBOE          0x80

//==============================================================================


//==============================================================================
//        AD1GRD Bits

extern __at(0x0718) __sfr AD1GRD;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD1POL            : 1;
    unsigned GRD1AOE            : 1;
    unsigned GRD1BOE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AD1GRDbits_t;

extern __at(0x0718) volatile __AD1GRDbits_t AD1GRDbits;

#define _AD1GRD_GRD1POL         0x20
#define _AD1GRD_GRDPOL          0x20
#define _AD1GRD_GRD1AOE         0x40
#define _AD1GRD_GRDAOE          0x40
#define _AD1GRD_GRD1BOE         0x80
#define _AD1GRD_GRDBOE          0x80

//==============================================================================


//==============================================================================
//        AAD1CAP Bits

extern __at(0x0719) __sfr AAD1CAP;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD1CAPbits_t;

extern __at(0x0719) volatile __AAD1CAPbits_t AAD1CAPbits;

#define _ADDCAP0                0x01
#define _ADDCAP1                0x02
#define _ADDCAP2                0x04
#define _ADDCAP3                0x08

//==============================================================================


//==============================================================================
//        AAD1CAPCON Bits

extern __at(0x0719) __sfr AAD1CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD1CAPCONbits_t;

extern __at(0x0719) volatile __AAD1CAPCONbits_t AAD1CAPCONbits;

#define _AAD1CAPCON_ADDCAP0     0x01
#define _AAD1CAPCON_ADDCAP1     0x02
#define _AAD1CAPCON_ADDCAP2     0x04
#define _AAD1CAPCON_ADDCAP3     0x08

//==============================================================================


//==============================================================================
//        AADCAP Bits

extern __at(0x0719) __sfr AADCAP;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AADCAPbits_t;

extern __at(0x0719) volatile __AADCAPbits_t AADCAPbits;

#define _AADCAP_ADDCAP0         0x01
#define _AADCAP_ADDCAP1         0x02
#define _AADCAP_ADDCAP2         0x04
#define _AADCAP_ADDCAP3         0x08

//==============================================================================


//==============================================================================
//        AD1CAPCON Bits

extern __at(0x0719) __sfr AD1CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AD1CAPCONbits_t;

extern __at(0x0719) volatile __AD1CAPCONbits_t AD1CAPCONbits;

#define _AD1CAPCON_ADDCAP0      0x01
#define _AD1CAPCON_ADDCAP1      0x02
#define _AD1CAPCON_ADDCAP2      0x04
#define _AD1CAPCON_ADDCAP3      0x08

//==============================================================================

extern __at(0x071A) __sfr AAD1RES0;
extern __at(0x071A) __sfr AAD1RES0L;
extern __at(0x071A) __sfr AD1RES0;
extern __at(0x071A) __sfr AD1RES0L;
extern __at(0x071A) __sfr ADRES0;
extern __at(0x071B) __sfr AAD1RES0H;
extern __at(0x071B) __sfr AD1RES0H;
extern __at(0x071C) __sfr AAD1RES1;
extern __at(0x071C) __sfr AAD1RES1L;
extern __at(0x071C) __sfr AD1RES1;
extern __at(0x071C) __sfr AD1RES1L;
extern __at(0x071C) __sfr ADRES1;
extern __at(0x071D) __sfr AAD1RES1H;
extern __at(0x071D) __sfr AD1RES1H;

//==============================================================================
//        AAD1CH Bits

extern __at(0x071E) __sfr AAD1CH;

typedef struct
  {
  unsigned CH10                 : 1;
  unsigned CH11                 : 1;
  unsigned CH12                 : 1;
  unsigned CH13                 : 1;
  unsigned CH14                 : 1;
  unsigned CH15                 : 1;
  unsigned CH16                 : 1;
  unsigned                      : 1;
  } __AAD1CHbits_t;

extern __at(0x071E) volatile __AAD1CHbits_t AAD1CHbits;

#define _CH10                   0x01
#define _CH11                   0x02
#define _CH12                   0x04
#define _CH13                   0x08
#define _CH14                   0x10
#define _CH15                   0x20
#define _CH16                   0x40

//==============================================================================


//==============================================================================
//        AD1CH Bits

extern __at(0x071E) __sfr AD1CH;

typedef struct
  {
  unsigned CH10                 : 1;
  unsigned CH11                 : 1;
  unsigned CH12                 : 1;
  unsigned CH13                 : 1;
  unsigned CH14                 : 1;
  unsigned CH15                 : 1;
  unsigned CH16                 : 1;
  unsigned                      : 1;
  } __AD1CHbits_t;

extern __at(0x071E) volatile __AD1CHbits_t AD1CHbits;

#define _AD1CH_CH10             0x01
#define _AD1CH_CH11             0x02
#define _AD1CH_CH12             0x04
#define _AD1CH_CH13             0x08
#define _AD1CH_CH14             0x10
#define _AD1CH_CH15             0x20
#define _AD1CH_CH16             0x40

//==============================================================================


//==============================================================================
//        AAD2CON0 Bits

extern __at(0x0791) __sfr AAD2CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE2       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __AAD2CON0bits_t;

extern __at(0x0791) volatile __AAD2CON0bits_t AAD2CON0bits;

#define _AAD2CON0_ADON          0x01
#define _AAD2CON0_GO            0x02
#define _AAD2CON0_GO_NOT_DONE   0x02
#define _AAD2CON0_GO_NOT_DONE2  0x02
#define _AAD2CON0_CHS0          0x04
#define _AAD2CON0_CHS1          0x08
#define _AAD2CON0_CHS2          0x10
#define _AAD2CON0_CHS3          0x20
#define _AAD2CON0_CHS4          0x40

//==============================================================================


//==============================================================================
//        AD2CON0 Bits

extern __at(0x0791) __sfr AD2CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE2       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __AD2CON0bits_t;

extern __at(0x0791) volatile __AD2CON0bits_t AD2CON0bits;

#define _AD2CON0_ADON           0x01
#define _AD2CON0_GO             0x02
#define _AD2CON0_GO_NOT_DONE    0x02
#define _AD2CON0_GO_NOT_DONE2   0x02
#define _AD2CON0_CHS0           0x04
#define _AD2CON0_CHS1           0x08
#define _AD2CON0_CHS2           0x10
#define _AD2CON0_CHS3           0x20
#define _AD2CON0_CHS4           0x40

//==============================================================================


//==============================================================================
//        AAD2CON2 Bits

extern __at(0x0793) __sfr AAD2CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AAD2CON2bits_t;

extern __at(0x0793) volatile __AAD2CON2bits_t AAD2CON2bits;

#define _AAD2CON2_TRIGSEL0      0x10
#define _AAD2CON2_TRIGSEL1      0x20
#define _AAD2CON2_TRIGSEL2      0x40

//==============================================================================


//==============================================================================
//        AD2CON2 Bits

extern __at(0x0793) __sfr AD2CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AD2CON2bits_t;

extern __at(0x0793) volatile __AD2CON2bits_t AD2CON2bits;

#define _AD2CON2_TRIGSEL0       0x10
#define _AD2CON2_TRIGSEL1       0x20
#define _AD2CON2_TRIGSEL2       0x40

//==============================================================================


//==============================================================================
//        AAD2CON3 Bits

extern __at(0x0794) __sfr AAD2CON3;

typedef union
  {
  struct
    {
    unsigned AD2DSEN            : 1;
    unsigned AD2IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD2IPPOL           : 1;
    unsigned AD2EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AAD2CON3bits_t;

extern __at(0x0794) volatile __AAD2CON3bits_t AAD2CON3bits;

#define _AAD2CON3_AD2DSEN       0x01
#define _AAD2CON3_ADDSEN        0x01
#define _AAD2CON3_AD2IPEN       0x02
#define _AAD2CON3_ADIPEN        0x02
#define _AAD2CON3_AD2IPPOL      0x40
#define _AAD2CON3_ADIPPOL       0x40
#define _AAD2CON3_AD2EPPOL      0x80
#define _AAD2CON3_ADEPPOL       0x80

//==============================================================================


//==============================================================================
//        AD2CON3 Bits

extern __at(0x0794) __sfr AD2CON3;

typedef union
  {
  struct
    {
    unsigned AD2DSEN            : 1;
    unsigned AD2IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD2IPPOL           : 1;
    unsigned AD2EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AD2CON3bits_t;

extern __at(0x0794) volatile __AD2CON3bits_t AD2CON3bits;

#define _AD2CON3_AD2DSEN        0x01
#define _AD2CON3_ADDSEN         0x01
#define _AD2CON3_AD2IPEN        0x02
#define _AD2CON3_ADIPEN         0x02
#define _AD2CON3_AD2IPPOL       0x40
#define _AD2CON3_ADIPPOL        0x40
#define _AD2CON3_AD2EPPOL       0x80
#define _AD2CON3_ADEPPOL        0x80

//==============================================================================


//==============================================================================
//        AAD2PRE Bits

extern __at(0x0796) __sfr AAD2PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AAD2PREbits_t;

extern __at(0x0796) volatile __AAD2PREbits_t AAD2PREbits;

#define _AAD2PRE_ADPRE0         0x01
#define _AAD2PRE_ADPRE1         0x02
#define _AAD2PRE_ADPRE2         0x04
#define _AAD2PRE_ADPRE3         0x08
#define _AAD2PRE_ADPRE4         0x10
#define _AAD2PRE_ADPRE5         0x20
#define _AAD2PRE_ADPRE6         0x40

//==============================================================================


//==============================================================================
//        AD2PRE Bits

extern __at(0x0796) __sfr AD2PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD2PREbits_t;

extern __at(0x0796) volatile __AD2PREbits_t AD2PREbits;

#define _AD2PRE_ADPRE0          0x01
#define _AD2PRE_ADPRE1          0x02
#define _AD2PRE_ADPRE2          0x04
#define _AD2PRE_ADPRE3          0x08
#define _AD2PRE_ADPRE4          0x10
#define _AD2PRE_ADPRE5          0x20
#define _AD2PRE_ADPRE6          0x40

//==============================================================================


//==============================================================================
//        AD2PRECON Bits

extern __at(0x0796) __sfr AD2PRECON;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD2PRECONbits_t;

extern __at(0x0796) volatile __AD2PRECONbits_t AD2PRECONbits;

#define _AD2PRECON_ADPRE0       0x01
#define _AD2PRECON_ADPRE1       0x02
#define _AD2PRECON_ADPRE2       0x04
#define _AD2PRECON_ADPRE3       0x08
#define _AD2PRECON_ADPRE4       0x10
#define _AD2PRECON_ADPRE5       0x20
#define _AD2PRECON_ADPRE6       0x40

//==============================================================================


//==============================================================================
//        AAD2ACQ Bits

extern __at(0x0797) __sfr AAD2ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AAD2ACQbits_t;

extern __at(0x0797) volatile __AAD2ACQbits_t AAD2ACQbits;

#define _AAD2ACQ_ADACQ0         0x01
#define _AAD2ACQ_ADACQ1         0x02
#define _AAD2ACQ_ADACQ2         0x04
#define _AAD2ACQ_ADACQ3         0x08
#define _AAD2ACQ_ADACQ4         0x10
#define _AAD2ACQ_ADACQ5         0x20
#define _AAD2ACQ_ADACQ6         0x40

//==============================================================================


//==============================================================================
//        AD2ACQ Bits

extern __at(0x0797) __sfr AD2ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD2ACQbits_t;

extern __at(0x0797) volatile __AD2ACQbits_t AD2ACQbits;

#define _AD2ACQ_ADACQ0          0x01
#define _AD2ACQ_ADACQ1          0x02
#define _AD2ACQ_ADACQ2          0x04
#define _AD2ACQ_ADACQ3          0x08
#define _AD2ACQ_ADACQ4          0x10
#define _AD2ACQ_ADACQ5          0x20
#define _AD2ACQ_ADACQ6          0x40

//==============================================================================


//==============================================================================
//        AD2ACQCON Bits

extern __at(0x0797) __sfr AD2ACQCON;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD2ACQCONbits_t;

extern __at(0x0797) volatile __AD2ACQCONbits_t AD2ACQCONbits;

#define _AD2ACQCON_ADACQ0       0x01
#define _AD2ACQCON_ADACQ1       0x02
#define _AD2ACQCON_ADACQ2       0x04
#define _AD2ACQCON_ADACQ3       0x08
#define _AD2ACQCON_ADACQ4       0x10
#define _AD2ACQCON_ADACQ5       0x20
#define _AD2ACQCON_ADACQ6       0x40

//==============================================================================


//==============================================================================
//        AAD2GRD Bits

extern __at(0x0798) __sfr AAD2GRD;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD2POL            : 1;
    unsigned GRD2AOE            : 1;
    unsigned GRD2BOE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AAD2GRDbits_t;

extern __at(0x0798) volatile __AAD2GRDbits_t AAD2GRDbits;

#define _AAD2GRD_GRD2POL        0x20
#define _AAD2GRD_GRDPOL         0x20
#define _AAD2GRD_GRD2AOE        0x40
#define _AAD2GRD_GRDAOE         0x40
#define _AAD2GRD_GRD2BOE        0x80
#define _AAD2GRD_GRDBOE         0x80

//==============================================================================


//==============================================================================
//        AD2GRD Bits

extern __at(0x0798) __sfr AD2GRD;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD2POL            : 1;
    unsigned GRD2AOE            : 1;
    unsigned GRD2BOE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AD2GRDbits_t;

extern __at(0x0798) volatile __AD2GRDbits_t AD2GRDbits;

#define _AD2GRD_GRD2POL         0x20
#define _AD2GRD_GRDPOL          0x20
#define _AD2GRD_GRD2AOE         0x40
#define _AD2GRD_GRDAOE          0x40
#define _AD2GRD_GRD2BOE         0x80
#define _AD2GRD_GRDBOE          0x80

//==============================================================================


//==============================================================================
//        AAD2CAP Bits

extern __at(0x0799) __sfr AAD2CAP;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD2CAPbits_t;

extern __at(0x0799) volatile __AAD2CAPbits_t AAD2CAPbits;

#define _AAD2CAP_ADDCAP0        0x01
#define _AAD2CAP_ADDCAP1        0x02
#define _AAD2CAP_ADDCAP2        0x04
#define _AAD2CAP_ADDCAP3        0x08

//==============================================================================


//==============================================================================
//        AAD2CAPCON Bits

extern __at(0x0799) __sfr AAD2CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD2CAPCONbits_t;

extern __at(0x0799) volatile __AAD2CAPCONbits_t AAD2CAPCONbits;

#define _AAD2CAPCON_ADDCAP0     0x01
#define _AAD2CAPCON_ADDCAP1     0x02
#define _AAD2CAPCON_ADDCAP2     0x04
#define _AAD2CAPCON_ADDCAP3     0x08

//==============================================================================


//==============================================================================
//        AD2CAPCON Bits

extern __at(0x0799) __sfr AD2CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AD2CAPCONbits_t;

extern __at(0x0799) volatile __AD2CAPCONbits_t AD2CAPCONbits;

#define _AD2CAPCON_ADDCAP0      0x01
#define _AD2CAPCON_ADDCAP1      0x02
#define _AD2CAPCON_ADDCAP2      0x04
#define _AD2CAPCON_ADDCAP3      0x08

//==============================================================================

extern __at(0x079A) __sfr AAD2RES0;
extern __at(0x079A) __sfr AAD2RES0L;
extern __at(0x079A) __sfr AD2RES0;
extern __at(0x079B) __sfr AAD2RES0H;
extern __at(0x079C) __sfr AAD2RES1;
extern __at(0x079C) __sfr AAD2RES1L;
extern __at(0x079C) __sfr AD2RES1;
extern __at(0x079D) __sfr AAD2RES1H;

//==============================================================================
//        AAD2CH Bits

extern __at(0x079E) __sfr AAD2CH;

typedef struct
  {
  unsigned CH20                 : 1;
  unsigned CH21                 : 1;
  unsigned CH22                 : 1;
  unsigned CH23                 : 1;
  unsigned CH24                 : 1;
  unsigned CH25                 : 1;
  unsigned CH26                 : 1;
  unsigned                      : 1;
  } __AAD2CHbits_t;

extern __at(0x079E) volatile __AAD2CHbits_t AAD2CHbits;

#define _CH20                   0x01
#define _CH21                   0x02
#define _CH22                   0x04
#define _CH23                   0x08
#define _CH24                   0x10
#define _CH25                   0x20
#define _CH26                   0x40

//==============================================================================


//==============================================================================
//        AD2CH Bits

extern __at(0x079E) __sfr AD2CH;

typedef struct
  {
  unsigned CH20                 : 1;
  unsigned CH21                 : 1;
  unsigned CH22                 : 1;
  unsigned CH23                 : 1;
  unsigned CH24                 : 1;
  unsigned CH25                 : 1;
  unsigned CH26                 : 1;
  unsigned                      : 1;
  } __AD2CHbits_t;

extern __at(0x079E) volatile __AD2CHbits_t AD2CHbits;

#define _AD2CH_CH20             0x01
#define _AD2CH_CH21             0x02
#define _AD2CH_CH22             0x04
#define _AD2CH_CH23             0x08
#define _AD2CH_CH24             0x10
#define _AD2CH_CH25             0x20
#define _AD2CH_CH26             0x40

//==============================================================================


//==============================================================================
//        ICDIO Bits

extern __at(0x0F8C) __sfr ICDIO;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRIS_ICDCLK          : 1;
  unsigned TRIS_ICDDAT          : 1;
  unsigned LAT_ICDCLK           : 1;
  unsigned LAT_ICDDAT           : 1;
  unsigned PORT_ICDCLK          : 1;
  unsigned PORT_ICDDAT          : 1;
  } __ICDIObits_t;

extern __at(0x0F8C) volatile __ICDIObits_t ICDIObits;

#define _TRIS_ICDCLK            0x04
#define _TRIS_ICDDAT            0x08
#define _LAT_ICDCLK             0x10
#define _LAT_ICDDAT             0x20
#define _PORT_ICDCLK            0x40
#define _PORT_ICDDAT            0x80

//==============================================================================


//==============================================================================
//        ICDCON0 Bits

extern __at(0x0F8D) __sfr ICDCON0;

typedef struct
  {
  unsigned RSTVEC               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned DBGINEX              : 1;
  unsigned                      : 1;
  unsigned SSTEP                : 1;
  unsigned FREEZ                : 1;
  unsigned INBUG                : 1;
  } __ICDCON0bits_t;

extern __at(0x0F8D) volatile __ICDCON0bits_t ICDCON0bits;

#define _RSTVEC                 0x01
#define _DBGINEX                0x08
#define _SSTEP                  0x20
#define _FREEZ                  0x40
#define _INBUG                  0x80

//==============================================================================


//==============================================================================
//        ICDSTAT Bits

extern __at(0x0F91) __sfr ICDSTAT;

typedef struct
  {
  unsigned                      : 1;
  unsigned USRHLTF              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRP0HLTF             : 1;
  unsigned TRP1HLTF             : 1;
  } __ICDSTATbits_t;

extern __at(0x0F91) volatile __ICDSTATbits_t ICDSTATbits;

#define _USRHLTF                0x02
#define _TRP0HLTF               0x40
#define _TRP1HLTF               0x80

//==============================================================================


//==============================================================================
//        ICDINSTL Bits

extern __at(0x0F96) __sfr ICDINSTL;

typedef struct
  {
  unsigned DBGIN0               : 1;
  unsigned DBGIN1               : 1;
  unsigned DBGIN2               : 1;
  unsigned DBGIN3               : 1;
  unsigned DBGIN4               : 1;
  unsigned DBGIN5               : 1;
  unsigned DBGIN6               : 1;
  unsigned DBGIN7               : 1;
  } __ICDINSTLbits_t;

extern __at(0x0F96) volatile __ICDINSTLbits_t ICDINSTLbits;

#define _DBGIN0                 0x01
#define _DBGIN1                 0x02
#define _DBGIN2                 0x04
#define _DBGIN3                 0x08
#define _DBGIN4                 0x10
#define _DBGIN5                 0x20
#define _DBGIN6                 0x40
#define _DBGIN7                 0x80

//==============================================================================


//==============================================================================
//        ICDINSTH Bits

extern __at(0x0F97) __sfr ICDINSTH;

typedef struct
  {
  unsigned DBGIN8               : 1;
  unsigned DBGIN9               : 1;
  unsigned DBGIN10              : 1;
  unsigned DBGIN11              : 1;
  unsigned DBGIN12              : 1;
  unsigned DBGIN13              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ICDINSTHbits_t;

extern __at(0x0F97) volatile __ICDINSTHbits_t ICDINSTHbits;

#define _DBGIN8                 0x01
#define _DBGIN9                 0x02
#define _DBGIN10                0x04
#define _DBGIN11                0x08
#define _DBGIN12                0x10
#define _DBGIN13                0x20

//==============================================================================


//==============================================================================
//        ICDBK0CON Bits

extern __at(0x0F9C) __sfr ICDBK0CON;

typedef struct
  {
  unsigned BKHLT                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BKEN                 : 1;
  } __ICDBK0CONbits_t;

extern __at(0x0F9C) volatile __ICDBK0CONbits_t ICDBK0CONbits;

#define _BKHLT                  0x01
#define _BKEN                   0x80

//==============================================================================


//==============================================================================
//        ICDBK0L Bits

extern __at(0x0F9D) __sfr ICDBK0L;

typedef struct
  {
  unsigned BKA0                 : 1;
  unsigned BKA1                 : 1;
  unsigned BKA2                 : 1;
  unsigned BKA3                 : 1;
  unsigned BKA4                 : 1;
  unsigned BKA5                 : 1;
  unsigned BKA6                 : 1;
  unsigned BKA7                 : 1;
  } __ICDBK0Lbits_t;

extern __at(0x0F9D) volatile __ICDBK0Lbits_t ICDBK0Lbits;

#define _BKA0                   0x01
#define _BKA1                   0x02
#define _BKA2                   0x04
#define _BKA3                   0x08
#define _BKA4                   0x10
#define _BKA5                   0x20
#define _BKA6                   0x40
#define _BKA7                   0x80

//==============================================================================


//==============================================================================
//        ICDBK0H Bits

extern __at(0x0F9E) __sfr ICDBK0H;

typedef struct
  {
  unsigned BKA8                 : 1;
  unsigned BKA9                 : 1;
  unsigned BKA10                : 1;
  unsigned BKA11                : 1;
  unsigned BKA12                : 1;
  unsigned BKA13                : 1;
  unsigned BKA14                : 1;
  unsigned                      : 1;
  } __ICDBK0Hbits_t;

extern __at(0x0F9E) volatile __ICDBK0Hbits_t ICDBK0Hbits;

#define _BKA8                   0x01
#define _BKA9                   0x02
#define _BKA10                  0x04
#define _BKA11                  0x08
#define _BKA12                  0x10
#define _BKA13                  0x20
#define _BKA14                  0x40

//==============================================================================

extern __at(0x0FE3) __sfr BSRICDSHAD;

//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _WDTE_OFF               0x3FE7  // WDT disabled. SWDTEN bit is ignored.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep. SWDTEN bit is ignored.
#define _WDTE_ON                0x3FFF  // WDT enabled. SWDTEN bit is ignored.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled. SBOREN bit is ignored.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep. SBOREN bit is ignored.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to FFFh write protected, no addresses may be modified by PMCON control.
#define _WRT_HALF               0x3FFD  // 000h to 7FFh write protected, 800h to FFFh may be modified by PMCON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to FFFh may be modified by PMCON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), 2.7V trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), 1.9V trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADACQ0                  AAD1ACQbits.ADACQ0              // bit 0
#define ADACQ1                  AAD1ACQbits.ADACQ1              // bit 1
#define ADACQ2                  AAD1ACQbits.ADACQ2              // bit 2
#define ADACQ3                  AAD1ACQbits.ADACQ3              // bit 3
#define ADACQ4                  AAD1ACQbits.ADACQ4              // bit 4
#define ADACQ5                  AAD1ACQbits.ADACQ5              // bit 5
#define ADACQ6                  AAD1ACQbits.ADACQ6              // bit 6

#define ADDCAP0                 AAD1CAPbits.ADDCAP0             // bit 0
#define ADDCAP1                 AAD1CAPbits.ADDCAP1             // bit 1
#define ADDCAP2                 AAD1CAPbits.ADDCAP2             // bit 2
#define ADDCAP3                 AAD1CAPbits.ADDCAP3             // bit 3

#define CH10                    AAD1CHbits.CH10                 // bit 0
#define CH11                    AAD1CHbits.CH11                 // bit 1
#define CH12                    AAD1CHbits.CH12                 // bit 2
#define CH13                    AAD1CHbits.CH13                 // bit 3
#define CH14                    AAD1CHbits.CH14                 // bit 4
#define CH15                    AAD1CHbits.CH15                 // bit 5
#define CH16                    AAD1CHbits.CH16                 // bit 6

#define ADON                    AAD1CON0bits.ADON               // bit 0
#define GO                      AAD1CON0bits.GO                 // bit 1, shadows bit in AAD1CON0bits
#define GO_NOT_DONE             AAD1CON0bits.GO_NOT_DONE        // bit 1, shadows bit in AAD1CON0bits
#define GO_NOT_DONE1            AAD1CON0bits.GO_NOT_DONE1       // bit 1, shadows bit in AAD1CON0bits
#define CHS0                    AAD1CON0bits.CHS0               // bit 2
#define CHS1                    AAD1CON0bits.CHS1               // bit 3
#define CHS2                    AAD1CON0bits.CHS2               // bit 4
#define CHS3                    AAD1CON0bits.CHS3               // bit 5
#define CHS4                    AAD1CON0bits.CHS4               // bit 6

#define TRIGSEL0                AAD1CON2bits.TRIGSEL0           // bit 4
#define TRIGSEL1                AAD1CON2bits.TRIGSEL1           // bit 5
#define TRIGSEL2                AAD1CON2bits.TRIGSEL2           // bit 6

#define AD1DSEN                 AAD1CON3bits.AD1DSEN            // bit 0, shadows bit in AAD1CON3bits
#define ADDSEN                  AAD1CON3bits.ADDSEN             // bit 0, shadows bit in AAD1CON3bits
#define AD1IPEN                 AAD1CON3bits.AD1IPEN            // bit 1, shadows bit in AAD1CON3bits
#define ADIPEN                  AAD1CON3bits.ADIPEN             // bit 1, shadows bit in AAD1CON3bits
#define AD1IPPOL                AAD1CON3bits.AD1IPPOL           // bit 6, shadows bit in AAD1CON3bits
#define ADIPPOL                 AAD1CON3bits.ADIPPOL            // bit 6, shadows bit in AAD1CON3bits
#define AD1EPPOL                AAD1CON3bits.AD1EPPOL           // bit 7, shadows bit in AAD1CON3bits
#define ADEPPOL                 AAD1CON3bits.ADEPPOL            // bit 7, shadows bit in AAD1CON3bits

#define GRD1POL                 AAD1GRDbits.GRD1POL             // bit 5, shadows bit in AAD1GRDbits
#define GRDPOL                  AAD1GRDbits.GRDPOL              // bit 5, shadows bit in AAD1GRDbits
#define GRD1AOE                 AAD1GRDbits.GRD1AOE             // bit 6, shadows bit in AAD1GRDbits
#define GRDAOE                  AAD1GRDbits.GRDAOE              // bit 6, shadows bit in AAD1GRDbits
#define GRD1BOE                 AAD1GRDbits.GRD1BOE             // bit 7, shadows bit in AAD1GRDbits
#define GRDBOE                  AAD1GRDbits.GRDBOE              // bit 7, shadows bit in AAD1GRDbits

#define ADPRE0                  AAD1PREbits.ADPRE0              // bit 0
#define ADPRE1                  AAD1PREbits.ADPRE1              // bit 1
#define ADPRE2                  AAD1PREbits.ADPRE2              // bit 2
#define ADPRE3                  AAD1PREbits.ADPRE3              // bit 3
#define ADPRE4                  AAD1PREbits.ADPRE4              // bit 4
#define ADPRE5                  AAD1PREbits.ADPRE5              // bit 5
#define ADPRE6                  AAD1PREbits.ADPRE6              // bit 6

#define CH20                    AAD2CHbits.CH20                 // bit 0
#define CH21                    AAD2CHbits.CH21                 // bit 1
#define CH22                    AAD2CHbits.CH22                 // bit 2
#define CH23                    AAD2CHbits.CH23                 // bit 3
#define CH24                    AAD2CHbits.CH24                 // bit 4
#define CH25                    AAD2CHbits.CH25                 // bit 5
#define CH26                    AAD2CHbits.CH26                 // bit 6

#define ADPREF0                 AADCON1bits.ADPREF0             // bit 0
#define ADPREF1                 AADCON1bits.ADPREF1             // bit 1
#define GO_NOT_DONE_ALL         AADCON1bits.GO_NOT_DONE_ALL     // bit 2, shadows bit in AADCON1bits
#define GO_ALL                  AADCON1bits.GO_ALL              // bit 2, shadows bit in AADCON1bits
#define ADCS0                   AADCON1bits.ADCS0               // bit 4
#define ADCS1                   AADCON1bits.ADCS1               // bit 5
#define ADCS2                   AADCON1bits.ADCS2               // bit 6
#define ADFM                    AADCON1bits.ADFM                // bit 7

#define AD1STG0                 AADSTATbits.AD1STG0             // bit 0
#define AD1STG1                 AADSTATbits.AD1STG1             // bit 1
#define AD1CONV                 AADSTATbits.AD1CONV             // bit 2, shadows bit in AADSTATbits
#define ADCONV                  AADSTATbits.ADCONV              // bit 2, shadows bit in AADSTATbits
#define AD2STG0                 AADSTATbits.AD2STG0             // bit 4
#define AD2STG1                 AADSTATbits.AD2STG1             // bit 5
#define AD2CONV                 AADSTATbits.AD2CONV             // bit 6

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5

#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6
#define ANSB7                   ANSELBbits.ANSB7                // bit 7

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC4                   ANSELCbits.ANSC4                // bit 4
#define ANSC5                   ANSELCbits.ANSC5                // bit 5
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define GRDASEL                 APFCONbits.GRDASEL              // bit 0
#define GRDBSEL                 APFCONbits.GRDBSEL              // bit 1
#define SDSEL                   APFCONbits.SDSEL                // bit 4
#define SSSEL                   APFCONbits.SSSEL                // bit 5
#define SDOSEL                  APFCONbits.SDOSEL               // bit 6
#define RXDTSEL                 APFCONbits.RXDTSEL              // bit 7

#define ABDEN                   BAUDCONbits.ABDEN               // bit 0
#define WUE                     BAUDCONbits.WUE                 // bit 1
#define BRG16                   BAUDCONbits.BRG16               // bit 3
#define SCKP                    BAUDCONbits.SCKP                // bit 4
#define RCIDL                   BAUDCONbits.RCIDL               // bit 6
#define ABDOVF                  BAUDCONbits.ABDOVF              // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define BKHLT                   ICDBK0CONbits.BKHLT             // bit 0
#define BKEN                    ICDBK0CONbits.BKEN              // bit 7

#define BKA8                    ICDBK0Hbits.BKA8                // bit 0
#define BKA9                    ICDBK0Hbits.BKA9                // bit 1
#define BKA10                   ICDBK0Hbits.BKA10               // bit 2
#define BKA11                   ICDBK0Hbits.BKA11               // bit 3
#define BKA12                   ICDBK0Hbits.BKA12               // bit 4
#define BKA13                   ICDBK0Hbits.BKA13               // bit 5
#define BKA14                   ICDBK0Hbits.BKA14               // bit 6

#define BKA0                    ICDBK0Lbits.BKA0                // bit 0
#define BKA1                    ICDBK0Lbits.BKA1                // bit 1
#define BKA2                    ICDBK0Lbits.BKA2                // bit 2
#define BKA3                    ICDBK0Lbits.BKA3                // bit 3
#define BKA4                    ICDBK0Lbits.BKA4                // bit 4
#define BKA5                    ICDBK0Lbits.BKA5                // bit 5
#define BKA6                    ICDBK0Lbits.BKA6                // bit 6
#define BKA7                    ICDBK0Lbits.BKA7                // bit 7

#define RSTVEC                  ICDCON0bits.RSTVEC              // bit 0
#define DBGINEX                 ICDCON0bits.DBGINEX             // bit 3
#define SSTEP                   ICDCON0bits.SSTEP               // bit 5
#define FREEZ                   ICDCON0bits.FREEZ               // bit 6
#define INBUG                   ICDCON0bits.INBUG               // bit 7

#define DBGIN8                  ICDINSTHbits.DBGIN8             // bit 0
#define DBGIN9                  ICDINSTHbits.DBGIN9             // bit 1
#define DBGIN10                 ICDINSTHbits.DBGIN10            // bit 2
#define DBGIN11                 ICDINSTHbits.DBGIN11            // bit 3
#define DBGIN12                 ICDINSTHbits.DBGIN12            // bit 4
#define DBGIN13                 ICDINSTHbits.DBGIN13            // bit 5

#define DBGIN0                  ICDINSTLbits.DBGIN0             // bit 0
#define DBGIN1                  ICDINSTLbits.DBGIN1             // bit 1
#define DBGIN2                  ICDINSTLbits.DBGIN2             // bit 2
#define DBGIN3                  ICDINSTLbits.DBGIN3             // bit 3
#define DBGIN4                  ICDINSTLbits.DBGIN4             // bit 4
#define DBGIN5                  ICDINSTLbits.DBGIN5             // bit 5
#define DBGIN6                  ICDINSTLbits.DBGIN6             // bit 6
#define DBGIN7                  ICDINSTLbits.DBGIN7             // bit 7

#define TRIS_ICDCLK             ICDIObits.TRIS_ICDCLK           // bit 2
#define TRIS_ICDDAT             ICDIObits.TRIS_ICDDAT           // bit 3
#define LAT_ICDCLK              ICDIObits.LAT_ICDCLK            // bit 4
#define LAT_ICDDAT              ICDIObits.LAT_ICDDAT            // bit 5
#define PORT_ICDCLK             ICDIObits.PORT_ICDCLK           // bit 6
#define PORT_ICDDAT             ICDIObits.PORT_ICDDAT           // bit 7

#define USRHLTF                 ICDSTATbits.USRHLTF             // bit 1
#define TRP0HLTF                ICDSTATbits.TRP0HLTF            // bit 6
#define TRP1HLTF                ICDSTATbits.TRP1HLTF            // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define PLLSR                   OSCSTATbits.PLLSR               // bit 6

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6, shadows bit in PIE1bits
#define AD1IE                   PIE1bits.AD1IE                  // bit 6, shadows bit in PIE1bits
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define AD2IE                   PIE2bits.AD2IE                  // bit 6

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6, shadows bit in PIR1bits
#define AD1IF                   PIR1bits.AD1IF                  // bit 6, shadows bit in PIR1bits
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define AD2IF                   PIR2bits.AD2IF                  // bit 6

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define PWM1POL                 PWM1CONbits.PWM1POL             // bit 4
#define PWM1OUT                 PWM1CONbits.PWM1OUT             // bit 5
#define PWM1OE                  PWM1CONbits.PWM1OE              // bit 6
#define PWM1EN                  PWM1CONbits.PWM1EN              // bit 7

#define PWM1DCH0                PWM1DCHbits.PWM1DCH0            // bit 0
#define PWM1DCH1                PWM1DCHbits.PWM1DCH1            // bit 1
#define PWM1DCH2                PWM1DCHbits.PWM1DCH2            // bit 2
#define PWM1DCH3                PWM1DCHbits.PWM1DCH3            // bit 3
#define PWM1DCH4                PWM1DCHbits.PWM1DCH4            // bit 4
#define PWM1DCH5                PWM1DCHbits.PWM1DCH5            // bit 5
#define PWM1DCH6                PWM1DCHbits.PWM1DCH6            // bit 6
#define PWM1DCH7                PWM1DCHbits.PWM1DCH7            // bit 7

#define PWM1DCL0                PWM1DCLbits.PWM1DCL0            // bit 6
#define PWM1DCL1                PWM1DCLbits.PWM1DCL1            // bit 7

#define PWM2POL                 PWM2CONbits.PWM2POL             // bit 4
#define PWM2OUT                 PWM2CONbits.PWM2OUT             // bit 5
#define PWM2OE                  PWM2CONbits.PWM2OE              // bit 6
#define PWM2EN                  PWM2CONbits.PWM2EN              // bit 7

#define PWM2DCH0                PWM2DCHbits.PWM2DCH0            // bit 0
#define PWM2DCH1                PWM2DCHbits.PWM2DCH1            // bit 1
#define PWM2DCH2                PWM2DCHbits.PWM2DCH2            // bit 2
#define PWM2DCH3                PWM2DCHbits.PWM2DCH3            // bit 3
#define PWM2DCH4                PWM2DCHbits.PWM2DCH4            // bit 4
#define PWM2DCH5                PWM2DCHbits.PWM2DCH5            // bit 5
#define PWM2DCH6                PWM2DCHbits.PWM2DCH6            // bit 6
#define PWM2DCH7                PWM2DCHbits.PWM2DCH7            // bit 7

#define PWM2DCL0                PWM2DCLbits.PWM2DCL0            // bit 6
#define PWM2DCL1                PWM2DCLbits.PWM2DCL1            // bit 7

#define RX9D                    RCSTAbits.RX9D                  // bit 0
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define ADDEN                   RCSTAbits.ADDEN                 // bit 3
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define SSPM0                   SSP1CON1bits.SSPM0              // bit 0
#define SSPM1                   SSP1CON1bits.SSPM1              // bit 1
#define SSPM2                   SSP1CON1bits.SSPM2              // bit 2
#define SSPM3                   SSP1CON1bits.SSPM3              // bit 3
#define CKP                     SSP1CON1bits.CKP                // bit 4
#define SSPEN                   SSP1CON1bits.SSPEN              // bit 5
#define SSPOV                   SSP1CON1bits.SSPOV              // bit 6
#define WCOL                    SSP1CON1bits.WCOL               // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TX9D                    TXSTAbits.TX9D                  // bit 0
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SENDB                   TXSTAbits.SENDB                 // bit 3
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1559_H__
