/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.suggestion;

import ai.grazie.spell.Speller;
import com.intellij.grazie.spellcheck.engine.GrazieSpellCheckerEngine;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/spellcheck/suggestion/SpellcheckingNameSuggestionProvider;", "Lcom/intellij/refactoring/rename/NameSuggestionProvider;", "<init>", "()V", "suggestionLimit", "", "minimalWordLength", "getSuggestedNames", "Lcom/intellij/psi/codeStyle/SuggestedNameInfo;", "element", "Lcom/intellij/psi/PsiElement;", "context", "result", "", "", "getName", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nSpellcheckingNameSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellcheckingNameSuggestionProvider.kt\ncom/intellij/grazie/spellcheck/suggestion/SpellcheckingNameSuggestionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,40:1\n1068#2:41\n1563#2:42\n1634#2,3:43\n774#2:46\n865#2,2:47\n37#3,2:49\n*S KotlinDebug\n*F\n+ 1 SpellcheckingNameSuggestionProvider.kt\ncom/intellij/grazie/spellcheck/suggestion/SpellcheckingNameSuggestionProvider\n*L\n27#1:41\n28#1:42\n28#1:43,3\n29#1:46\n29#1:47,2\n34#1:49,2\n*E\n"})
public final class SpellcheckingNameSuggestionProvider
implements NameSuggestionProvider {
    private final int suggestionLimit;
    private final int minimalWordLength;

    public SpellcheckingNameSuggestionProvider() {
        this.suggestionLimit = 3;
        this.minimalWordLength = 4;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SuggestedNameInfo getSuggestedNames(@NotNull PsiElement element, @Nullable PsiElement context, @NotNull Set<String> result) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        String string = this.getName(element);
        if (string == null) {
            return null;
        }
        String name = string;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"IntellijIdeaRulezzz", (boolean)false, (int)2, null) || name.length() < this.minimalWordLength) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GrazieSpellCheckerEngine engine = GrazieSpellCheckerEngine.Companion.getInstance(project);
        Speller speller = engine.getSpeller();
        if (speller == null) {
            return null;
        }
        Speller speller2 = speller;
        if (!Speller.isMisspelled$default((Speller)speller2, (String)name, (boolean)false, (int)2, null)) {
            return null;
        }
        String[] stringArray = (String[])MapsKt.toList((Map)speller2.suggestAndRank(name, this.suggestionLimit));
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
            }
        });
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!RenameUtil.isValidName((Project)element.getProject(), (PsiElement)element, (String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suggestions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (suggestions.isEmpty()) {
            return null;
        }
        result.addAll(suggestions);
        Collection $this$toTypedArray$iv = suggestions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        return new SuggestedNameInfo(stringArray){

            public void nameChosen(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            }
        };
    }

    private final String getName(PsiElement element) {
        return element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
    }
}

