/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.impl.facet;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.python.community.plugin.impl.facet.PythonFacetUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import org.jetbrains.annotations.NotNull;

public class PythonSdkTableListener
implements ProjectJdkTable.Listener {
    public void jdkAdded(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkTableListener.$$$reportNull$$$0(0);
        }
        if (sdk.getSdkType() instanceof PythonSdkType) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                ModifiableModelsProvider provider = ModifiableModelsProvider.getInstance();
                LibraryTable.ModifiableModel libraryTableModifiableModel = provider.getLibraryTableModifiableModel();
                Library library = libraryTableModifiableModel.getLibraryByName(PythonFacetUtil.getFacetLibraryName(sdk.getName()));
                provider.disposeLibraryTableModifiableModel(libraryTableModifiableModel);
                if (library == null) {
                    PythonSdkTableListener.addLibrary(sdk);
                } else {
                    PythonSdkTableListener.updateLibrary(sdk);
                }
            }));
        }
    }

    public void jdkRemoved(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkTableListener.$$$reportNull$$$0(1);
        }
        if (sdk.getSdkType() instanceof PythonSdkType) {
            PythonSdkTableListener.removeLibrary(sdk);
        }
    }

    public void jdkNameChanged(@NotNull Sdk sdk, @NotNull String previousName) {
        if (sdk == null) {
            PythonSdkTableListener.$$$reportNull$$$0(2);
        }
        if (previousName == null) {
            PythonSdkTableListener.$$$reportNull$$$0(3);
        }
        if (sdk.getSdkType() instanceof PythonSdkType) {
            PythonSdkTableListener.renameLibrary(sdk, previousName);
        }
    }

    static Library addLibrary(Sdk sdk) {
        LibraryTable.ModifiableModel libraryTableModel = ModifiableModelsProvider.getInstance().getLibraryTableModifiableModel();
        Library library = libraryTableModel.createLibrary(PythonFacetUtil.getFacetLibraryName(sdk.getName()));
        Library.ModifiableModel model = library.getModifiableModel();
        for (String url : sdk.getRootProvider().getUrls(OrderRootType.CLASSES)) {
            model.addRoot(url, OrderRootType.CLASSES);
            model.addRoot(url, OrderRootType.SOURCES);
        }
        model.commit();
        libraryTableModel.commit();
        return library;
    }

    static void updateLibrary(Sdk sdk) {
        LibraryTable.ModifiableModel libraryTableModel = ModifiableModelsProvider.getInstance().getLibraryTableModifiableModel();
        Library library = libraryTableModel.getLibraryByName(PythonFacetUtil.getFacetLibraryName(sdk.getName()));
        if (library == null) {
            return;
        }
        Library.ModifiableModel model = library.getModifiableModel();
        for (String url : library.getRootProvider().getUrls(OrderRootType.CLASSES)) {
            model.removeRoot(url, OrderRootType.CLASSES);
        }
        for (String url : library.getRootProvider().getUrls(OrderRootType.SOURCES)) {
            model.removeRoot(url, OrderRootType.SOURCES);
        }
        for (String url : sdk.getRootProvider().getUrls(OrderRootType.CLASSES)) {
            model.addRoot(url, OrderRootType.CLASSES);
            model.addRoot(url, OrderRootType.SOURCES);
        }
        model.commit();
        libraryTableModel.commit();
    }

    private static void removeLibrary(Sdk sdk) {
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            LibraryTable.ModifiableModel libraryTableModel = ModifiableModelsProvider.getInstance().getLibraryTableModifiableModel();
            Library library = libraryTableModel.getLibraryByName(PythonFacetUtil.getFacetLibraryName(sdk.getName()));
            if (library != null) {
                libraryTableModel.removeLibrary(library);
            }
            libraryTableModel.commit();
        }), ModalityState.nonModal());
    }

    private static void renameLibrary(Sdk sdk, String previousName) {
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            LibraryTable.ModifiableModel libraryTableModel = ModifiableModelsProvider.getInstance().getLibraryTableModifiableModel();
            Library library = libraryTableModel.getLibraryByName(PythonFacetUtil.getFacetLibraryName(previousName));
            if (library != null) {
                Library.ModifiableModel model = library.getModifiableModel();
                model.setName(PythonFacetUtil.getFacetLibraryName(sdk.getName()));
                model.commit();
            }
            libraryTableModel.commit();
        }), ModalityState.nonModal());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/community/plugin/impl/facet/PythonSdkTableListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "jdkAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "jdkRemoved";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "jdkNameChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

