/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.inference;

import java.util.EnumMap;
import java.util.EnumSet;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class DisplayedInferencePreferences {
    public static final String USER_READABLE_ID = "Displayed Inference Preferences";
    public static final String SHOW_INFERENCES_KEY = "SHOW_INFERENCES";
    private long startOperationTime;
    private boolean showInferences;
    private EnumSet<ReasonerPreferences.OptionalInferenceTask> enabled = EnumSet.noneOf(ReasonerPreferences.OptionalInferenceTask.class);
    private EnumMap<ReasonerPreferences.OptionalInferenceTask, Integer> clockMap = new EnumMap(ReasonerPreferences.OptionalInferenceTask.class);
    private EnumMap<ReasonerPreferences.OptionalInferenceTask, Integer> countMap = new EnumMap(ReasonerPreferences.OptionalInferenceTask.class);

    public void load(ReasonerPreferences p) {
        Preferences prefs = ReasonerPreferences.getPreferences();
        this.showInferences = prefs.getBoolean(SHOW_INFERENCES_KEY, true);
        this.enabled.clear();
        for (ReasonerPreferences.OptionalInferenceTask task : ReasonerPreferences.OptionalInferenceTask.values()) {
            if (!prefs.getBoolean(task.getKey(), task.getEnabledByDefault())) continue;
            this.enabled.add(task);
        }
        this.registerPrecomputedInferenceTypes(p);
    }

    public void save(ReasonerPreferences p) {
        Preferences prefs = ReasonerPreferences.getPreferences();
        prefs.putBoolean(SHOW_INFERENCES_KEY, this.showInferences);
        for (ReasonerPreferences.OptionalInferenceTask task : ReasonerPreferences.OptionalInferenceTask.values()) {
            prefs.putBoolean(task.getKey(), this.enabled.contains((Object)task));
        }
        this.registerPrecomputedInferenceTypes(p);
    }

    private void registerPrecomputedInferenceTypes(ReasonerPreferences p) {
        EnumSet<InferenceType> types = EnumSet.noneOf(InferenceType.class);
        for (ReasonerPreferences.OptionalInferenceTask task : ReasonerPreferences.OptionalInferenceTask.values()) {
            InferenceType type;
            if (!this.enabled.contains((Object)task) || (type = task.getSuggestedInferenceType()) == null) continue;
            types.add(type);
        }
        p.requestPrecomputedInferences(USER_READABLE_ID, types);
    }

    public boolean isShowInferences() {
        return this.showInferences;
    }

    public void setShowInferences(boolean showInferences) {
        this.showInferences = showInferences;
    }

    public void startClock(ReasonerPreferences.OptionalInferenceTask task) {
        this.startOperationTime = System.currentTimeMillis();
    }

    public void stopClock(ReasonerPreferences.OptionalInferenceTask task) {
        int duration = (int)(System.currentTimeMillis() - this.startOperationTime);
        this.countMap.put(task, this.getCallCount(task) + 1);
        this.clockMap.put(task, this.getTimeInTask(task) + duration);
    }

    public int getTimeInTask(ReasonerPreferences.OptionalInferenceTask task) {
        Integer duration = this.clockMap.get((Object)task);
        if (duration == null) {
            duration = 0;
        }
        return duration;
    }

    public int getAverageTimeInTask(ReasonerPreferences.OptionalInferenceTask task) {
        int count = this.getCallCount(task);
        if (count == 0) {
            return 0;
        }
        return this.getTimeInTask(task) / count;
    }

    private int getCallCount(ReasonerPreferences.OptionalInferenceTask task) {
        Integer count = this.countMap.get((Object)task);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    public boolean isEnabled(ReasonerPreferences.OptionalInferenceTask task) {
        return this.enabled.contains((Object)task);
    }

    public void setEnabled(ReasonerPreferences.OptionalInferenceTask task, boolean isEnabled) {
        if (isEnabled) {
            this.enabled.add(task);
        } else {
            this.enabled.remove((Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(ReasonerPreferences.OptionalInferenceTask task, Runnable implementation) {
        if (this.isShowInferences() && this.isEnabled(task)) {
            this.startClock(task);
            try {
                implementation.run();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            finally {
                this.stopClock(task);
            }
        }
    }
}

