/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class OpacityManager
extends AbstractValueManager {
    protected boolean inherited;
    protected String property;

    public OpacityManager(String string, boolean bl) {
        this.property = string;
        this.inherited = bl;
    }

    public boolean isInheritedProperty() {
        return this.inherited;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public int getPropertyType() {
        return 25;
    }

    public String getPropertyName() {
        return this.property;
    }

    public Value getDefaultValue() {
        return SVGValueConstants.NUMBER_1;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 13: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    public Value createFloatValue(short s, float f) throws DOMException {
        if (s == 1) {
            return new FloatValue(s, f);
        }
        throw this.createInvalidFloatTypeDOMException(s);
    }
}

