/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.api.list;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.resources.ResourceAccessHandler;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.resources.SharingRecord;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.transport.client.node.NodeClient;

public class AccessibleResourcesRestAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(AccessibleResourcesRestAction.class);
    private final ResourceAccessHandler resourceAccessHandler;
    private final ResourcePluginInfo resourcePluginInfo;
    private final OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting;

    public AccessibleResourcesRestAction(ResourceAccessHandler resourceAccessHandler, ResourcePluginInfo resourcePluginInfo, OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting) {
        this.resourceAccessHandler = resourceAccessHandler;
        this.resourcePluginInfo = resourcePluginInfo;
        this.resourceSharingEnabledSetting = resourceSharingEnabledSetting;
    }

    public List<RestHandler.Route> routes() {
        return Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/list")), "/_plugins/_security/api/resource");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.resourceSharingEnabledSetting.getDynamicSettingValue().booleanValue()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_IMPLEMENTED, "Feature disabled."));
        }
        String resourceType = Objects.requireNonNull(request.param("resource_type"), "resource_type is required");
        String resourceIndex = this.resourcePluginInfo.indexByType(resourceType);
        if (resourceIndex == null) {
            return channel -> this.handleResponse((RestChannel)channel, Set.of());
        }
        return channel -> this.resourceAccessHandler.getResourceSharingInfoForCurrentUser(resourceType, (ActionListener<Set<SharingRecord>>)ActionListener.wrap(rows -> this.handleResponse((RestChannel)channel, (Set<SharingRecord>)rows), e -> this.handleError((RestChannel)channel, (Exception)e)));
    }

    private void handleResponse(RestChannel channel, Set<SharingRecord> records) throws IOException {
        try (XContentBuilder b = channel.newBuilder();){
            b.startObject();
            b.startArray("resources");
            for (SharingRecord row : records) {
                row.toXContent(b, ToXContent.EMPTY_PARAMS);
            }
            b.endArray();
            b.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, b));
        }
        catch (IOException ioe) {
            this.handleError(channel, ioe);
        }
    }

    private void handleError(RestChannel channel, Exception e) {
        LOGGER.error("Error while processing request", (Throwable)e);
        String message = e.getMessage();
        if (e instanceof OpenSearchStatusException) {
            OpenSearchStatusException ex = (OpenSearchStatusException)e;
            Responses.response(channel, ex.status(), message);
        } else {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, message));
        }
    }
}

