/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.messaging.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.error.TypedMessageErrorHandler;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.util.SOAPSupport;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;

public class SOAP11FaultContextDecoratingErrorHandler
implements TypedMessageErrorHandler {
    @Nonnull
    private Class<? extends Throwable> handledThrowable;
    @Nonnull
    private QName faultCode;
    @Nonnull
    private String faultString;
    @Nullable
    private String faultActor;
    @Nullable
    private String wsAddressingActionURI;

    public SOAP11FaultContextDecoratingErrorHandler(@Nonnull Class<? extends Throwable> throwable, @Nonnull QName code, @Nonnull String message) {
        this(throwable, code, message, null, null);
    }

    public SOAP11FaultContextDecoratingErrorHandler(@Nonnull Class<? extends Throwable> throwable, @Nonnull QName code, @Nonnull String message, @Nullable String actor, @Nullable String addressingActionURI) {
        this.handledThrowable = Constraint.isNotNull(throwable, "Handled Throwable type cannot be null");
        this.faultCode = Constraint.isNotNull(code, "Fault code cannot be null");
        this.faultString = Constraint.isNotNull(StringSupport.trim(message), "Fault string cannot be null or empty");
        this.faultActor = StringSupport.trimOrNull(actor);
        this.wsAddressingActionURI = StringSupport.trimOrNull(addressingActionURI);
    }

    @Override
    public boolean handlesError(@Nonnull Throwable t) {
        return this.handledThrowable.isInstance(t);
    }

    @Override
    public boolean handleError(@Nonnull Throwable t, @Nonnull MessageContext messageContext) {
        Fault fault = SOAPSupport.buildSOAP11Fault(this.faultCode, this.faultString, this.faultActor, null, null);
        SOAPMessagingSupport.registerSOAP11Fault(messageContext, fault);
        if (this.wsAddressingActionURI != null) {
            messageContext.ensureSubcontext(WSAddressingContext.class).setFaultActionURI(this.wsAddressingActionURI);
        }
        return true;
    }
}

