/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class BaseClientToAMTokenSecretManager
extends SecretManager<ClientToAMTokenIdentifier> {
    @InterfaceAudience.Private
    public abstract SecretKey getMasterKey(ApplicationAttemptId var1);

    @Override
    @InterfaceAudience.Private
    public synchronized byte[] createPassword(ClientToAMTokenIdentifier identifier) {
        return BaseClientToAMTokenSecretManager.createPassword(identifier.getBytes(), this.getMasterKey(identifier.getApplicationAttemptID()));
    }

    @Override
    @InterfaceAudience.Private
    public byte[] retrievePassword(ClientToAMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        SecretKey masterKey = this.getMasterKey(identifier.getApplicationAttemptID());
        if (masterKey == null) {
            throw new SecretManager.InvalidToken("Illegal client-token!");
        }
        return BaseClientToAMTokenSecretManager.createPassword(identifier.getBytes(), masterKey);
    }

    @Override
    @InterfaceAudience.Private
    public ClientToAMTokenIdentifier createIdentifier() {
        return new ClientToAMTokenIdentifier();
    }
}

