/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.http.HttpRequest;
import org.opensearch.http.netty4.HttpResponseHeadersFactory;
import org.opensearch.http.netty4.Netty4HttpResponse;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.netty4.Netty4Utils;

public class Netty4HttpRequest
implements HttpRequest {
    private final FullHttpRequest request;
    private final BytesReference content;
    private final HttpHeadersMap headers;
    private final AtomicBoolean released;
    private final Exception inboundException;
    private final boolean pooled;
    private final HttpResponseHeadersFactory responseHeadersFactory;

    Netty4HttpRequest(FullHttpRequest request, HttpResponseHeadersFactory responseHeadersFactory) {
        this(request, new HttpHeadersMap(request.headers()), new AtomicBoolean(false), true, Netty4Utils.toBytesReference((ByteBuf)request.content()), responseHeadersFactory);
    }

    Netty4HttpRequest(FullHttpRequest request, Exception inboundException, HttpResponseHeadersFactory responseHeadersFactory) {
        this(request, new HttpHeadersMap(request.headers()), new AtomicBoolean(false), true, Netty4Utils.toBytesReference((ByteBuf)request.content()), inboundException, responseHeadersFactory);
    }

    private Netty4HttpRequest(FullHttpRequest request, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, BytesReference content, HttpResponseHeadersFactory responseHeadersFactory) {
        this(request, headers, released, pooled, content, null, responseHeadersFactory);
    }

    private Netty4HttpRequest(FullHttpRequest request, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, BytesReference content, Exception inboundException, HttpResponseHeadersFactory responseHeadersFactory) {
        this.request = request;
        this.headers = headers;
        this.content = content;
        this.pooled = pooled;
        this.released = released;
        this.inboundException = inboundException;
        this.responseHeadersFactory = responseHeadersFactory;
    }

    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.method();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        if (httpMethod == HttpMethod.PATCH) {
            return RestRequest.Method.PATCH;
        }
        if (httpMethod == HttpMethod.TRACE) {
            return RestRequest.Method.TRACE;
        }
        if (httpMethod == HttpMethod.CONNECT) {
            return RestRequest.Method.CONNECT;
        }
        throw new IllegalArgumentException("Unexpected http method: " + String.valueOf(httpMethod));
    }

    public String uri() {
        return this.request.uri();
    }

    public BytesReference content() {
        assert (!this.released.get());
        return this.content;
    }

    public void release() {
        if (this.pooled && this.released.compareAndSet(false, true)) {
            this.request.release();
        }
    }

    public HttpRequest releaseAndCopy() {
        assert (!this.released.get());
        if (!this.pooled) {
            return this;
        }
        try {
            ByteBuf copiedContent = Unpooled.copiedBuffer((ByteBuf)this.request.content());
            Netty4HttpRequest netty4HttpRequest = new Netty4HttpRequest((FullHttpRequest)new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), copiedContent, this.request.headers(), this.request.trailingHeaders()), this.headers, new AtomicBoolean(false), false, Netty4Utils.toBytesReference((ByteBuf)copiedContent), this.responseHeadersFactory);
            return netty4HttpRequest;
        }
        finally {
            this.release();
        }
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> strictCookies() {
        Set cookies;
        String cookieString = this.request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString != null && !(cookies = ServerCookieDecoder.STRICT.decode(cookieString)).isEmpty()) {
            return ServerCookieEncoder.STRICT.encode((Collection)cookies);
        }
        return Collections.emptyList();
    }

    public HttpRequest.HttpVersion protocolVersion() {
        if (this.request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            return HttpRequest.HttpVersion.HTTP_1_0;
        }
        if (this.request.protocolVersion().equals((Object)HttpVersion.HTTP_1_1)) {
            return HttpRequest.HttpVersion.HTTP_1_1;
        }
        if (this.request.protocolVersion().equals((Object)"HTTP/2.0")) {
            return HttpRequest.HttpVersion.HTTP_2_0;
        }
        if (this.request.protocolVersion().equals((Object)"HTTP/3.0")) {
            return HttpRequest.HttpVersion.HTTP_3_0;
        }
        throw new IllegalArgumentException("Unexpected http protocol version: " + String.valueOf(this.request.protocolVersion()));
    }

    public HttpRequest removeHeader(String header) {
        DefaultHttpHeaders headersWithoutContentTypeHeader = new DefaultHttpHeaders();
        headersWithoutContentTypeHeader.add(this.request.headers());
        headersWithoutContentTypeHeader.remove(header);
        DefaultHttpHeaders trailingHeaders = new DefaultHttpHeaders();
        trailingHeaders.add(this.request.trailingHeaders());
        trailingHeaders.remove(header);
        DefaultFullHttpRequest requestWithoutHeader = new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), this.request.content(), (HttpHeaders)headersWithoutContentTypeHeader, (HttpHeaders)trailingHeaders);
        return new Netty4HttpRequest((FullHttpRequest)requestWithoutHeader, new HttpHeadersMap(requestWithoutHeader.headers()), this.released, this.pooled, this.content, this.responseHeadersFactory);
    }

    public Netty4HttpResponse createResponse(RestStatus status, BytesReference content) {
        Netty4HttpResponse response = new Netty4HttpResponse(this.request.headers(), this.request.protocolVersion(), status, content);
        this.responseHeadersFactory.headers(this.protocolVersion()).forEach(response::addHeader);
        return response;
    }

    public Exception getInboundException() {
        return this.inboundException;
    }

    public FullHttpRequest nettyRequest() {
        return this.request;
    }

    private static class HttpHeadersMap
    implements Map<String, List<String>> {
        private final HttpHeaders httpHeaders;

        private HttpHeadersMap(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        @Override
        public int size() {
            return this.httpHeaders.size();
        }

        @Override
        public boolean isEmpty() {
            return this.httpHeaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            String string;
            return key instanceof String && this.httpHeaders.contains(string = (String)key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof List)) return false;
            if (!this.httpHeaders.names().stream().map(arg_0 -> ((HttpHeaders)this.httpHeaders).getAll(arg_0)).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public List<String> get(Object key) {
            List list;
            if (key instanceof String) {
                String keyString = (String)key;
                list = this.httpHeaders.getAll(keyString);
            } else {
                list = null;
            }
            return list;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends List<String>> m) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public Set<String> keySet() {
            return this.httpHeaders.names();
        }

        @Override
        public Collection<List<String>> values() {
            return this.httpHeaders.names().stream().map(k -> Collections.unmodifiableList(this.httpHeaders.getAll(k))).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.httpHeaders.names().stream().map(k -> new AbstractMap.SimpleImmutableEntry<String, List>((String)k, this.httpHeaders.getAll(k))).collect(Collectors.toSet());
        }
    }
}

