/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.config.setting.handler;

import java.util.LinkedHashMap;
import java.util.Map;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingListener;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingsManager;
import org.opensearch.performanceanalyzer.config.setting.PerformanceAnalyzerClusterSettings;

public class PerformanceAnalyzerClusterSettingHandler
implements ClusterSettingListener<Integer> {
    private static final int BIT_ONE = 1;
    private static final int CLUSTER_SETTING_DISABLED_VALUE = 0;
    private static final int ENABLED_VALUE = 1;
    private static final int MAX_ALLOWED_BIT_POS = Math.min(PerformanceAnalyzerClusterSettings.PerformanceAnalyzerFeatureBits.values().length, 31);
    private static final int RCA_ENABLED_BIT_POS = PerformanceAnalyzerClusterSettings.PerformanceAnalyzerFeatureBits.RCA_BIT.ordinal();
    private static final int PA_ENABLED_BIT_POS = PerformanceAnalyzerClusterSettings.PerformanceAnalyzerFeatureBits.PA_BIT.ordinal();
    private static final int LOGGING_ENABLED_BIT_POS = PerformanceAnalyzerClusterSettings.PerformanceAnalyzerFeatureBits.LOGGING_BIT.ordinal();
    private static final int BATCH_METRICS_ENABLED_BIT_POS = PerformanceAnalyzerClusterSettings.PerformanceAnalyzerFeatureBits.BATCH_METRICS_BIT.ordinal();
    private static final int THREAD_CONTENTION_MONITORING_ENABLED_BIT_POS = PerformanceAnalyzerClusterSettings.PerformanceAnalyzerFeatureBits.THREAD_CONTENTION_MONITORING_BIT.ordinal();
    static final String PA_ENABLED_KEY = "PerformanceAnalyzerEnabled";
    static final String RCA_ENABLED_KEY = "RcaEnabled";
    static final String LOGGING_ENABLED_KEY = "LoggingEnabled";
    static final String BATCH_METRICS_ENABLED_KEY = "BatchMetricsEnabled";
    static final String THREAD_CONTENTION_MONITORING_ENABLED_KEY = "ThreadContentionMonitoringEnabled";
    private final PerformanceAnalyzerController controller;
    private final ClusterSettingsManager clusterSettingsManager;
    private Integer currentClusterSetting;

    public PerformanceAnalyzerClusterSettingHandler(PerformanceAnalyzerController controller, ClusterSettingsManager clusterSettingsManager) {
        this.controller = controller;
        this.clusterSettingsManager = clusterSettingsManager;
        this.currentClusterSetting = this.initializeClusterSettingValue(controller.isPerformanceAnalyzerEnabled(), controller.isRcaEnabled(), controller.isLoggingEnabled(), controller.isBatchMetricsEnabled(), controller.isThreadContentionMonitoringEnabled());
    }

    public void updatePerformanceAnalyzerSetting(boolean state) {
        Integer settingIntValue = this.getPASettingValueFromState(state);
        this.clusterSettingsManager.updateSetting(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, settingIntValue);
    }

    public void updateLoggingSetting(boolean state) {
        Integer settingIntValue = this.getLoggingSettingValueFromState(state);
        this.clusterSettingsManager.updateSetting(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, settingIntValue);
    }

    public void updateRcaSetting(boolean state) {
        Integer settingIntValue = this.getRcaSettingValueFromState(state);
        this.clusterSettingsManager.updateSetting(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, settingIntValue);
    }

    public void updateBatchMetricsSetting(boolean state) {
        Integer settingIntValue = this.getBatchMetricsSettingValueFromState(state);
        this.clusterSettingsManager.updateSetting(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, settingIntValue);
    }

    public void updateThreadContentionMonitoringSetting(boolean state) {
        Integer settingIntValue = this.getThreadContentionMonitoringSettingValueFromState(state);
        this.clusterSettingsManager.updateSetting(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, settingIntValue);
    }

    @Override
    public void onSettingUpdate(Integer newSettingValue) {
        this.currentClusterSetting = newSettingValue;
        if (newSettingValue != null) {
            this.controller.updatePerformanceAnalyzerState(this.getPAStateFromSetting(newSettingValue));
            this.controller.updateRcaState(this.getRcaStateFromSetting(newSettingValue));
            this.controller.updateLoggingState(this.getLoggingStateFromSetting(newSettingValue));
            this.controller.updateBatchMetricsState(this.getBatchMetricsStateFromSetting(newSettingValue));
            this.controller.updateThreadContentionMonitoringState(this.getThreadContentionMonitoringStateFromSetting(newSettingValue));
        }
    }

    public int getCurrentClusterSettingValue() {
        return this.currentClusterSetting;
    }

    public Map<String, Boolean> getCurrentClusterSettingValueVerbose() {
        LinkedHashMap<String, Boolean> statusMap = new LinkedHashMap<String, Boolean>();
        statusMap.put(PA_ENABLED_KEY, this.getPAStateFromSetting(this.currentClusterSetting));
        statusMap.put(RCA_ENABLED_KEY, this.getRcaStateFromSetting(this.currentClusterSetting));
        statusMap.put(LOGGING_ENABLED_KEY, this.getLoggingStateFromSetting(this.currentClusterSetting));
        statusMap.put(BATCH_METRICS_ENABLED_KEY, this.getBatchMetricsStateFromSetting(this.currentClusterSetting));
        statusMap.put(THREAD_CONTENTION_MONITORING_ENABLED_KEY, this.getThreadContentionMonitoringStateFromSetting(this.currentClusterSetting));
        return statusMap;
    }

    private Integer initializeClusterSettingValue(boolean paEnabled, boolean rcaEnabled, boolean loggingEnabled, boolean batchMetricsEnabled, boolean threadContentionMonitoringEnabled) {
        int clusterSetting = 0;
        int n = clusterSetting = paEnabled ? this.setBit(clusterSetting, PA_ENABLED_BIT_POS) : clusterSetting;
        if (paEnabled) {
            clusterSetting = rcaEnabled ? this.setBit(clusterSetting, RCA_ENABLED_BIT_POS) : clusterSetting;
            clusterSetting = loggingEnabled ? this.setBit(clusterSetting, LOGGING_ENABLED_BIT_POS) : clusterSetting;
            clusterSetting = batchMetricsEnabled ? this.setBit(clusterSetting, BATCH_METRICS_ENABLED_BIT_POS) : clusterSetting;
            clusterSetting = threadContentionMonitoringEnabled ? this.setBit(clusterSetting, THREAD_CONTENTION_MONITORING_ENABLED_BIT_POS) : clusterSetting;
        }
        return clusterSetting;
    }

    private boolean getPAStateFromSetting(int settingValue) {
        return (settingValue >> PA_ENABLED_BIT_POS & 1) == 1;
    }

    private Integer getPASettingValueFromState(boolean state) {
        int clusterSetting = this.currentClusterSetting;
        if (state) {
            return this.setBit(clusterSetting, PA_ENABLED_BIT_POS);
        }
        return this.resetBit(this.resetBit(this.resetBit(this.resetBit(this.resetBit(clusterSetting, PA_ENABLED_BIT_POS), RCA_ENABLED_BIT_POS), LOGGING_ENABLED_BIT_POS), BATCH_METRICS_ENABLED_BIT_POS), THREAD_CONTENTION_MONITORING_ENABLED_BIT_POS);
    }

    private boolean getRcaStateFromSetting(int settingValue) {
        return (settingValue >> RCA_ENABLED_BIT_POS & 1) == 1;
    }

    private boolean getLoggingStateFromSetting(int settingValue) {
        return (settingValue >> LOGGING_ENABLED_BIT_POS & 1) == 1;
    }

    private boolean getBatchMetricsStateFromSetting(int settingValue) {
        return (settingValue >> BATCH_METRICS_ENABLED_BIT_POS & 1) == 1;
    }

    private boolean getThreadContentionMonitoringStateFromSetting(int settingValue) {
        return (settingValue >> THREAD_CONTENTION_MONITORING_ENABLED_BIT_POS & 1) == 1;
    }

    private Integer getRcaSettingValueFromState(boolean shouldEnable) {
        int clusterSetting = this.currentClusterSetting;
        if (shouldEnable) {
            return PerformanceAnalyzerClusterSettingHandler.checkBit(this.currentClusterSetting, PA_ENABLED_BIT_POS) ? this.setBit(clusterSetting, RCA_ENABLED_BIT_POS) : clusterSetting;
        }
        return this.resetBit(clusterSetting, RCA_ENABLED_BIT_POS);
    }

    private Integer getLoggingSettingValueFromState(boolean shouldEnable) {
        int clusterSetting = this.currentClusterSetting;
        if (shouldEnable) {
            return PerformanceAnalyzerClusterSettingHandler.checkBit(this.currentClusterSetting, PA_ENABLED_BIT_POS) ? this.setBit(clusterSetting, LOGGING_ENABLED_BIT_POS) : clusterSetting;
        }
        return this.resetBit(clusterSetting, LOGGING_ENABLED_BIT_POS);
    }

    private Integer getBatchMetricsSettingValueFromState(boolean shouldEnable) {
        int clusterSetting = this.currentClusterSetting;
        if (shouldEnable) {
            return PerformanceAnalyzerClusterSettingHandler.checkBit(this.currentClusterSetting, PA_ENABLED_BIT_POS) ? this.setBit(clusterSetting, BATCH_METRICS_ENABLED_BIT_POS) : clusterSetting;
        }
        return this.resetBit(clusterSetting, BATCH_METRICS_ENABLED_BIT_POS);
    }

    private Integer getThreadContentionMonitoringSettingValueFromState(boolean shouldEnable) {
        int clusterSetting = this.currentClusterSetting;
        if (shouldEnable) {
            return PerformanceAnalyzerClusterSettingHandler.checkBit(this.currentClusterSetting, PA_ENABLED_BIT_POS) ? this.setBit(clusterSetting, THREAD_CONTENTION_MONITORING_ENABLED_BIT_POS) : clusterSetting;
        }
        return this.resetBit(clusterSetting, THREAD_CONTENTION_MONITORING_ENABLED_BIT_POS);
    }

    private int setBit(int number, int bitPosition) {
        return bitPosition < MAX_ALLOWED_BIT_POS ? number | 1 << bitPosition : number;
    }

    private int resetBit(int number, int bitPosition) {
        return bitPosition < MAX_ALLOWED_BIT_POS ? number & ~(1 << bitPosition) : number;
    }

    public static boolean checkBit(int clusterSettingValue, int bitPosition) {
        return bitPosition < MAX_ALLOWED_BIT_POS && (clusterSettingValue & 1 << bitPosition) > 0;
    }
}

