/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jooq.Catalog;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Schema;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.tools.StringUtils;

public class CatalogImpl
extends AbstractQueryPart
implements Catalog {
    private static final long serialVersionUID = -3650318934053960244L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CATALOG, Clause.CATALOG_REFERENCE};
    private final Name name;

    public CatalogImpl(Name name) {
        this.name = name;
    }

    public CatalogImpl(String name) {
        this(DSL.name(name));
    }

    @Override
    public final String getName() {
        return this.name.last();
    }

    @Override
    public final Name getQualifiedName() {
        return this.name;
    }

    @Override
    public final Name getUnqualifiedName() {
        return this.name.unqualifiedName();
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.name.unqualifiedName());
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Schema getSchema(String schemaName) {
        for (Schema schema : this.getSchemas()) {
            if (!schema.getName().equals(schemaName)) continue;
            return schema;
        }
        return null;
    }

    @Override
    public List<Schema> getSchemas() {
        return Collections.emptyList();
    }

    @Override
    public final Stream<Schema> schemaStream() {
        return this.getSchemas().stream();
    }

    @Override
    public int hashCode() {
        return this.getQualifiedName() != null ? this.getQualifiedName().hashCode() : 0;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof CatalogImpl) {
            return StringUtils.equals(this.getQualifiedName(), ((CatalogImpl)that).getQualifiedName());
        }
        return super.equals(that);
    }
}

