/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class ECDSASignOutput {
    private final ByteBuffer signature;

    protected ECDSASignOutput(BuilderImpl builder) {
        this.signature = builder.signature();
    }

    public ByteBuffer signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer signature;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ECDSASignOutput model) {
            this.signature = model.signature();
        }

        @Override
        public Builder signature(ByteBuffer signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public ByteBuffer signature() {
            return this.signature;
        }

        @Override
        public ECDSASignOutput build() {
            if (Objects.isNull(this.signature())) {
                throw new IllegalArgumentException("Missing value for required field `signature`");
            }
            return new ECDSASignOutput(this);
        }
    }

    public static interface Builder {
        public Builder signature(ByteBuffer var1);

        public ByteBuffer signature();

        public ECDSASignOutput build();
    }
}

