/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.evaluation.Evaluation;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.provenance.OutputFactoryProvenance;

public interface OutputFactory<T extends Output<T>>
extends Configurable,
Provenancable<OutputFactoryProvenance>,
Serializable {
    public <V> T generateOutput(V var1);

    public T getUnknownOutput();

    public MutableOutputInfo<T> generateInfo();

    public ImmutableOutputInfo<T> constructInfoForExternalModel(Map<T, Integer> var1);

    public Evaluator<T, ? extends Evaluation<T>> getEvaluator();

    default public <V> List<T> generateOutputs(List<V> inputs) {
        ArrayList<T> outputs = new ArrayList<T>();
        for (V input : inputs) {
            outputs.add(this.generateOutput(input));
        }
        return outputs;
    }

    public static <T extends Output<T>> void validateMapping(Map<T, Integer> mapping) {
        HashMap<Integer, T> reverse = new HashMap<Integer, T>();
        for (Map.Entry<T, Integer> e : mapping.entrySet()) {
            if (e.getValue() < 0 || e.getValue() >= mapping.size()) {
                throw new IllegalArgumentException("Invalid mapping, expected an integer between 0 and mapping.size(), received " + e.getValue());
            }
            Output l = (Output)reverse.put(e.getValue(), e.getKey());
            if (l == null) continue;
            throw new IllegalArgumentException("Invalid mapping, both " + e.getKey() + " and " + l + " map to " + e.getValue());
        }
        if (reverse.size() != mapping.size()) {
            throw new IllegalArgumentException("The Output<->Integer mapping is not a bijection, reverse mapping had " + reverse.size() + " elements, forward mapping had " + mapping.size() + " elements.");
        }
    }
}

