/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cloud.azure.classic.management;

import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.DefaultBuilder;
import com.microsoft.windowsazure.core.utils.KeyStoreType;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.models.HostedServiceGetDetailedResponse;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import java.io.IOException;
import java.net.URI;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.SpecialPermission;
import org.opensearch.cloud.azure.classic.AzureServiceRemoteException;
import org.opensearch.cloud.azure.classic.management.AzureComputeService;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.secure_sm.AccessController;

public class AzureComputeServiceImpl
extends AbstractLifecycleComponent
implements AzureComputeService {
    private static final Logger logger = LogManager.getLogger(AzureComputeServiceImpl.class);
    private final ComputeManagementClient client;
    private final String serviceName;

    public AzureComputeServiceImpl(Settings settings) {
        String subscriptionId = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.SUBSCRIPTION_ID_SETTING);
        this.serviceName = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.SERVICE_NAME_SETTING);
        String keystorePath = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.KEYSTORE_PATH_SETTING);
        String keystorePassword = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.KEYSTORE_PASSWORD_SETTING);
        KeyStoreType keystoreType = (KeyStoreType)AzureComputeService.Management.KEYSTORE_TYPE_SETTING.get(settings);
        logger.trace("creating new Azure client for [{}], [{}]", (Object)subscriptionId, (Object)this.serviceName);
        try {
            DefaultBuilder builder = new DefaultBuilder();
            for (Builder.Exports exports : ServiceLoader.load(Builder.Exports.class, this.getClass().getClassLoader())) {
                exports.register((Builder.Registry)builder);
            }
            Configuration configuration = new Configuration((Builder)builder);
            configuration.setProperty("com.microsoft.windowsazure.Configuration.logHttpRequests", (Object)logger.isTraceEnabled());
            Configuration managementConfig = ManagementConfiguration.configure(null, (Configuration)configuration, (URI)((URI)AzureComputeService.Management.ENDPOINT_SETTING.get(settings)), (String)subscriptionId, (String)keystorePath, (String)keystorePassword, (KeyStoreType)keystoreType);
            logger.debug("creating new Azure client for [{}], [{}]", (Object)subscriptionId, (Object)this.serviceName);
            this.client = ComputeManagementService.create((Configuration)managementConfig);
        }
        catch (IOException e) {
            throw new OpenSearchException("Unable to configure Azure compute service", (Throwable)e, new Object[0]);
        }
    }

    private static String getRequiredSetting(Settings settings, Setting<String> setting) {
        String value = (String)setting.get(settings);
        if (value == null || !Strings.hasLength((String)value)) {
            throw new IllegalArgumentException("Missing required setting " + setting.getKey() + " for azure");
        }
        return value;
    }

    @Override
    public HostedServiceGetDetailedResponse getServiceDetails() {
        SpecialPermission.check();
        try {
            return (HostedServiceGetDetailedResponse)AccessController.doPrivilegedChecked(() -> this.client.getHostedServicesOperations().getDetailed(this.serviceName));
        }
        catch (Exception e) {
            throw new AzureServiceRemoteException("can not get list of azure nodes", e);
        }
    }

    protected void doStart() throws OpenSearchException {
    }

    protected void doStop() throws OpenSearchException {
    }

    protected void doClose() throws OpenSearchException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                logger.error("error while closing Azure client", (Throwable)e);
            }
        }
    }
}

