/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.commons.alerting.model.InputRunResults;
import org.opensearch.commons.alerting.model.MonitorRunResultKt;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.TriggerRunResult;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 =*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0001=BQ\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012B\u0011\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0015J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u0004\u0018\u00010'J\u0016\u0010(\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\t\u0010/\u001a\u00020\u0006H\u00c6\u0003J\t\u00100\u001a\u00020\bH\u00c6\u0003J\t\u00101\u001a\u00020\bH\u00c6\u0003J\u0011\u00102\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fH\u00c6\u0003J\t\u00103\u001a\u00020\u000eH\u00c6\u0003J\u0015\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0010H\u00c6\u0003J_\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0010H\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u00d6\u0003J\t\u0010:\u001a\u00020;H\u00d6\u0001J\t\u0010<\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0019\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006>"}, d2={"Lorg/opensearch/commons/alerting/model/MonitorRunResult;", "TriggerResult", "Lorg/opensearch/commons/alerting/model/TriggerRunResult;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "monitorName", "", "periodStart", "Ljava/time/Instant;", "periodEnd", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "inputResults", "Lorg/opensearch/commons/alerting/model/InputRunResults;", "triggerResults", "", "<init>", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Exception;Lorg/opensearch/commons/alerting/model/InputRunResults;Ljava/util/Map;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getMonitorName", "()Ljava/lang/String;", "getPeriodStart", "()Ljava/time/Instant;", "getPeriodEnd", "getError", "()Ljava/lang/Exception;", "getInputResults", "()Lorg/opensearch/commons/alerting/model/InputRunResults;", "getTriggerResults", "()Ljava/util/Map;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "alertError", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "scriptContextError", "trigger", "Lorg/opensearch/commons/alerting/model/Trigger;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "common-utils"})
public final class MonitorRunResult<TriggerResult extends TriggerRunResult>
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String monitorName;
    @NotNull
    private final Instant periodStart;
    @NotNull
    private final Instant periodEnd;
    @Nullable
    private final Exception error;
    @NotNull
    private final InputRunResults inputResults;
    @NotNull
    private final Map<String, TriggerResult> triggerResults;

    public MonitorRunResult(@NotNull String monitorName, @NotNull Instant periodStart, @NotNull Instant periodEnd, @Nullable Exception error, @NotNull InputRunResults inputResults, @NotNull Map<String, ? extends TriggerResult> triggerResults) {
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkNotNullParameter((Object)inputResults, (String)"inputResults");
        Intrinsics.checkNotNullParameter(triggerResults, (String)"triggerResults");
        this.monitorName = monitorName;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.error = error;
        this.inputResults = inputResults;
        this.triggerResults = triggerResults;
    }

    public /* synthetic */ MonitorRunResult(String string, Instant instant, Instant instant2, Exception exception, InputRunResults inputRunResults, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            exception = null;
        }
        if ((n & 0x10) != 0) {
            inputRunResults = new InputRunResults(null, null, null, 7, null);
        }
        if ((n & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, instant, instant2, exception, inputRunResults, map);
    }

    @NotNull
    public final String getMonitorName() {
        return this.monitorName;
    }

    @NotNull
    public final Instant getPeriodStart() {
        return this.periodStart;
    }

    @NotNull
    public final Instant getPeriodEnd() {
        return this.periodEnd;
    }

    @Nullable
    public final Exception getError() {
        return this.error;
    }

    @NotNull
    public final InputRunResults getInputResults() {
        return this.inputResults;
    }

    @NotNull
    public final Map<String, TriggerResult> getTriggerResults() {
        return this.triggerResults;
    }

    public MonitorRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        Instant instant2 = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"readInstant(...)");
        Exception exception = sin.readException();
        InputRunResults inputRunResults = InputRunResults.Companion.readFrom(sin);
        Map<String, TriggerRunResult> map = Companion.suppressWarning(sin.readMap());
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, TriggerResult of org.opensearch.commons.alerting.model.MonitorRunResult>");
        this(string, instant, instant2, exception, inputRunResults, map);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().field("monitor_name", this.monitorName);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        Exception exception = this.error;
        XContentBuilder xContentBuilder2 = IndexUtilsKt.optionalTimeField(IndexUtilsKt.optionalTimeField(xContentBuilder, "period_start", this.periodStart), "period_end", this.periodEnd).field("error", exception != null ? exception.getMessage() : null).field("input_results", (ToXContent)this.inputResults).field("trigger_results", this.triggerResults).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    @Nullable
    public final AlertError alertError() {
        if (this.error != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            return new AlertError(instant, "Failed running monitor:\n" + MonitorRunResultKt.userErrorMessage(this.error));
        }
        if (this.inputResults.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            return new AlertError(instant, "Failed fetching inputs:\n" + MonitorRunResultKt.userErrorMessage(this.inputResults.getError()));
        }
        return null;
    }

    @Nullable
    public final Exception scriptContextError(@NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Exception exception = this.error;
        if (exception == null && (exception = this.inputResults.getError()) == null) {
            TriggerRunResult triggerRunResult = (TriggerRunResult)this.triggerResults.get(trigger.getId());
            exception = triggerRunResult != null ? triggerRunResult.getError() : null;
        }
        return exception;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.monitorName);
        out.writeInstant(this.periodStart);
        out.writeInstant(this.periodEnd);
        out.writeException((Throwable)this.error);
        this.inputResults.writeTo(out);
        out.writeMap(this.triggerResults);
    }

    @NotNull
    public final String component1() {
        return this.monitorName;
    }

    @NotNull
    public final Instant component2() {
        return this.periodStart;
    }

    @NotNull
    public final Instant component3() {
        return this.periodEnd;
    }

    @Nullable
    public final Exception component4() {
        return this.error;
    }

    @NotNull
    public final InputRunResults component5() {
        return this.inputResults;
    }

    @NotNull
    public final Map<String, TriggerResult> component6() {
        return this.triggerResults;
    }

    @NotNull
    public final MonitorRunResult<TriggerResult> copy(@NotNull String monitorName, @NotNull Instant periodStart, @NotNull Instant periodEnd, @Nullable Exception error, @NotNull InputRunResults inputResults, @NotNull Map<String, ? extends TriggerResult> triggerResults) {
        Intrinsics.checkNotNullParameter((Object)monitorName, (String)"monitorName");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        Intrinsics.checkNotNullParameter((Object)inputResults, (String)"inputResults");
        Intrinsics.checkNotNullParameter(triggerResults, (String)"triggerResults");
        return new MonitorRunResult<TriggerResult>(monitorName, periodStart, periodEnd, error, inputResults, triggerResults);
    }

    public static /* synthetic */ MonitorRunResult copy$default(MonitorRunResult monitorRunResult, String string, Instant instant, Instant instant2, Exception exception, InputRunResults inputRunResults, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = monitorRunResult.monitorName;
        }
        if ((n & 2) != 0) {
            instant = monitorRunResult.periodStart;
        }
        if ((n & 4) != 0) {
            instant2 = monitorRunResult.periodEnd;
        }
        if ((n & 8) != 0) {
            exception = monitorRunResult.error;
        }
        if ((n & 0x10) != 0) {
            inputRunResults = monitorRunResult.inputResults;
        }
        if ((n & 0x20) != 0) {
            map = monitorRunResult.triggerResults;
        }
        return monitorRunResult.copy(string, instant, instant2, exception, inputRunResults, map);
    }

    @NotNull
    public String toString() {
        return "MonitorRunResult(monitorName=" + this.monitorName + ", periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", error=" + this.error + ", inputResults=" + this.inputResults + ", triggerResults=" + this.triggerResults + ")";
    }

    public int hashCode() {
        int result = this.monitorName.hashCode();
        result = result * 31 + this.periodStart.hashCode();
        result = result * 31 + this.periodEnd.hashCode();
        result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
        result = result * 31 + this.inputResults.hashCode();
        result = result * 31 + ((Object)this.triggerResults).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MonitorRunResult)) {
            return false;
        }
        MonitorRunResult monitorRunResult = (MonitorRunResult)other;
        if (!Intrinsics.areEqual((Object)this.monitorName, (Object)monitorRunResult.monitorName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.periodStart, (Object)monitorRunResult.periodStart)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.periodEnd, (Object)monitorRunResult.periodEnd)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.error, (Object)monitorRunResult.error)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.inputResults, (Object)monitorRunResult.inputResults)) {
            return false;
        }
        return Intrinsics.areEqual(this.triggerResults, monitorRunResult.triggerResults);
    }

    @JvmStatic
    @NotNull
    public static final MonitorRunResult<TriggerRunResult> readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J,\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n2\u0018\u0010\f\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/commons/alerting/model/MonitorRunResult$Companion;", "", "<init>", "()V", "readFrom", "Lorg/opensearch/commons/alerting/model/MonitorRunResult;", "Lorg/opensearch/commons/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "suppressWarning", "", "", "map", "", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MonitorRunResult<TriggerRunResult> readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new MonitorRunResult<TriggerRunResult>(sin);
        }

        @NotNull
        public final Map<String, TriggerRunResult> suppressWarning(@Nullable Map<String, Object> map) {
            Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.commons.alerting.model.TriggerRunResult>");
            return map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

