/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskProfile;
import org.opensearch.ad.transport.ADTaskProfileAction;
import org.opensearch.ad.transport.ADTaskProfileNodeResponse;
import org.opensearch.ad.transport.ADTaskProfileRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.TaskProfileRunner;
import org.opensearch.timeseries.cluster.HashRing;
import org.opensearch.timeseries.model.EntityTaskProfile;
import org.opensearch.transport.client.Client;

public class ADTaskProfileRunner
implements TaskProfileRunner<ADTask, ADTaskProfile> {
    public final Logger logger = LogManager.getLogger(ADTaskProfileRunner.class);
    private final HashRing hashRing;
    private final Client client;

    public ADTaskProfileRunner(HashRing hashRing, Client client) {
        this.hashRing = hashRing;
        this.client = client;
    }

    @Override
    public void getTaskProfile(ADTask configLevelTask, ActionListener<ADTaskProfile> listener) {
        String detectorId = configLevelTask.getConfigId();
        this.hashRing.getAllEligibleDataNodesWithKnownVersion(dataNodes -> {
            ADTaskProfileRequest adTaskProfileRequest = new ADTaskProfileRequest(detectorId, (DiscoveryNode)dataNodes);
            this.client.execute((ActionType)ADTaskProfileAction.INSTANCE, (ActionRequest)adTaskProfileRequest, ActionListener.wrap(response -> {
                if (response.hasFailures()) {
                    listener.onFailure((Exception)response.failures().get(0));
                    return;
                }
                ArrayList<EntityTaskProfile> adEntityTaskProfiles = new ArrayList<EntityTaskProfile>();
                ADTaskProfile detectorTaskProfile = new ADTaskProfile(configLevelTask);
                for (ADTaskProfileNodeResponse node : response.getNodes()) {
                    ADTaskProfile taskProfile = node.getAdTaskProfile();
                    if (taskProfile == null) continue;
                    if (taskProfile.getNodeId() != null) {
                        detectorTaskProfile.setTaskId(taskProfile.getTaskId());
                        detectorTaskProfile.setRcfTotalUpdates(taskProfile.getRcfTotalUpdates());
                        detectorTaskProfile.setThresholdModelTrained(taskProfile.getThresholdModelTrained());
                        detectorTaskProfile.setThresholdModelTrainingDataSize(taskProfile.getThresholdModelTrainingDataSize());
                        detectorTaskProfile.setModelSizeInBytes(taskProfile.getModelSizeInBytes());
                        detectorTaskProfile.setNodeId(taskProfile.getNodeId());
                        detectorTaskProfile.setTotalEntitiesCount(taskProfile.getTotalEntitiesCount());
                        detectorTaskProfile.setDetectorTaskSlots(taskProfile.getDetectorTaskSlots());
                        detectorTaskProfile.setPendingEntitiesCount(taskProfile.getPendingEntitiesCount());
                        detectorTaskProfile.setRunningEntitiesCount(taskProfile.getRunningEntitiesCount());
                        detectorTaskProfile.setRunningEntities(taskProfile.getRunningEntities());
                        detectorTaskProfile.setTaskType(taskProfile.getTaskType());
                    }
                    if (taskProfile.getEntityTaskProfiles() == null) continue;
                    adEntityTaskProfiles.addAll(taskProfile.getEntityTaskProfiles());
                }
                if (adEntityTaskProfiles != null && adEntityTaskProfiles.size() > 0) {
                    detectorTaskProfile.setEntityTaskProfiles(adEntityTaskProfiles);
                }
                listener.onResponse((Object)detectorTaskProfile);
            }, e -> {
                this.logger.error("Failed to get task profile for task " + configLevelTask.getTaskId(), (Throwable)e);
                listener.onFailure(e);
            }));
        }, listener);
    }
}

