/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public abstract class AbstractSimpleLimitHandler
extends AbstractLimitHandler {
    protected abstract String limitClause(boolean var1);

    protected String limitClause(boolean hasFirstRow, int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return this.limitClause(hasFirstRow);
    }

    protected String offsetOnlyClause() {
        return null;
    }

    protected String offsetOnlyClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return this.offsetOnlyClause();
    }

    @Override
    public String processSql(String sql, Limit limit) {
        return this.processSql(sql, -1, null, limit);
    }

    @Override
    public String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        return this.processSql(sql, jdbcParameterCount, parameterMarkerStrategy, queryOptions.getLimit());
    }

    private String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, @Nullable Limit limit) {
        boolean hasFirstRow = AbstractSimpleLimitHandler.hasFirstRow(limit);
        if (!AbstractSimpleLimitHandler.hasMaxRows(limit)) {
            String offsetOnlyClause;
            String string = offsetOnlyClause = ParameterMarkerStrategyStandard.isStandardRenderer(parameterMarkerStrategy) ? this.offsetOnlyClause() : this.offsetOnlyClause(jdbcParameterCount, parameterMarkerStrategy);
            if (offsetOnlyClause != null && hasFirstRow) {
                return this.insert(offsetOnlyClause, sql);
            }
            return sql;
        }
        String limitClause = ParameterMarkerStrategyStandard.isStandardRenderer(parameterMarkerStrategy) ? this.limitClause(hasFirstRow) : this.limitClause(hasFirstRow, jdbcParameterCount, parameterMarkerStrategy);
        return this.insert(limitClause, sql);
    }

    protected String insert(String limitClause, String sql) {
        return this.insertBeforeForUpdate(limitClause, sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return super.supportsOffset();
    }
}

