/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jdbc.BaseTransactionalDriverXAConnection;
import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.internal.jdbc.TransactionalDriverXAConnection;
import com.arjuna.ats.internal.jdbc.drivers.modifiers.jndi;
import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class IndirectRecoverableConnection
extends BaseTransactionalDriverXAConnection
implements RecoverableXAConnection,
ConnectionControl,
TransactionalDriverXAConnection {
    public IndirectRecoverableConnection() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.IndirectRecoverableConnection ()");
        }
    }

    public IndirectRecoverableConnection(String dbName, String user, String passwd, ConnectionImple conn) throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("IndirectRecoverableConnection.IndirectRecoverableConnection ( " + dbName + ", " + user + ", " + passwd + " )"));
        }
        this._dbName = dbName;
        this._user = user;
        this._passwd = passwd;
        this._theArjunaConnection = conn;
        jndi jndiModifier = new jndi();
        this._dbName = jndiModifier.initialise(this._dbName);
        this._theModifier = null;
        this.createDataSource();
    }

    @Override
    public boolean packInto(OutputObjectState os) {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.packInto ()");
        }
        try {
            os.packString(this._dbName);
            os.packString(this._user);
            os.packString(this._passwd);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean unpackFrom(InputObjectState os) {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.unpackFrom ()");
        }
        try {
            this._dbName = os.unpackString();
            this._user = os.unpackString();
            this._passwd = os.unpackString();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    @Override
    public XAConnection getCurrentConnection() throws SQLException {
        return this._theConnection;
    }

    @Override
    public XADataSource getDataSource() throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"IndirectRecoverableConnection.getDataSource ()");
        }
        return this._theDataSource;
    }

    private final void createDataSource() throws SQLException {
        try {
            if (this._theDataSource == null) {
                Hashtable env = jdbcPropertyManager.getJDBCEnvironmentBean().getJndiProperties();
                InitialContext ctx = new InitialContext(env);
                this._theDataSource = (XADataSource)ctx.lookup(this._dbName);
            }
            if (this._theDataSource == null) {
                throw new SQLException(jdbcLogger.i18NLogger.get_jndierror());
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            jdbcLogger.logger.error((Object)e);
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    @Override
    protected void createConnection() throws SQLException {
        try {
            if (this._theDataSource == null) {
                this.createDataSource();
            }
            super.createConnection();
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            jdbcLogger.i18NLogger.warn_connection_problem(e.getMessage(), e);
            SQLException sqlException = new SQLException(e.toString());
            sqlException.initCause(e);
            throw sqlException;
        }
    }
}

