/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.logging;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.logging.LoggingFilter;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.infinispan.commons.jdkspecific.ThreadCreator;
import org.jboss.logging.Logger;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.config.LoggingOptions;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public abstract class KeycloakLogFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(KeycloakLogFilter.class);
    private static final Pattern ISPN000312_PATTERN = Pattern.compile("^\\[Context=(" + String.join((CharSequence)"|", "sessions", "clientSessions", "offlineSessions", "offlineClientSessions") + ")] ISPN000312: .*");
    private final ExecutorService executor = ThreadCreator.useVirtualThreads() && this.isHandlerEnabled() && !this.isAsyncLoggingEnabled() ? Executors.newSingleThreadExecutor() : null;
    private Handler handler;

    protected abstract Class<? extends Handler> getHandlerClass();

    public abstract boolean isHandlerEnabled();

    public abstract boolean isAsyncLoggingEnabled();

    @Override
    public boolean isLoggable(LogRecord record) {
        if (Objects.equals(record.getLevel(), Level.WARNING) && record.getLoggerName().equals("com.arjuna.ats.arjuna") && record.getMessage().startsWith("ARJUNA012125:")) {
            return false;
        }
        if (MultiSiteUtils.isPersistentSessionsEnabled() && Objects.equals(record.getLevel(), Level.WARNING) && record.getLoggerName().equals("org.infinispan.CLUSTER") && ISPN000312_PATTERN.matcher(record.getMessage()).matches()) {
            return false;
        }
        if (this.executor != null && ThreadCreator.isVirtual((Thread)Thread.currentThread())) {
            this.executor.submit(new RecordLogger((LogRecord)ExtLogRecord.wrap((LogRecord)record), this));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler() {
        if (this.handler == null) {
            KeycloakLogFilter keycloakLogFilter = this;
            synchronized (keycloakLogFilter) {
                if (this.handler == null) {
                    Class<? extends Handler> handlerClass = this.getHandlerClass();
                    this.handler = Arrays.stream(InitialConfigurator.DELAYED_HANDLER.getHandlers()).filter(h -> handlerClass.isAssignableFrom(h.getClass())).findFirst().orElse(null);
                }
                if (this.handler == null) {
                    this.executor.submit(() -> logger.error((Object)("Can't find handler for " + String.valueOf(this.getHandlerClass()))));
                }
            }
        }
        return this.handler;
    }

    public record RecordLogger(LogRecord record, KeycloakLogFilter filter) implements Runnable
    {
        @Override
        public void run() {
            Handler handler = this.filter.getHandler();
            if (handler != null) {
                handler.publish(this.record);
            }
        }
    }

    @LoggingFilter(name="keycloak-filter-syslog")
    private static final class KeycloakSyslogLogFilter
    extends KeycloakLogFilter {
        private KeycloakSyslogLogFilter() {
        }

        @Override
        protected Class<? extends Handler> getHandlerClass() {
            return SyslogHandler.class;
        }

        @Override
        public boolean isHandlerEnabled() {
            return Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_SYSLOG_ENABLED);
        }

        @Override
        public boolean isAsyncLoggingEnabled() {
            return Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_SYSLOG_ASYNC);
        }
    }

    @LoggingFilter(name="keycloak-filter-file")
    private static final class KeycloakFileLogFilter
    extends KeycloakLogFilter {
        private KeycloakFileLogFilter() {
        }

        @Override
        protected Class<? extends Handler> getHandlerClass() {
            return FileHandler.class;
        }

        @Override
        public boolean isHandlerEnabled() {
            return Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_FILE_ENABLED);
        }

        @Override
        public boolean isAsyncLoggingEnabled() {
            return Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_FILE_ASYNC);
        }
    }

    @LoggingFilter(name="keycloak-filter-console")
    private static final class KeycloakConsoleLogFilter
    extends KeycloakLogFilter {
        private KeycloakConsoleLogFilter() {
        }

        @Override
        protected Class<? extends Handler> getHandlerClass() {
            return ConsoleHandler.class;
        }

        @Override
        public boolean isHandlerEnabled() {
            return Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_CONSOLE_ENABLED);
        }

        @Override
        public boolean isAsyncLoggingEnabled() {
            return Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_CONSOLE_ASYNC);
        }
    }
}

