/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.server.config.AbstractKafkaConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering;

public final class KafkaConfig$ {
    public static final KafkaConfig$ MODULE$ = new KafkaConfig$();
    private static final ConfigDef configDef = AbstractKafkaConfig.CONFIG_DEF;

    public void main(String[] args) {
        System.out.println(this.configDef().toHtml(4, config -> "brokerconfigs_" + config, DynamicBrokerConfig$.MODULE$.dynamicConfigUpdateModes()));
    }

    public ConfigDef configDef() {
        return configDef;
    }

    public Seq<String> configNames() {
        return (Seq)CollectionConverters$.MODULE$.SetHasAsScala(this.configDef().names()).asScala().toBuffer().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Map<String, ?> defaultValues() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.configDef().defaultValues()).asScala();
    }

    public Map<String, ConfigDef.ConfigKey> configKeys() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.configDef().configKeys()).asScala();
    }

    public KafkaConfig fromProps(Properties props) {
        boolean fromProps_doLog = true;
        return new KafkaConfig(props, fromProps_doLog);
    }

    public KafkaConfig fromProps(Properties props, boolean doLog) {
        return new KafkaConfig(props, doLog);
    }

    public KafkaConfig fromProps(Properties defaults, Properties overrides) {
        return this.fromProps(defaults, overrides, true);
    }

    public KafkaConfig fromProps(Properties defaults, Properties overrides, boolean doLog) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(defaults);
        new Implicits.PropertiesOps(props).$plus$plus$eq(overrides);
        return new KafkaConfig(props, doLog);
    }

    public KafkaConfig apply(java.util.Map<?, ?> props, boolean doLog) {
        return new KafkaConfig(props, doLog);
    }

    public boolean apply$default$2() {
        return true;
    }

    private Option<ConfigDef.Type> typeOf(String name) {
        return Option$.MODULE$.apply(this.configDef().configKeys().get(name)).map((Function1 & Serializable)x$1 -> x$1.type);
    }

    public Option<ConfigDef.Type> configType(String configName) {
        Option<ConfigDef.Type> configType = this.configTypeExact(configName);
        if (configType.isDefined()) {
            return configType;
        }
        Option<ConfigDef.Type> option = this.typeOf(configName);
        if (option instanceof Some) {
            ConfigDef.Type t = (ConfigDef.Type)((Some)option).value();
            return new Some((Object)t);
        }
        if (None$.MODULE$.equals(option)) {
            return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(configName, true).flatMap((Function1 & Serializable)name -> MODULE$.typeOf((String)name)).headOption();
        }
        throw new MatchError(option);
    }

    private Option<ConfigDef.Type> configTypeExact(String exactName) {
        ConfigDef.Type configType = (ConfigDef.Type)this.typeOf(exactName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (configType != null) {
            return new Some((Object)configType);
        }
        ConfigDef.ConfigKey configKey = DynamicConfig$Broker$.MODULE$.configKeys().get(exactName);
        if (configKey != null) {
            return new Some((Object)configKey.type);
        }
        return None$.MODULE$;
    }

    public boolean maybeSensitive(Option<ConfigDef.Type> configType) {
        return configType.isEmpty() || configType.contains((Object)ConfigDef.Type.PASSWORD);
    }

    public String loggableValue(ConfigResource.Type resourceType, String name, String value) {
        if (ConfigResource.Type.BROKER.equals(resourceType) ? this.maybeSensitive(this.configType(name)) : (ConfigResource.Type.TOPIC.equals(resourceType) ? this.maybeSensitive((Option<ConfigDef.Type>)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(LogConfig.configType((String)name)))) : (ConfigResource.Type.GROUP.equals(resourceType) ? this.maybeSensitive((Option<ConfigDef.Type>)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(GroupConfig.configType((String)name)))) : (ConfigResource.Type.BROKER_LOGGER.equals(resourceType) ? false : !ConfigResource.Type.CLIENT_METRICS.equals(resourceType))))) {
            return "[hidden]";
        }
        return value;
    }

    public java.util.Map<Object, Object> populateSynonyms(java.util.Map<?, ?> input) {
        HashMap<Object, Object> output = new HashMap<Object, Object>(input);
        Object brokerId = output.get("broker.id");
        Object nodeId = output.get("node.id");
        if (brokerId == null && nodeId != null) {
            output.put("broker.id", nodeId);
        } else if (brokerId != null && nodeId == null) {
            output.put("node.id", brokerId);
        }
        return output;
    }

    private KafkaConfig$() {
    }
}

