/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompTextField;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractIdTextField<T extends AbstractTextComponentValidator>
extends AutoCompTextField<String> {
    protected final transient T validator;

    protected AbstractIdTextField(Class<T> klass) {
        this(klass, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractIdTextField(Class<T> klass, int columns) {
        super(columns);
        AbstractTextComponentValidator validator = null;
        try {
            if (klass != null) {
                validator = (AbstractTextComponentValidator)klass.getConstructor(JTextComponent.class).newInstance(this);
            }
        }
        catch (ReflectiveOperationException e) {
            Logging.error(e);
        }
        finally {
            this.validator = validator;
        }
    }

    public final void performValidation() {
        ((AbstractTextComponentValidator)this.validator).validate();
    }

    public final void clearTextIfInvalid() {
        if (!((AbstractTextComponentValidator)this.validator).isValid()) {
            this.setText("");
        }
        ((AbstractTextComponentValidator)this.validator).validate();
    }

    public abstract boolean readIds();

    public void tryToPasteFromClipboard() {
        this.tryToPasteFrom(ClipboardUtils.getClipboardStringContent());
    }

    public boolean tryToPasteFrom(String contents) {
        if (!Utils.isStripEmpty(contents)) {
            this.setText(contents.trim());
            this.clearTextIfInvalid();
            return this.readIds();
        }
        return false;
    }
}

