/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.CompoundDocument;

class CompoundDocHeader {
    private final CompoundDocument cd;
    byte[] magicNumbers = new byte[8];
    byte[] uniqueID16 = new byte[16];
    byte revNumber;
    byte verNumber;
    short sectorPower;
    short shortSectorPower;
    byte[] unused = new byte[10];
    int nSATsectors;
    int SID_DIR_start;
    int minBytesStandardStream;
    int SID_SSAT_start;
    int nSSATsectors;
    int SID_MSAT_next;
    int nAdditionalMATsectors;
    int[] MSAT0 = new int[109];

    CompoundDocHeader(CompoundDocument compoundDocument) {
        this.cd = compoundDocument;
    }

    final boolean readData() {
        block4: {
            this.cd.readByteArray(this.magicNumbers, 0, 8);
            if ((this.magicNumbers[0] & 0xFF) == 208 && (this.magicNumbers[1] & 0xFF) == 207 && (this.magicNumbers[2] & 0xFF) == 17 && (this.magicNumbers[3] & 0xFF) == 224 && (this.magicNumbers[4] & 0xFF) == 161 && (this.magicNumbers[5] & 0xFF) == 177 && (this.magicNumbers[6] & 0xFF) == 26 && (this.magicNumbers[7] & 0xFF) == 225) break block4;
            return false;
        }
        try {
            this.cd.readByteArray(this.uniqueID16, 0, 16);
            this.revNumber = this.cd.readByte();
            this.cd.readByte();
            this.verNumber = this.cd.readByte();
            this.cd.readByte();
            byte by = this.cd.readByte();
            byte by2 = this.cd.readByte();
            this.cd.isBigEndian = by == -1 && by2 == -2;
            this.sectorPower = this.cd.readShort();
            this.shortSectorPower = this.cd.readShort();
            this.cd.readByteArray(this.unused, 0, 10);
            this.nSATsectors = this.cd.readInt();
            this.SID_DIR_start = this.cd.readInt();
            this.cd.readByteArray(this.unused, 0, 4);
            this.minBytesStandardStream = this.cd.readInt();
            this.SID_SSAT_start = this.cd.readInt();
            this.nSSATsectors = this.cd.readInt();
            this.SID_MSAT_next = this.cd.readInt();
            this.nAdditionalMATsectors = this.cd.readInt();
            int n = 0;
            while (n < 109) {
                this.MSAT0[n] = this.cd.readInt();
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
        return true;
    }
}

