/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public final class GrCreateMissingSwitchBranchesIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            GrCreateMissingSwitchBranchesIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GrCreateMissingSwitchBranchesIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            GrCreateMissingSwitchBranchesIntention.$$$reportNull$$$0(2);
        }
        if (!(element instanceof GrSwitchStatement)) {
            return;
        }
        List<PsiEnumConstant> constants = GrCreateMissingSwitchBranchesIntention.findUnusedConstants((GrSwitchStatement)element);
        if (constants.isEmpty()) {
            return;
        }
        PsiEnumConstant first = constants.get(0);
        PsiClass aClass = first.getContainingClass();
        if (aClass == null) {
            return;
        }
        String qName = aClass.getQualifiedName();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.project());
        PsiElement anchor = GrCreateMissingSwitchBranchesIntention.findAnchor(element);
        for (PsiEnumConstant constant : constants) {
            GrCaseSection section = factory.createSwitchSection("case " + qName + "." + constant.getName() + ":\n break");
            PsiElement added = element.addBefore((PsiElement)section, anchor);
            JavaCodeStyleManager.getInstance((Project)context.project()).shortenClassReferences(added);
        }
    }

    @Nullable
    private static PsiElement findAnchor(PsiElement element) {
        PsiElement last = element.getLastChild();
        if (last != null && last.getNode().getElementType() == GroovyTokenTypes.mRCURLY) {
            return last;
        }
        return null;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(this){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrSwitchStatement)) {
                    return false;
                }
                List<PsiEnumConstant> unused = GrCreateMissingSwitchBranchesIntention.findUnusedConstants((GrSwitchStatement)element);
                return !unused.isEmpty();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/other/GrCreateMissingSwitchBranchesIntention$1", "satisfiedBy"));
            }
        };
    }

    private static List<PsiEnumConstant> findUnusedConstants(GrSwitchStatement switchStatement) {
        GrCaseSection[] sections;
        GrExpression condition = switchStatement.getCondition();
        if (condition == null) {
            return Collections.emptyList();
        }
        PsiType type = condition.getType();
        if (!(type instanceof PsiClassType)) {
            return Collections.emptyList();
        }
        PsiClass resolved = ((PsiClassType)type).resolve();
        if (resolved == null || !resolved.isEnum()) {
            return Collections.emptyList();
        }
        Object[] fields = resolved.getFields();
        ArrayList<PsiEnumConstant> constants = new ArrayList<PsiEnumConstant>(ContainerUtil.findAll((Object[])fields, PsiEnumConstant.class));
        for (GrCaseSection section : sections = switchStatement.getCaseSections()) {
            for (GrExpression value : section.getExpressions()) {
                if (!(value instanceof GrReferenceExpression)) continue;
                PsiElement r = ((GrReferenceExpression)value).resolve();
                constants.remove(r);
            }
        }
        return constants;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/other/GrCreateMissingSwitchBranchesIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

