/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.GradleStyleMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.XcodeStyleMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.XmlMessageRenderer;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

public interface MessageRenderer {
    public static final String PROPERTY_KEY = "org.jetbrains.kotlin.cliMessageRenderer";
    public static final MessageRenderer XML = new XmlMessageRenderer();
    public static final MessageRenderer WITHOUT_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public String getName() {
            return "Pathless";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "getPath"));
        }
    };
    public static final MessageRenderer PLAIN_FULL_PATHS = new PlainTextMessageRenderer(){

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                2.$$$reportNull$$$0(0);
            }
            String string = location.getPath();
            if (string == null) {
                2.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public String getName() {
            return "FullPath";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final MessageRenderer PLAIN_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                3.$$$reportNull$$$0(0);
            }
            String string = FileUtilsKt.descendantRelativeTo(new File(location.getPath()), this.cwd).getPath();
            if (string == null) {
                3.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public String getName() {
            return "RelativePath";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final MessageRenderer SYSTEM_INDEPENDENT_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                4.$$$reportNull$$$0(0);
            }
            return FileUtil.toSystemIndependentName(FileUtilsKt.descendantRelativeTo(new File(location.getPath()), this.cwd).getPath());
        }

        @Override
        public String getName() {
            return "SystemIndependentRelativePath";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$4", "getPath"));
        }
    };
    public static final MessageRenderer GRADLE_STYLE = new GradleStyleMessageRenderer();
    public static final MessageRenderer XCODE_STYLE = new XcodeStyleMessageRenderer();

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @Nullable CompilerMessageSourceLocation var3);

    public String renderUsage(@NotNull String var1);

    public String renderConclusion();

    public String getName();
}

