/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.MessageBuilderHelper;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;

class ComponentRejectedMessageBuilder {
    ComponentRejectedMessageBuilder() {
    }

    String buildFailureMessage(ModuleResolveState module) {
        boolean hasRejectAll = false;
        for (SelectorState candidate : module.getSelectors()) {
            ResolvedVersionConstraint versionConstraint = candidate.getVersionConstraint();
            if (versionConstraint == null) continue;
            hasRejectAll |= versionConstraint.isRejectAll();
        }
        StringBuilder sb = new StringBuilder();
        if (hasRejectAll) {
            sb.append("Module '").append(module.getId()).append("' has been rejected:\n");
        } else {
            sb.append("Cannot find a version of '").append(module.getId()).append("' that satisfies the version constraints:\n");
        }
        Set<EdgeState> allEdges = module.getAllEdges();
        this.renderEdges(sb, allEdges);
        return sb.toString();
    }

    private void renderEdges(StringBuilder sb, Set<EdgeState> incomingEdges) {
        for (EdgeState incomingEdge : incomingEdges) {
            SelectorState selector = incomingEdge.getSelector();
            for (String path : MessageBuilderHelper.formattedPathsTo(incomingEdge)) {
                sb.append("   ").append(path);
                sb.append(" --> ");
                ComponentRejectedMessageBuilder.renderSelector(sb, selector);
                ComponentRejectedMessageBuilder.renderReason(sb, selector);
                sb.append("\n");
            }
        }
    }

    private static void renderSelector(StringBuilder sb, SelectorState selectorState) {
        sb.append('\'').append(selectorState.getRequested()).append('\'');
    }

    private static void renderReason(StringBuilder sb, SelectorState selector) {
        ComponentSelectionReasonInternal selectionReason = selector.getSelectionReason();
        if (selectionReason.hasCustomDescriptions()) {
            sb.append(" because of the following reason");
            ArrayList<String> reasons = new ArrayList<String>(1);
            for (ComponentSelectionDescriptorInternal componentSelectionDescriptor : selectionReason.getDescriptions()) {
                if (!componentSelectionDescriptor.hasCustomDescription()) continue;
                reasons.add(componentSelectionDescriptor.getDescription());
            }
            if (reasons.size() == 1) {
                sb.append(": ").append((String)reasons.get(0));
            } else {
                sb.append("s: ");
                Joiner.on((String)", ").appendTo(sb, reasons);
            }
        }
    }
}

