/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.plugin.ColumnUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class ConnectedComponents
implements Statistics,
LongTask {
    public static final String WEAKLY = "componentnumber";
    public static final String STRONG = "strongcompnum";
    int count;
    private boolean isDirected;
    private ProgressTicket progress;
    private boolean isCanceled;
    private int componentCount;
    private int stronglyCount;
    private int[] componentsSize;

    public ConnectedComponents() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(GraphModel graphModel) {
        this.isCanceled = false;
        UndirectedGraph undirectedGraph = graphModel.getUndirectedGraphVisible();
        Column weaklyConnectedColumn = this.initializeWeaklyConnectedColumn(graphModel);
        Column stronglyConnectedColumn = null;
        if (this.isDirected) {
            stronglyConnectedColumn = this.initializeStronglyConnectedColumn(graphModel);
        }
        undirectedGraph.readLock();
        try {
            this.weaklyConnected(undirectedGraph, weaklyConnectedColumn);
            if (this.isDirected) {
                DirectedGraph directedGraph = graphModel.getDirectedGraphVisible();
                this.stronglyConnected(directedGraph, graphModel, stronglyConnectedColumn);
            }
        }
        finally {
            undirectedGraph.readUnlock();
        }
    }

    public void weaklyConnected(UndirectedGraph graph, Column componentCol) {
        this.isCanceled = false;
        HashMap<Node, Integer> indices = this.createIndicesMap((Graph)graph);
        LinkedList<LinkedList<Node>> components = this.computeWeaklyConnectedComponents((Graph)graph, indices);
        this.saveComputedComponents(components, componentCol);
        this.fillComponentSizeList(components);
        this.componentCount = components.size();
    }

    public LinkedList<LinkedList<Node>> computeWeaklyConnectedComponents(Graph graph, HashMap<Node, Integer> indices) {
        int N = graph.getNodeCount();
        int[] color = new int[N];
        Progress.start((ProgressTicket)this.progress, (int)N);
        int seenCount = 0;
        LinkedList<LinkedList<Node>> components = new LinkedList<LinkedList<Node>>();
        while (seenCount < N) {
            LinkedList<Node> Q = new LinkedList<Node>();
            LinkedList<Node> component = new LinkedList<Node>();
            NodeIterable iter = graph.getNodes();
            for (Node next : iter) {
                if (color[indices.get(next)] != 0) continue;
                Q.add(next);
                iter.doBreak();
                break;
            }
            while (!Q.isEmpty()) {
                if (this.isCanceled) {
                    return new LinkedList<LinkedList<Node>>();
                }
                Node u = (Node)Q.removeFirst();
                component.add(u);
                color[indices.get((Object)u).intValue()] = 2;
                EdgeIterable edgeIter = graph.getEdges(u);
                for (Edge edge : edgeIter) {
                    Node reachable = graph.getOpposite(u, edge);
                    int id = indices.get(reachable);
                    if (color[id] != 0) continue;
                    color[id] = 1;
                    Q.addLast(reachable);
                }
                Progress.progress((ProgressTicket)this.progress, (int)(++seenCount));
            }
            components.add(component);
        }
        return components;
    }

    private Column initializeWeaklyConnectedColumn(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        ColumnUtils.cleanUpColumns(nodeTable, new String[]{WEAKLY}, Integer.class);
        Column componentCol = nodeTable.getColumn(WEAKLY);
        if (componentCol == null) {
            componentCol = nodeTable.addColumn(WEAKLY, "Component ID", Integer.class, (Object)0);
        }
        return componentCol;
    }

    public HashMap<Node, Integer> createIndicesMap(Graph graph) {
        HashMap<Node, Integer> indices = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : graph.getNodes()) {
            indices.put(s, index);
            ++index;
        }
        return indices;
    }

    private void saveComputedComponents(LinkedList<LinkedList<Node>> components, Column componentCol) {
        int i = 0;
        for (LinkedList linkedList : components) {
            for (Node s : linkedList) {
                s.setAttribute(componentCol, (Object)i);
            }
            ++i;
        }
    }

    void fillComponentSizeList(LinkedList<LinkedList<Node>> components) {
        this.componentsSize = new int[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            this.componentsSize[i] = components.get(i).size();
        }
    }

    private Column initializeStronglyConnectedColumn(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        ColumnUtils.cleanUpColumns(nodeTable, new String[]{STRONG}, Integer.class);
        Column componentCol = nodeTable.getColumn(STRONG);
        if (componentCol == null) {
            componentCol = nodeTable.addColumn(STRONG, "Strongly-Connected ID", Integer.class, (Object)0);
        }
        return componentCol;
    }

    public void stronglyConnected(DirectedGraph graph, GraphModel graphModel, Column componentCol) {
        this.count = 1;
        this.stronglyCount = 0;
        HashMap<Node, Integer> indices = this.createIndicesMap((Graph)graph);
        LinkedList<LinkedList<Node>> components = this.top_tarjans(graph, indices);
        this.saveComputedComponents(components, componentCol);
        this.stronglyCount = components.size();
    }

    public LinkedList<LinkedList<Node>> top_tarjans(DirectedGraph graph, HashMap<Node, Integer> indices) {
        LinkedList<LinkedList<Node>> allComponents = new LinkedList<LinkedList<Node>>();
        this.count = 1;
        this.stronglyCount = 0;
        int N = graph.getNodeCount();
        int[] index = new int[N];
        int[] low_index = new int[N];
        block0: while (true) {
            LinkedList<Node> S = new LinkedList<Node>();
            Node first = null;
            NodeIterable iter = graph.getNodes();
            for (Node u : iter) {
                if (index[indices.get(u)] != 0) continue;
                first = u;
                iter.doBreak();
                break;
            }
            if (first == null) {
                return allComponents;
            }
            LinkedList<LinkedList<Node>> components = new LinkedList<LinkedList<Node>>();
            components = this.tarjans(components, S, graph, first, index, low_index, indices);
            Iterator iterator = components.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                LinkedList component = (LinkedList)iterator.next();
                allComponents.add(component);
            }
            break;
        }
    }

    private LinkedList<LinkedList<Node>> tarjans(LinkedList<LinkedList<Node>> components, LinkedList<Node> S, DirectedGraph graph, Node f, int[] index, int[] low_index, HashMap<Node, Integer> indices) {
        int id = indices.get(f);
        index[id] = this.count;
        low_index[id] = this.count++;
        S.addFirst(f);
        EdgeIterable edgeIter = graph.getOutEdges(f);
        for (Edge e : edgeIter) {
            Node u = graph.getOpposite(f, e);
            int x = indices.get(u);
            if (index[x] == 0) {
                this.tarjans(components, S, graph, u, index, low_index, indices);
                low_index[id] = Math.min(low_index[x], low_index[id]);
                continue;
            }
            if (!S.contains(u)) continue;
            low_index[id] = Math.min(low_index[id], index[x]);
        }
        LinkedList<Node> currentComponent = new LinkedList<Node>();
        if (low_index[id] == index[id]) {
            Node v = null;
            while (v != f) {
                v = S.removeFirst();
                currentComponent.add(v);
            }
            components.add(currentComponent);
        }
        return components;
    }

    public int getConnectedComponentsCount() {
        return this.componentCount;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public int[] getComponentsSize() {
        return this.componentsSize;
    }

    public int getGiantComponent() {
        int[] sizes = this.getComponentsSize();
        int max = Integer.MIN_VALUE;
        int maxIndex = -1;
        for (int i = 0; i < sizes.length; ++i) {
            if (sizes[i] <= max) continue;
            max = sizes[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public int getComponentNumber(LinkedList<LinkedList<Node>> components, Node node) {
        int i = 0;
        for (LinkedList linkedList : components) {
            for (Node currentNode : linkedList) {
                if (!currentNode.equals(node)) continue;
                return i;
            }
            ++i;
        }
        return 0;
    }

    public String getReport() {
        HashMap<Integer, Integer> sizeDist = new HashMap<Integer, Integer>();
        for (int v : this.componentsSize) {
            if (!sizeDist.containsKey(v)) {
                sizeDist.put(v, 0);
            }
            sizeDist.put(v, (Integer)sizeDist.get(v) + 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(sizeDist, "Size Distribution");
        XYSeriesCollection dataset1 = new XYSeriesCollection();
        dataset1.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Size Distribution", (String)"Size (number of nodes)", (String)"Count", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, false);
        String imageFile = ChartUtils.renderChart(chart, "cc-size-distribution.png");
        DecimalFormat f = new DecimalFormat("#0.000");
        String report = "<HTML> <BODY> <h1>Connected Components Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br><br> <h2> Results: </h2>Number of Weakly Connected Components: " + this.componentCount + "<br>" + (String)(this.isDirected ? "Number of Strongly Connected Components: " + this.stronglyCount + "<br>" : "") + "<br /><br />" + imageFile + "<br /><h2> Algorithm: </h2>Robert Tarjan, <i>Depth-First Search and Linear Graph Algorithms</i>, in SIAM Journal on Computing 1 (2): 146\u2013160 (1972)<br /></BODY> </HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

