/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview;

import java.util.Arrays;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.desktop.preview.api.PreviewUIController;
import org.gephi.desktop.preview.api.PreviewUIModel;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewPreset;
import org.gephi.preview.presets.BlackBackground;
import org.gephi.preview.presets.DefaultPreset;
import org.gephi.project.api.Workspace;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.Lookup;

public class PreviewUIModelImpl
implements PreviewUIModel {
    private final PreviewModel previewModel;
    private float visibilityRatio = 1.0f;
    private PreviewPreset currentPreset;
    private boolean refreshing;

    public PreviewUIModelImpl(PreviewModel model) {
        this.previewModel = model;
        this.currentPreset = UIUtils.isDarkLookAndFeel() ? new BlackBackground() : new DefaultPreset();
        model.getProperties().applyPreset(this.currentPreset);
    }

    @Override
    public PreviewModel getPreviewModel() {
        return this.previewModel;
    }

    @Override
    public Workspace getWorkspace() {
        return this.previewModel.getWorkspace();
    }

    @Override
    public PreviewPreset getCurrentPreset() {
        return this.currentPreset;
    }

    public void setCurrentPreset(PreviewPreset preset) {
        this.currentPreset = preset;
    }

    @Override
    public float getVisibilityRatio() {
        return this.visibilityRatio;
    }

    public void setVisibilityRatio(float visibilityRatio) {
        this.visibilityRatio = visibilityRatio;
    }

    @Override
    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    private void setCurrentPresetBasedOnString(String className, String displayName) {
        PreviewUIController controller = (PreviewUIController)Lookup.getDefault().lookup(PreviewUIController.class);
        PreviewPreset[] defaultPresets = controller.getDefaultPresets();
        Optional<PreviewPreset> preset = Arrays.stream(defaultPresets).filter(p -> p.getClass().getName().equals(className)).findFirst();
        if (preset.isPresent()) {
            this.setCurrentPreset(preset.get());
        } else {
            PreviewPreset[] userPresets = controller.getUserPresets();
            preset = Arrays.stream(userPresets).filter(p -> p.getName().equals(displayName)).findFirst();
            preset.ifPresent(this::setCurrentPreset);
        }
    }

    protected void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        if (this.currentPreset != null) {
            writer.writeStartElement("currentpreset");
            writer.writeAttribute("class", this.currentPreset.getClass().getName());
            writer.writeAttribute("name", this.currentPreset.getName());
            writer.writeEndElement();
        }
        writer.writeStartElement("visibilityratio");
        writer.writeAttribute("value", "" + this.visibilityRatio);
        writer.writeEndElement();
    }

    protected void readXML(XMLStreamReader reader) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if ("currentpreset".equalsIgnoreCase(name)) {
                        String presetClass = reader.getAttributeValue(null, "class");
                        String presetName = reader.getAttributeValue(null, "name");
                        this.setCurrentPresetBasedOnString(presetClass, presetName);
                        break;
                    }
                    if (!"visibilityratio".equalsIgnoreCase(name)) break;
                    String value = reader.getAttributeValue(null, "value");
                    this.visibilityRatio = Float.parseFloat(value);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    if (!"previewuimodel".equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }
}

