/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns;

import java.awt.Image;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.plugin.manipulators.columns.ui.ConvertColumnToDynamicTimestampsUI;
import org.gephi.datalab.plugin.manipulators.columns.ui.ConvertColumnToDynamicUI;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeRepresentation;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConvertColumnToDynamic
implements AttributeColumnsManipulator {
    private String title;
    private double low;
    private double high;
    private boolean replaceColumn;

    public void execute(Table table, Column column) {
        if (this.replaceColumn) {
            ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).convertAttributeColumnToDynamic(table, column, this.low, this.high);
        } else {
            ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).convertAttributeColumnToNewDynamicColumn(table, column, this.low, this.high, this.title);
        }
    }

    public String getName() {
        return NbBundle.getMessage(ConvertColumnToDynamic.class, (String)"ConvertColumnToDynamic.name");
    }

    public String getDescription() {
        return "";
    }

    public boolean canManipulateColumn(Table table, Column column) {
        return ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).canConvertColumnToDynamic(column);
    }

    public AttributeColumnsManipulatorUI getUI(Table table, Column column) {
        TimeRepresentation timeRepresentation = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getConfiguration().getTimeRepresentation();
        if (timeRepresentation == TimeRepresentation.INTERVAL) {
            return new ConvertColumnToDynamicUI();
        }
        return new ConvertColumnToDynamicTimestampsUI();
    }

    public int getType() {
        return 400;
    }

    public int getPosition() {
        return 0;
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"DataLaboratoryPlugin/table-insert-column.png", (boolean)false);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double low) {
        this.low = low;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double high) {
        this.high = high;
    }

    public boolean isReplaceColumn() {
        return this.replaceColumn;
    }

    public void setReplaceColumn(boolean replaceColumn) {
        this.replaceColumn = replaceColumn;
    }
}

