// Codemirror mode for GAP Language

/* global define */

define([
  'codemirror/lib/codemirror',
  'codemirror/addon/mode/simple'
], function (CodeMirror) {
  'use strict';

  function createBuiltinRegularExpression(words) {
    return new RegExp(words.join('(?!\\\\[(),.]?|[\\w@]+)|') + '(?!\\\\[(),.]?|[\\w@]+)', 'm');
  }

  function createKeywordRegularExpression(words) {
    return new RegExp('\\b' + words.join('\\b|\\b') + '\\b', 'm');
  }

  // TODO
  // builtin function were retrieved from https://gap-system.org/Manuals/doc/ref/chapInd.html
  // and hence libraries / packages are not included and not treated by the highlighting.
  // this could change in the future to request somehow gap kernel if something is a function?
  var builtin = createBuiltinRegularExpression(['AbelianGroup', 'AbelianInvariants', 'AbelianInvariantsMultiplier', 'AbelianInvariantsNormalClosureFpGroup', 'AbelianInvariantsNormalClosureFpGroupRrs', 'AbelianInvariantsOfList', 'AbelianInvariantsSubgroupFpGroup', 'AbelianInvariantsSubgroupFpGroupMtc',
    'AbelianInvariantsSubgroupFpGroupRrs', 'AbelianNumberField', 'AbelianSubfactorAction', 'About', 'AbsInt', 'AbsoluteDiameter', 'AbsoluteIrreducibleModules', 'AbsolutelyIrreducibleModules',
    'AbsoluteValue', 'AbsolutIrreducibleModules', 'AbstractWordTietzeWord', 'AClosestVectorCombinationsMatFFEVecFFE', 'AClosestVectorCombinationsMatFFEVecFFECoords', 'Acos', 'Acosh', 'ActingAlgebra',
    'ActingDomain', 'Action', 'ActionHomomorphism', 'ActivateProfileColour', 'ActorOfExternalSet', 'Add', 'AddCoeffs', 'AddDictionary',
    'AddGenerator', 'AddGeneratorsExtendSchreierTree', 'AdditiveInverse', 'AdditiveInverseAttr', 'AdditiveInverseImmutable', 'AdditiveInverseMutable', 'AdditiveInverseOp', 'AdditiveInverseSameMutability',
    'AdditiveInverseSM', 'AdditiveNeutralElement', 'AddRelator', 'AddRowVector', 'AddRule', 'AddRuleReduced', 'AddSet', 'AdjointAssociativeAlgebra',
    'AdjointBasis', 'AdjointMatrix', 'AdjointModule', 'AffineAction', 'AffineActionLayer', 'Agemo', 'Algebra', 'AlgebraByStructureConstants',
    'AlgebraGeneralMappingByImages', 'AlgebraHomomorphismByImages', 'AlgebraHomomorphismByImagesNC', 'AlgebraicExtension', 'AlgebraWithOne', 'AlgebraWithOneGeneralMappingByImages', 'AlgebraWithOneHomomorphismByImages', 'AlgebraWithOneHomomorphismByImagesNC',
    'AllAutomorphisms', 'AllBlocks', 'AllEndomorphisms', 'AllHomomorphismClasses', 'AllHomomorphisms', 'AllIrreducibleSolvableGroups', 'AllLibraryGroups', 'AllPrimitiveGroups',
    'AllSmallGroups', 'AllSmallNonabelianSimpleGroups', 'AllSubgroups', 'AllTransitiveGroups', 'Alpha', 'AlternatingGroup', 'AlternatingGroup', 'ANFAutomorphism',
    'AntiIsomorphismTransformationSemigroup', 'AntiSymmetricParts', 'Append', 'AppendTo', 'ApplicableMethod', 'ApplicableMethodTypes', 'Apply', 'ApplySimpleReflection',
    'ApproximateSuborbitsStabilizerPermGroup', 'ARCH_IS_MAC_OS_X', 'ARCH_IS_UNIX', 'ARCH_IS_WINDOWS', 'Argument', 'ArithmeticElementCreator', 'Arrangements', 'AsAlgebra',
    'AsAlgebraWithOne', 'AsBinaryRelationOnPoints', 'AsBlockMatrix', 'AscendingChain', 'AsDivisionRing', 'AsDuplicateFreeList', 'AsField', 'AsGroup',
    'AsGroupGeneralMappingByImages', 'Asin', 'Asinh', 'AsInternalFFE', 'AsLeftIdeal', 'AsLeftModule', 'AsList', 'AsMagma',
    'AsMonoid', 'AsPartialPerm', 'AsPermutation', 'AsPolynomial', 'AsRightIdeal', 'AsSemigroup', 'AssertionLevel', 'AsSet',
    'AssignGeneratorVariables', 'AssignNiceMonomorphismAutomorphismGroup', 'AssociatedPartition', 'AssociatedReesMatrixSemigroupOfDClass', 'Associates', 'AssocWordByLetterRep', 'AsSortedList', 'AsSSortedList',
    'AsStruct', 'AsSubalgebra', 'AsSubalgebraWithOne', 'AsSubgroup', 'AsSubgroupOfWholeGroupByQuotient', 'AsSubmagma', 'AsSubmonoid', 'AsSubsemigroup',
    'AsSubspace', 'AsSubstruct', 'AsTransformation', 'AsTwoSidedIdeal', 'AsVectorSpace', 'Atan', 'Atan2', 'Atanh',
    'AtlasIrrationality', 'AttributeValueNotSet', 'AugmentationIdeal', 'AugmentedCosetTableInWholeGroup', 'AugmentedCosetTableMtc', 'AugmentedCosetTableRrs', 'AutomorphismDomain', 'AutomorphismGroup',
    'AutomorphismsOfTable', 'Backtrace', 'BANNER', 'BaseFixedSpace', 'BaseIntersectionIntMats', 'BaseIntMat', 'BaseMat', 'BaseMatDestructive',
    'BaseOfGroup', 'BaseOrthogonalSpaceMat', 'BaseStabChain', 'BaseSteinitzVectors', 'BasicSpinRepresentationOfSymmetricGroup', 'BasicWreathProductOrdering', 'Basis', 'BasisNC',
    'BasisVectors', 'Bell', 'Bernoulli', 'BestQuoInt', 'BestSplittingMatrix', 'BiAlgebraModule', 'BiAlgebraModuleByGenerators', 'BibEntry',
    'BilinearFormMat', 'BinaryRelationByElements', 'BinaryRelationOnPoints', 'BinaryRelationOnPointsNC', 'BindGlobal', 'Binomial', 'BisectInterval', 'BlistList',
    'BlockMatrix', 'Blocks', 'BlocksInfo', 'BlownUpMat', 'BlownUpVector', 'BlowupInterval', 'BlowUpIsomorphism', 'BombieriNorm',
    'Brauer', 'BrauerCharacterValue', 'BrauerTable', 'BrauerTableOp', 'BravaisGroup', 'BravaisSubgroups', 'BravaisSupergroups', 'Break',
    'CallFuncList', 'CallWithTimeout', 'CallWithTimeoutList', 'CanComputeIndex', 'CanComputeIsSubset', 'CanComputeSize', 'CanComputeSizeAnySubgroup', 'CanEasilyCompareElements',
    'CanEasilyCompareElementsFamily', 'CanEasilyComputePcgs', 'CanEasilyComputeWithIndependentGensAbelianGroup', 'CanEasilySortElements', 'CanEasilySortElementsFamily', 'CanEasilyTestMembership', 'CanonicalBasis', 'CanonicalGenerators',
    'CanonicalPcElement', 'CanonicalPcgs', 'CanonicalPcgsByGeneratorsWithImages', 'CanonicalRepresentativeDeterminatorOfExternalSet', 'CanonicalRepresentativeOfExternalSet', 'CanonicalRightCosetElement', 'Carmichael\'s', 'CartanMatrix',
    'CartanSubalgebra', 'Cartesian', 'CategoriesOfObject', 'CategoryCollections', 'CategoryFamily', 'Ceil', 'Center', 'CentralCharacter',
    'CentralIdempotentsOfAlgebra', 'Centralizer', 'CentralizerInGLnZ', 'CentralizerModulo', 'CentralizerSizeLimitConsiderFunction', 'CentralNormalSeriesByPcgs', 'Centre', 'CentreOfCharacter',
    'CF', 'ChangeStabChain', 'Character', 'CharacterDegrees', 'Characteristic', 'CharacteristicPolynomial', 'CharacterNames', 'CharacterParameters',
    'CharacterTable', 'CharacterTableDirectProduct', 'CharacterTableFactorGroup', 'CharacterTableIsoclinic', 'CharacterTableRegular', 'CharacterTableWithSortedCharacters', 'CharacterTableWithSortedClasses', 'CharacterTableWithStoredGroup',
    'CharacterTableWreathSymmetric', 'CharInt', 'CharsFamily', 'CharSInt', 'CheckDigitISBN', 'CheckDigitISBN13', 'CheckDigitPostalMoneyOrder', 'CheckDigitTestFunction',
    'CheckDigitUPC', 'CheckFixedPoints', 'CheckForHandlingByNiceBasis', 'CheckPermChar', 'ChevalleyBasis', 'ChiefNormalSeriesByPcgs', 'ChiefSeries', 'ChiefSeriesThrough',
    'ChiefSeriesUnderAction', 'Chinese', 'ChineseRem', 'Chomp', 'Cite', 'CIUnivPols', 'ClassElementLattice', 'ClassesSolvableGroup',
    'ClassFunction', 'ClassFunctionSameType', 'ClassMultiplicationCoefficient', 'ClassNames', 'ClassNamesTom', 'ClassOrbit', 'ClassParameters', 'ClassPermutation',
    'ClassPositionsOfAgemo', 'ClassPositionsOfCenter', 'ClassPositionsOfCentre', 'ClassPositionsOfDerivedSubgroup', 'ClassPositionsOfDirectProductDecompositions', 'ClassPositionsOfElementaryAbelianSeries', 'ClassPositionsOfFittingSubgroup', 'ClassPositionsOfKernel',
    'ClassPositionsOfLowerCentralSeries', 'ClassPositionsOfMaximalNormalSubgroups', 'ClassPositionsOfMinimalNormalSubgroups', 'ClassPositionsOfNormalClosure', 'ClassPositionsOfNormalSubgroup', 'ClassPositionsOfNormalSubgroups', 'ClassPositionsOfPCore', 'ClassPositionsOfSupersolvableResiduum',
    'ClassPositionsOfUpperCentralSeries', 'ClassRoots', 'ClassStructureCharTable', 'ClassTypesTom', 'CleanedTailPcElement', 'ClearCacheStats', 'ClearProfile', 'CloseMutableBasis',
    'CloseStream', 'ClosureGroup', 'ClosureGroupAddElm', 'ClosureGroupCompare', 'ClosureGroupDefault', 'ClosureGroupIntest', 'ClosureLeftModule', 'ClosureNearAdditiveGroup',
    'ClosureRing', 'ClosureStruct', 'ClosureSubgroup', 'ClosureSubgroupNC', 'Coboundaries', 'Cochain', 'CochainSpace', 'Cocycles',
    'CodegreeOfPartialPerm', 'CodegreeOfPartialPermCollection', 'CodegreeOfPartialPermSemigroup', 'CodePcGroup', 'CodePcgs', 'Coefficients', 'CoefficientsAndMagmaElements', 'CoefficientsFamily',
    'CoefficientsMultiadic', 'CoefficientsOfLaurentPolynomial', 'CoefficientsOfUnivariatePolynomial', 'CoefficientsOfUnivariateRationalFunction', 'CoefficientsQadic', 'CoefficientsRing', 'CoeffsCyc', 'CoeffsMod',
    'COHORTS_PRIMITIVE_GROUPS', 'CoKernelOfAdditiveGeneralMapping', 'CoKernelOfMultiplicativeGeneralMapping', 'CollapsedMat', 'Collected', 'CollectionsFamily', 'ColorPrompt', 'Columns',
    'Combinations', 'CombinatorialCollector', 'Comm', 'CommutativeDiagram', 'CommutatorFactorGroup', 'CommutatorLength', 'CommutatorSubgroup', 'Compacted',
    'CompanionMat', 'CompareVersionNumbers', 'CompatibleConjugacyClasses', 'CompatiblePairs', 'ComplementClassesRepresentatives', 'ComplementClassesRepresentativesEA', 'ComplementIntMat', 'ComplementSystem',
    'ComplexConjugate', 'ComplexI', 'ComplexificationQuat', 'ComponentPartialPermInt', 'ComponentRepsOfPartialPerm', 'ComponentRepsOfTransformation', 'ComponentsOfPartialPerm', 'ComponentsOfTransformation',
    'ComponentTransformationInt', 'CompositionMapping', 'CompositionMapping2', 'CompositionMapping2General', 'CompositionMaps', 'CompositionOfStraightLinePrograms', 'CompositionSeries', 'ComputedBrauerTables',
    'ComputedClassFusions', 'ComputedIndicators', 'ComputedIsPSolubleCharacterTables', 'ComputedIsPSolvableCharacterTables', 'ComputedPowerMaps', 'ComputedPrimeBlockss', 'Concatenation', 'Conductor',
    'ConfluentRws', 'Congruences', 'ConjugacyClass', 'ConjugacyClasses', 'ConjugacyClassesByOrbits', 'ConjugacyClassesByRandomSearch', 'ConjugacyClassesMaximalSubgroups', 'ConjugacyClassesPerfectSubgroups',
    'ConjugacyClassesSubgroups', 'ConjugacyClassSubgroups', 'ConjugateDominantWeight', 'ConjugateDominantWeightWithWord', 'ConjugateGroup', 'Conjugates', 'ConjugateSubgroup', 'ConjugateSubgroups',
    'ConjugatorAutomorphism', 'ConjugatorAutomorphismNC', 'ConjugatorIsomorphism', 'ConjugatorOfConjugatorIsomorphism', 'ConsiderKernels', 'ConsiderSmallerPowerMaps', 'ConsiderStructureConstants', 'ConsiderTableAutomorphisms',
    'ConstantTimeAccessList', 'ConstantTransformation', 'ConstituentsCompositionMapping', 'ConstituentsOfCharacter', 'ContainedCharacters', 'ContainedDecomposables', 'ContainedMaps', 'ContainedPossibleCharacters',
    'ContainedPossibleVirtualCharacters', 'ContainedSpecialVectors', 'ContainedTom', 'ContainingTom', 'ContinuedFractionApproximationOfRoot', 'ContinuedFractionExpansionOfRoot', 'ConvertToBlistRep', 'ConvertToCharacterTable',
    'ConvertToCharacterTableNC', 'ConvertToMatrixRep', 'ConvertToMatrixRepNC', 'ConvertToRangeRep', 'ConvertToStringRep', 'ConvertToTableOfMarks', 'ConvertToVectorRep', 'ConvertToVectorRepNC',
    'ConwayPolynomial', 'Copy', 'CopyListEntries', 'CopyOptionsDefaults', 'CopyStabChain', 'CopyToStringRep', 'Core', 'CorrespondingGeneratorsByModuloPcgs',
    'Cos', 'CosetDecomposition', 'CosetLeadersMatFFE', 'CosetTable', 'CosetTableBySubgroup', 'CosetTableDefaultLimit', 'CosetTableDefaultMaxLimit', 'CosetTableFromGensAndRels',
    'CosetTableInWholeGroup', 'CosetTableOfFpSemigroup', 'CosetTableStandard', 'Cosh', 'Cot', 'Coth', 'CoverageLineByLine', 'CrcFile',
    'CrcString', 'CrystGroupDefaultAction', 'Csc', 'Csch', 'CubeRoot', 'Cycle', 'CycleIndex', 'CycleLength',
    'CycleLengths', 'Cycles', 'CyclesOfTransformation', 'CycleStructureClass', 'CycleStructurePerm', 'CycleTransformationInt', 'CyclicExtensionsTom', 'CyclicGroup',
    'CyclotomicField', 'CyclotomicPolynomial', 'Cyclotomics', 'CyclotomicsFamily', 'Darstellungsgruppe', 'DataType', 'DayDMY', 'DaysInMonth',
    'DaysInYear', 'DEC', 'DeclareAttribute', 'DeclareAutoPackage', 'DeclareAutoreadableVariables', 'DeclareCategory', 'DeclareFilter', 'DeclareGlobalFunction',
    'DeclareGlobalVariable', 'DeclareHandlingByNiceBasis', 'DeclareInfoClass', 'DeclareOperation', 'DeclarePackage', 'DeclarePackageAutoDocumentation', 'DeclarePackageDocumentation', 'DeclareProperty',
    'DeclareRepresentation', 'DeclareSynonym', 'DeclareSynonymAttr', 'DeclareUserPreference', 'DecodeTree', 'DecomposedFixedPointVector', 'DecomposeTensorProduct', 'Decomposition',
    'DecompositionInt', 'DecompositionMatrix', 'Decreased', 'DEFAULTDISPLAYSTRING', 'DefaultField', 'DefaultFieldByGenerators', 'DefaultFieldOfMatrix', 'DefaultFieldOfMatrixGroup',
    'DefaultInfoHandler', 'DefaultRing', 'DefaultRingByGenerators', 'DefaultStabChainOptions', 'DEFAULTVIEWSTRING', 'DefiningPolynomial', 'DefiningQuotientHomomorphism', 'DegreeFFE',
    'DegreeIndeterminate', 'DegreeOfBinaryRelation', 'DegreeOfCharacter', 'DegreeOfLaurentPolynomial', 'DegreeOfPartialPerm', 'DegreeOfPartialPermCollection', 'DegreeOfPartialPermSemigroup', 'DegreeOfTransformation',
    'DegreeOfTransformationCollection', 'DegreeOfTransformationSemigroup', 'DegreeOverPrimeField', 'Delta', 'DenominatorCyc', 'DenominatorOfModuloPcgs', 'DenominatorOfRationalFunction', 'DenominatorRat',
    'DenseHashTable', 'DenseIntKey', 'DepthOfPcElement', 'DepthOfUpperTriangularMatrix', 'Derangements', 'Derivations', 'Derivative', 'DerivedLength',
    'DerivedSeriesOfGroup', 'DerivedSubgroup', 'DerivedSubgroupsTom', 'DerivedSubgroupsTomPossible', 'DerivedSubgroupsTomUnique', 'DerivedSubgroupTom', 'DescriptionOfRootOfUnity', 'Determinant',
    'DeterminantIntMat', 'DeterminantMat', 'DeterminantMatDestructive', 'DeterminantMatDivFree', 'DeterminantOfCharacter', 'DiagonalizeIntMat', 'DiagonalizeMat', 'DiagonalMat',
    'DiagonalOfMat', 'DictionaryByPosition', 'DicyclicGroup', 'Difference', 'DifferenceBlist', 'DihedralGroup', 'Dimension', 'DimensionOfHighestWeightModule',
    'DimensionOfMatrixGroup', 'DimensionOfVectors', 'DimensionsLoewyFactors', 'DimensionsMat', 'DirectoriesLibrary', 'DirectoriesPackageLibrary', 'DirectoriesPackagePrograms', 'DirectoriesSystemPrograms',
    'Directory', 'DirectoryContents', 'DirectoryCurrent', 'DirectoryDesktop', 'DirectoryHome', 'DirectoryTemporary', 'DirectProduct', 'DirectProductOp',
    'DirectSum', 'DirectSumDecomposition', 'DirectSumOfAlgebraModules', 'DirectSumOfAlgebras', 'DirectSumOp', 'DisableAttributeValueStoring', 'Discriminant', 'Display',
    'DisplayCacheStats', 'DisplayCompositionSeries', 'DisplayEggBoxOfDClass', 'DisplayImfInvariants', 'DisplayInformationPerfectGroups', 'DisplayOptions', 'DisplayOptionsStack', 'DisplayPackageLoadingLog',
    'DisplayProfile', 'DisplayString', 'DistancePerms', 'DistancesDistributionMatFFEVecFFE', 'DistancesDistributionVecFFEsVecFFE', 'DistanceVecFFE', 'DivisionRingByGenerators', 'DivisorsInt',
    'Dixon-Schneider', 'DixonInit', 'DixonRecord', 'DixonSplit', 'DixontinI', 'DMYDay', 'DMYhmsSeconds', 'DnLattice',
    'DnLatticeIterative', 'Domain', 'DomainByGenerators', 'DomainOfPartialPerm', 'DomainOfPartialPermCollection', 'DominantCharacter', 'DominantWeights', 'DotFileLatticeSubgroups',
    'DoubleCoset', 'DoubleCosetRepsAndSizes', 'DoubleCosets', 'DoubleCosetsNC', 'DoubleCoverOfAlternatingGroup', 'DoubleHashArraySize', 'DownEnv', 'DuplicateFreeList',
    'DxIncludeIrreducibles', 'E', 'EANormalSeriesByPcgs', 'Earns', 'EB', 'EC', 'ED', 'Edit',
    'EE', 'EF', 'EG', 'EggBoxOfDClass', 'EH', 'EI', 'Eigenspaces', 'Eigenvalues',
    'EigenvaluesChar', 'Eigenvectors', 'EJ', 'EK', 'EL', 'ElementaryAbelianGroup', 'ElementaryAbelianSeries', 'ElementaryAbelianSeriesLargeSteps',
    'ElementaryDivisorsMat', 'ElementaryDivisorsMatDestructive', 'ElementaryDivisorsTransformationsMat', 'ElementaryDivisorsTransformationsMatDestructive', 'ElementOfFpGroup', 'ElementOfFpSemigroup', 'ElementOfMagmaRing', 'ElementOrdersPowerMap',
    'ElementProperty', 'Elements', 'ElementsFamily', 'ElementsStabChain', 'EliminatedWord', 'EliminationOrdering', 'ElmWPObj', 'EM',
    'Embedding', 'EmptyBinaryRelation', 'EmptyMatrix', 'EmptyPartialPerm', 'EmptyPlist', 'EmptySCTable', 'EmptyStabChain', 'EmptyString',
    'EnableAttributeValueStoring', 'End', 'EndlineFunc', 'EndsWith', 'Enumerator', 'EnumeratorByBasis', 'EnumeratorByFunctions', 'EnumeratorOfCombinations',
    'EnumeratorOfTuples', 'EnumeratorSorted', 'Epicentre', 'EpimorphismFromFreeGroup', 'EpimorphismNilpotentQuotient', 'EpimorphismNonabelianExteriorSquare', 'EpimorphismPGroup', 'EpimorphismQuotientSystem',
    'EpimorphismSchurCover', 'EpimorphismSolvableQuotient', 'EqFloat', 'EquivalenceClasses', 'EquivalenceClassOfElement', 'EquivalenceClassOfElementNC', 'EquivalenceClassRelation', 'EquivalenceRelationByPairs',
    'EquivalenceRelationByPairsNC', 'EquivalenceRelationByPartition', 'EquivalenceRelationByPartitionNC', 'EquivalenceRelationByProperty', 'EquivalenceRelationByRelation', 'EquivalenceRelationPartition', 'ER', 'Erf',
    'Error', 'ErrorCount', 'ErrorNoReturn', 'ErrorNoTraceBack', 'ES', 'ET', 'EU', 'EuclideanDegree',
    'EuclideanQuotient', 'EuclideanRemainder', 'Euler\'s', 'EulerianFunction', 'EulerianFunctionByTom', 'EV', 'EvalStraightLineProgElm', 'EvalString',
    'EW', 'EX', 'ExactSizeConsiderFunction', 'Excel', 'Exec', 'Exp', 'Exp10', 'Exp2',
    'Expanded', 'Expm1', 'Exponent', 'ExponentOfPcElement', 'ExponentsConjugateLayer', 'ExponentsOfCommutator', 'ExponentsOfConjugate', 'ExponentsOfPcElement',
    'ExponentsOfRelativePower', 'ExponentSumWord', 'ExponentSyllable', 'ExtendedPcgs', 'ExtendRootDirectories', 'ExtendStabChain', 'Extension', 'ExtensionNC',
    'ExtensionRepresentatives', 'Extensions', 'ExteriorCentre', 'ExteriorPowerOfAlgebraModule', 'External', 'ExternalOrbit', 'ExternalOrbits', 'ExternalOrbitsStabilizers',
    'ExternalSet', 'ExternalSubset', 'Extract', 'ExtraspecialGroup', 'ExtRepDenominatorRatFun', 'ExtRepNumeratorRatFun', 'ExtRepOfObj', 'ExtRepPolynomialRatFun',
    'EY', 'FactorCosetAction', 'FactorFreeSemigroupByRelations', 'FactorGroup', 'FactorGroupFpGroupByRels', 'FactorGroupNC', 'FactorGroupNormalSubgroupClasses', 'FactorGroupTom',
    'Factorial', 'Factorization', 'Factors', 'FactorsInt', 'FactorsOfDirectProduct', 'FactorsSquarefree', 'FaithfulModule', 'FamiliesOfGeneralMappingsAndRanges',
    'FamiliesOfRows', 'FamilyForOrdering', 'FamilyObj', 'FamilyPcgs', 'FamilyRange', 'FamilySource', 'Fibonacci', 'Field',
    'FieldByGenerators', 'FieldExtension', 'FieldOfMatrixGroup', 'FieldOverItselfByGenerators', 'FileDescriptorOfStream', 'Filename', 'FilenameFunc', 'Filtered',
    'FindSl2', 'First', 'FittingSubgroup', 'FixedPointsOfPartialPerm', 'Flat', 'FlatKernelOfTransformation', 'Float', 'FLOAT',
    'Floor', 'FlushCaches', 'FOA', 'ForAll', 'ForAny', 'FORCE_QUIT_GAP', 'FpElmComparisonMethod', 'FpGroupPresentation',
    'FpGrpMonSmgOfFpGrpMonSmgElement', 'FpLieAlgebraByCartanMatrix', 'Frac', 'Frame', 'FrattiniSubgroup', 'FreeAbelianGroup', 'FreeAlgebra', 'FreeAlgebraWithOne',
    'FreeAssociativeAlgebra', 'FreeAssociativeAlgebraWithOne', 'FreeGeneratorsOfFpGroup', 'FreeGeneratorsOfFpSemigroup', 'FreeGeneratorsOfWholeGroup', 'FreeGroup', 'FreeGroupOfFpGroup', 'FreeLeftModule',
    'FreeLieAlgebra', 'FreeMagma', 'FreeMagmaRing', 'FreeMagmaWithOne', 'FreeMonoid', 'FreeMonoidOfRewritingSystem', 'FreeProduct', 'FreeSemigroup',
    'FreeSemigroupOfFpSemigroup', 'FreeSemigroupOfRewritingSystem', 'Frobenius', 'FrobeniusAutomorphism', 'FrobeniusCharacterValue', 'FullMatrixAlgebra', 'FullMatrixAlgebraCentralizer', 'FullMatrixLieAlgebra',
    'FullMatrixModule', 'FullMatrixSpace', 'FullRowModule', 'FullRowSpace', 'FullTransformationMonoid', 'FullTransformationSemigroup', 'FunctionAction', 'FunctionField',
    'FunctionOperation', 'FunctionsFamily', 'FusionCharTableTom', 'FusionConjugacyClasses', 'FusionConjugacyClassesOp', 'FusionsAllowedByRestrictions', 'FusionsTom', 'G-sets',
    'GaloisCyc', 'GaloisField', 'GaloisGroup', 'GaloisMat', 'GaloisStabilizer', 'GaloisType', 'Gamma', 'GammaL',
    'Gap3CatalogueIdGroup', 'GAP_EXIT_CODE', 'GAPInfo', 'GAPInfo.Architecture', 'GAPInfo.CommandLineOptions', 'GAPInfo.Keywords', 'GAPInfo.ProfileThreshold', 'GAPInfo.RootPaths',
    'GAPInfo.TimeoutsSupported', 'GAPInfo.UserGapRoot', 'GAPInfo.Version', 'GapInputPcGroup', 'GapInputSCTable', 'GAPKB_REW', 'GAPTCENUM', 'GasmanLimits',
    'GasmanMessageStatus', 'GasmanStatistics', 'Gaussian', 'GaussianIntegers', 'GaussianRationals', 'Gcd', 'Gcdex', 'GcdInt',
    'GcdOp', 'GcdRepresentation', 'GcdRepresentationOp', 'GeneralisedEigenspaces', 'GeneralisedEigenvalues', 'GeneralizedEigenspaces', 'GeneralizedEigenvalues', 'GeneralLinearGroup',
    'GeneralMappingByElements', 'GeneralMappingsFamily', 'GeneralOrthogonalGroup', 'GeneralSemilinearGroup', 'GeneralUnitaryGroup', 'GeneratorsOfAdditiveGroup', 'GeneratorsOfAdditiveMagma', 'GeneratorsOfAdditiveMagmaWithZero',
    'GeneratorsOfAlgebra', 'GeneratorsOfAlgebraModule', 'GeneratorsOfAlgebraWithOne', 'GeneratorsOfDivisionRing', 'GeneratorsOfDomain', 'GeneratorsOfEquivalenceRelationPartition', 'GeneratorsOfField', 'GeneratorsOfGroup',
    'GeneratorsOfIdeal', 'GeneratorsOfInverseMonoid', 'GeneratorsOfInverseSemigroup', 'GeneratorsOfLeftIdeal', 'GeneratorsOfLeftModule', 'GeneratorsOfLeftOperatorAdditiveGroup', 'GeneratorsOfLeftVectorSpace', 'GeneratorsOfMagma',
    'GeneratorsOfMagmaWithInverses', 'GeneratorsOfMagmaWithOne', 'GeneratorsOfMonoid', 'GeneratorsOfNearAdditiveGroup', 'GeneratorsOfNearAdditiveMagma', 'GeneratorsOfNearAdditiveMagmaWithZero', 'GeneratorsOfPresentation', 'GeneratorsOfRightIdeal',
    'GeneratorsOfRightModule', 'GeneratorsOfRightOperatorAdditiveGroup', 'GeneratorsOfRing', 'GeneratorsOfRingWithOne', 'GeneratorsOfRws', 'GeneratorsOfSemigroup', 'GeneratorsOfStruct', 'GeneratorsOfTwoSidedIdeal',
    'GeneratorsOfVectorSpace', 'GeneratorsPrimeResidues', 'GeneratorsSmallest', 'GeneratorsSubgroupsTom', 'GeneratorSyllable', 'GetCyclotomicsLimit', 'GetFusionMap', 'GF',
    'GL', 'GlobalMersenneTwister', 'GlobalRandomSource', 'GModuleByMats', 'GO', 'GQuotients', 'Grading', 'GreensDClasses',
    'GreensDClassOfElement', 'GreensDRelation', 'GreensHClasses', 'GreensHClassOfElement', 'GreensHRelation', 'GreensJClasses', 'GreensJClassOfElement', 'GreensJRelation',
    'GreensLClasses', 'GreensLClassOfElement', 'GreensLRelation', 'GreensRClasses', 'GreensRClassOfElement', 'GreensRRelation', 'GroebnerBasis', 'GroebnerBasisNC',
    'Group', 'GroupByGenerators', 'GroupByRws', 'GroupByRwsNC', 'GroupGeneralMappingByImages', 'GroupGeneralMappingByImagesNC', 'GroupHClassOfGreensDClass', 'GroupHomomorphismByFunction',
    'GroupHomomorphismByImages', 'GroupHomomorphismByImagesNC', 'GroupOfPcgs', 'GroupRing', 'GroupStabChain', 'GroupWithGenerators', 'GrowthFunctionOfGroup', 'GU',
    'HallSubgroup', 'HallSystem', 'HasAbelianFactorGroup', 'HasElementaryAbelianFactorGroup', 'HasIndeterminateName', 'HasParent', 'HasseDiagramBinaryRelation', 'HeadPcElementByNumber',
    'HELP_ADD_BOOK', 'HELP_REMOVE_BOOK', 'HELP_VIEWER_INFO', 'HenselBound', 'Hermite', 'HermiteNormalFormIntegerMat', 'HermiteNormalFormIntegerMatTransform', 'HeuristicCancelPolynomialsExtRep',
    'HexStringInt', 'HighestWeightModule', 'HMSMSec', 'Hom', 'HomeEnumerator', 'HomomorphismQuotientSemigroup', 'Hypothenuse', 'Ideal',
    'IdealByGenerators', 'IdealNC', 'Ideals', 'Idempotent', 'Idempotents', 'IdempotentsTom', 'IdempotentsTomInfo', 'IdentificationOfConjugacyClasses',
    'Identifier', 'Identity', 'IdentityBinaryRelation', 'IdentityFromSCTable', 'IdentityMapping', 'IdentityMat', 'IdentityTransformation', 'IdFunc',
    'IdGap3SolvableGroup', 'IdGroup', 'IdSmallGroup', 'IdsOfAllSmallGroups', 'Image', 'ImageElm', 'ImageListOfPartialPerm', 'ImageListOfTransformation',
    'ImageOfPartialPermCollection', 'Images', 'ImagesElm', 'ImageSetOfPartialPerm', 'ImageSetOfTransformation', 'ImagesRepresentative', 'ImagesSet', 'ImagesSmallestGenerators',
    'ImagesSource', 'ImaginaryPart', 'ImfInvariants', 'ImfMatrixGroup', 'ImfNumberQClasses', 'ImfNumberQQClasses', 'ImfNumberZClasses', 'Immutable',
    'ImmutableBasis', 'ImmutableMatrix', 'IncreaseInterval', 'IndependentGeneratorExponents', 'IndependentGeneratorsOfAbelianGroup', 'Indeterminate', 'IndeterminateName', 'Indeterminateness',
    'IndeterminateNumberOfLaurentPolynomial', 'IndeterminateNumberOfUnivariateRationalFunction', 'IndeterminateOfUnivariateRationalFunction', 'IndeterminatesOfFunctionField', 'IndeterminatesOfPolynomialRing', 'Index', 'IndexInWholeGroup', 'IndexNC',
    'IndexPeriodOfPartialPerm', 'IndexPeriodOfTransformation', 'Indicator', 'IndicatorOp', 'IndicesCentralNormalSteps', 'IndicesChiefNormalSteps', 'IndicesEANormalSteps', 'IndicesInvolutaryGenerators',
    'IndicesNormalSteps', 'IndicesOfAdjointBasis', 'IndicesPCentralNormalStepsPGroup', 'IndicesStabChain', 'Indirected', 'InducedAutomorphism', 'InducedClassFunction', 'InducedClassFunctions',
    'InducedClassFunctionsByFusionMap', 'InducedCyclic', 'InducedPcgs', 'InducedPcgsByGenerators', 'InducedPcgsByGeneratorsNC', 'InducedPcgsByPcSequence', 'InducedPcgsByPcSequenceAndGenerators', 'InducedPcgsByPcSequenceNC',
    'InducedPcgsWrtFamilyPcgs', 'InducedPcgsWrtSpecialPcgs', 'Inequalities', 'InertiaSubgroup', 'Inf', 'InfoAlgebra', 'InfoAttributes',
    'InfoBckt', 'InfoCharacterTable', 'InfoCoh', 'InfoComplement', 'InfoCoset', 'InfoFpGroup', 'InfoGroebner', 'InfoGroup',
    'InfoLattice', 'InfoLevel', 'InfoMatrix', 'InfoMonomial', 'InfoNumtheor', 'InfoObsolete', 'InfoOptions', 'InfoPackageLoading',
    'InfoPcSubgroup', 'InfoPoly', 'InfoText', 'InfoTom', 'InfoWarning', 'Init', 'InitFusion', 'InitPowerMap',
    'InjectionZeroMagma', 'InnerAutomorphism', 'InnerAutomorphismNC', 'InnerAutomorphismsAutomorphismGroup', 'InParentFOA', 'InputFromUser', 'InputLogTo', 'InputOutputLocalProcess',
    'InputTextFile', 'InputTextNone', 'InputTextString', 'InputTextUser', 'InsertTrivialStabilizer', 'InstallAtExit', 'InstallCharReadHookFunc', 'InstalledPackageVersion',
    'InstallFactorMaintenance', 'InstallFlushableValue', 'InstallFlushableValueFromFunction', 'InstallGlobalFunction', 'InstallHandlingByNiceBasis', 'InstallImmediateMethod', 'InstallIsomorphismMaintenance', 'InstallMethod',
    'InstallOtherMethod', 'InstallReadlineMacro', 'InstallSubsetMaintenance', 'InstallTrueMethod', 'InstallValue', 'Int', 'IntChar', 'Integers',
    'IntegralizedMat', 'IntegratedStraightLineProgram', 'IntermediateGroup', 'IntermediateResultOfSLP', 'IntermediateResultOfSLPWithoutOverwrite', 'IntermediateResultsOfSLPWithoutOverwrite', 'IntermediateSubgroups', 'InterpolatedPolynomial',
    'IntersectBlist', 'Intersection', 'Intersection2', 'IntersectionBlist', 'IntersectionsTom', 'IntersectSet', 'IntFFE', 'IntFFESymm',
    'IntHexString', 'IntScalarProducts', 'IntVecFFE', 'InvariantBilinearForm', 'InvariantElementaryAbelianSeries', 'InvariantLattice', 'InvariantQuadraticForm', 'InvariantSesquilinearForm',
    'InvariantSubgroupsElementaryAbelianGroup', 'Inverse', 'InverseAttr', 'InverseClasses', 'InverseGeneralMapping', 'InverseImmutable', 'InverseMap', 'InverseMatMod',
    'InverseMonoid', 'InverseMutable', 'InverseOfTransformation', 'InverseOp', 'InverseRepresentative', 'InverseSameMutability', 'InverseSemigroup', 'InverseSM',
    'InversesOfSemigroupElement', 'InvocationReadlineMacro', 'Irr', 'IrrBaumClausen', 'IrrConlon', 'IrrDixonSchneider', 'IrreducibleDifferences', 'IrreducibleModules',
    'IrreducibleModules', 'IrreducibleRepresentations', 'IrreducibleRepresentationsDixon', 'IrreducibleSolvableGroup', 'IrreducibleSolvableGroupMS', 'Is16BitsFamily', 'Is32BitsFamily', 'IsAbelian',
    'IsAbelianNumberField', 'IsAbelianNumberFieldPolynomialRing', 'IsAbelianTom', 'IsAdditiveElement', 'IsAdditiveElementWithInverse', 'IsAdditiveElementWithZero', 'IsAdditiveGroup', 'IsAdditiveGroupGeneralMapping',
    'IsAdditiveGroupHomomorphism', 'IsAdditivelyCommutative', 'IsAdditivelyCommutativeElement', 'IsAdditivelyCommutativeElementCollColl', 'IsAdditivelyCommutativeElementCollection', 'IsAdditivelyCommutativeElementFamily', 'IsAdditiveMagma', 'IsAdditiveMagmaWithInverses',
    'IsAdditiveMagmaWithZero', 'IsAlgebra', 'IsAlgebraGeneralMapping', 'IsAlgebraHomomorphism', 'IsAlgebraicElement', 'IsAlgebraicExtension', 'IsAlgebraModuleElement', 'IsAlgebraModuleElementCollection',
    'IsAlgebraModuleElementFamily', 'IsAlgebraWithOne', 'IsAlgebraWithOneGeneralMapping', 'IsAlgebraWithOneHomomorphism', 'IsAlmostSimple', 'IsAlmostSimpleGroup', 'IsAlphaChar', 'IsAlternatingGroup',
    'IsAnticommutative', 'IsAntisymmetricBinaryRelation', 'IsAssociated', 'IsAssociative', 'IsAssociativeElement', 'IsAssociativeElementCollColl', 'IsAssociativeElementCollection', 'IsAssocWord',
    'IsAssocWordWithInverse', 'IsAssocWordWithOne', 'IsAttributeStoringRep', 'IsAttributeStoringRep', 'IsAutomorphismGroup', 'IsBasicWreathLessThanOrEqual', 'IsBasicWreathProductOrdering', 'IsBasis',
    'IsBasisByNiceBasis', 'IsBasisOfAlgebraModuleElementSpace', 'IsBergerCondition', 'IsBijective', 'IsBinaryRelation', 'IsBinaryRelation', 'IsBLetterAssocWordRep', 'IsBLetterWordsFamily',
    'IsBlist', 'IsBlistRep', 'IsBlockMatrixRep', 'IsBool', 'IsBoundElmWPObj', 'IsBoundGlobal', 'IsBrauerTable',
    'IsBravaisGroup', 'IsBuiltFromAdditiveMagmaWithInverses', 'IsBuiltFromGroup', 'IsBuiltFromMagma', 'IsBuiltFromMagmaWithInverses', 'IsBuiltFromMagmaWithOne', 'IsBuiltFromSemigroup', 'IsCanonicalBasis',
    'IsCanonicalBasisFullMatrixModule', 'IsCanonicalBasisFullRowModule', 'IsCanonicalNiceMonomorphism', 'IsCanonicalPcgs', 'IsCentral', 'IsCentralFactor', 'IsChar', 'IsCharacter',
    'IsCharacteristicSubgroup', 'IsCharacterTable', 'IsCharacterTableInProgress', 'IsCharCollection', 'IsCheapConwayPolynomial', 'IsClassFunction', 'IsClassFusionOfNormalSubgroup', 'IsClosedStream',
    'IsCochain', 'IsCochainCollection', 'IsCollection', 'IsCollectionFamily', 'IsCommutative', 'IsCommutativeElement', 'IsCommutativeElementCollColl', 'IsCommutativeElementCollection',
    'IsComponentObjectRep', 'IsCompositionMappingRep', 'IsConfluent', 'IsConjugacyClassSubgroupsByStabilizerRep', 'IsConjugacyClassSubgroupsRep', 'IsConjugate', 'IsConjugatorAutomorphism', 'IsConjugatorIsomorphism',
    'IsConstantRationalFunction', 'IsConstantTimeAccessGeneralMapping', 'IsConstantTimeAccessList', 'IsContainedInSpan', 'IsCopyable', 'IsCyc', 'IsCyclic', 'IsCyclicTom',
    'IsCyclotomic', 'IsCyclotomicField', 'IsCyclotomicMatrixGroup', 'IsDenseList', 'IsDiagonalMat', 'IsDictionary', 'IsDigitChar', 'IsDirectory',
    'IsDirectoryPath', 'IsDirectProductElement', 'IsDisjoint', 'IsDistributive', 'IsDivisionRing', 'IsDomain', 'IsDoneIterator', 'IsDoubleCoset',
    'IsDuplicateFree', 'IsDuplicateFreeList', 'IsDxLargeGroup', 'IsElementaryAbelian', 'IsElementOfFpMonoid', 'IsElementOfFpSemigroup', 'IsElementOfFreeMagmaRing', 'IsElementOfFreeMagmaRingCollection',
    'IsElementOfFreeMagmaRingFamily', 'IsElementOfMagmaRingModuloRelations', 'IsElementOfMagmaRingModuloRelationsCollection', 'IsElementOfMagmaRingModuloRelationsFamily', 'IsElementOfMagmaRingModuloSpanOfZeroFamily', 'IsEmpty', 'IsEmptyString', 'IsEndOfStream',
    'IsEndoGeneralMapping', 'IsEqualSet', 'IsEquivalenceClass', 'IsEquivalenceRelation', 'IsEuclideanRing', 'IsEvenInt', 'IsExecutableFile', 'IsExistingFile',
    'IsExtAElement', 'IsExternalOrbit', 'IsExternalSet', 'IsExternalSubset', 'IsExtLElement', 'IsExtRElement', 'IsFamilyPcgs', 'IsFFE',
    'IsFFECollColl', 'IsFFECollCollColl', 'IsFFECollection', 'IsFFEMatrixGroup', 'IsField', 'IsFieldControlledByGaloisGroup', 'IsFieldHomomorphism', 'IsFinite',
    'IsFiniteDimensional', 'IsFiniteFieldPolynomialRing', 'IsFinitelyGeneratedGroup', 'IsFiniteOrderElement', 'IsFiniteOrderElementCollColl', 'IsFiniteOrderElementCollection', 'IsFiniteOrdersPcgs', 'IsFixedStabilizer',
    'IsFLMLOR', 'IsFLMLORWithOne', 'IsFpGroup', 'IsFpMonoid', 'IsFpSemigroup', 'IsFreeGroup', 'IsFreeLeftModule', 'IsFreeMagmaRing',
    'IsFreeMagmaRingWithOne', 'IsFromFpGroupGeneralMappingByImages', 'IsFromFpGroupHomomorphismByImages', 'IsFromFpGroupStdGensGeneralMappingByImages', 'IsFromFpGroupStdGensHomomorphismByImages', 'IsFullHomModule', 'IsFullMatrixModule', 'IsFullRowModule',
    'IsFullSubgroupGLorSLRespectingBilinearForm', 'IsFullSubgroupGLorSLRespectingQuadraticForm', 'IsFullSubgroupGLorSLRespectingSesquilinearForm', 'IsFullTransformationMonoid', 'IsFullTransformationSemigroup', 'IsFunction', 'IsFunctionField', 'IsGAPRandomSource',
    'IsGaussianIntegers', 'IsGaussianRationals', 'IsGaussianSpace', 'IsGaussInt', 'IsGaussRat', 'IsGeneralizedDomain', 'IsGeneralizedRowVector', 'IsGeneralLinearGroup',
    'IsGeneralMapping', 'IsGeneralMappingFamily', 'IsGeneratorsOfSemigroup', 'IsGeneratorsOfStruct', 'IsGL', 'IsGlobalRandomSource', 'IsGreensClass', 'IsGreensDClass',
    'IsGreensDRelation', 'IsGreensHClass', 'IsGreensHRelation', 'IsGreensJClass', 'IsGreensJRelation', 'IsGreensLClass', 'IsGreensLessThanOrEqual', 'IsGreensLRelation',
    'IsGreensRClass', 'IsGreensRelation', 'IsGreensRRelation', 'IsGroup', 'IsGroupGeneralMapping', 'IsGroupGeneralMappingByAsGroupGeneralMappingByImages', 'IsGroupGeneralMappingByImages', 'IsGroupGeneralMappingByPcgs',
    'IsGroupHClass', 'IsGroupHomomorphism', 'IsGroupOfAutomorphisms', 'IsGroupRing', 'IsHandledByNiceBasis', 'IsHandledByNiceMonomorphism', 'IsHasseDiagram', 'IsHomogeneousList',
    'IsIdempotent', 'IsIdenticalObj', 'IsIncomparableUnder', 'IsInducedFromNormalSubgroup', 'IsInducedPcgs', 'IsInducedPcgsWrtSpecialPcgs', 'IsInfBitsFamily', 'IsInfiniteAbelianizationGroup',
    'IsInfinity', 'IsInjective', 'IsInjectiveListTrans', 'IsInnerAutomorphism', 'IsInputOutputStream', 'IsInputStream', 'IsInputTextNone', 'IsInputTextStream',
    'IsInt', 'IsIntegerMatrixGroup', 'IsIntegers', 'IsIntegralBasis', 'IsIntegralCyclotomic', 'IsIntegralRing', 'IsInternallyConsistent', 'IsInverseMonoid',
    'IsInverseSemigroup', 'IsInverseSubsemigroup', 'IsIrreducibleCharacter', 'IsIrreducibleRingElement', 'IsIterator', 'IsJacobianElement', 'IsJacobianElementCollColl', 'IsJacobianElementCollection',
    'IsJacobianRing', 'IsLaurentPolynomial', 'IsLaurentPolynomialDefaultRep', 'IsLDistributive', 'IsLeftAlgebraModuleElement', 'IsLeftAlgebraModuleElementCollection', 'IsLeftIdeal', 'IsLeftIdealInParent',
    'IsLeftModule', 'IsLeftModuleGeneralMapping', 'IsLeftModuleHomomorphism', 'IsLeftOperatorAdditiveGroup', 'IsLeftSemigroupIdeal', 'IsLeftVectorSpace', 'IsLessThanOrEqualUnder', 'IsLessThanUnder',
    'IsLetterAssocWordRep', 'IsLetterWordsFamily', 'IsLexicographicallyLess', 'IsLexOrderedFFE', 'IsLieAbelian', 'IsLieAlgebra', 'IsLieMatrix', 'IsLieNilpotent',
    'IsLieObject', 'IsLieObjectCollection', 'IsLieSolvable', 'IsLinearMapping', 'IsLinearMappingsModule', 'IsLineByLineProfileActive', 'IsList', 'IsListDefault',
    'IsListOrCollection', 'IsLogOrderedFFE', 'IsLookupDictionary', 'IsLowerAlphaChar', 'IsLowerTriangularMat', 'IsMagma', 'IsMagmaHomomorphism', 'IsMagmaRingModuloRelations',
    'IsMagmaRingModuloSpanOfZero', 'IsMagmaRingObjDefaultRep', 'IsMagmaWithInverses', 'IsMagmaWithInversesIfNonzero', 'IsMagmaWithOne', 'IsMagmaWithZeroAdjoined', 'IsMapping', 'IsMatchingSublist',
    'IsMatrix', 'IsMatrixGroup', 'IsMatrixModule', 'IsMatrixSpace', 'IsMersenneTwister', 'IsMinimalNonmonomial', 'IsModuloPcgs', 'IsMonoid',
    'IsMonomial', 'IsMonomialGroup', 'IsMonomialMatrix', 'IsMonomialNumber', 'IsMonomialOrdering', 'IsMultiplicativeElement', 'IsMultiplicativeElementWithInverse', 'IsMultiplicativeElementWithOne',
    'IsMultiplicativeElementWithZero', 'IsMultiplicativeGeneralizedRowVector', 'IsMultiplicativeZero', 'IsMutable', 'IsMutableBasis', 'IsNaN', 'IsNaturalAlternatingGroup', 'IsNaturalGL',
    'IsNaturalGLnZ', 'IsNaturalSL', 'IsNaturalSLnZ', 'IsNaturalSymmetricGroup', 'IsNearAdditiveElement', 'IsNearAdditiveElementWithInverse', 'IsNearAdditiveElementWithZero', 'IsNearAdditiveGroup',
    'IsNearAdditiveMagma', 'IsNearAdditiveMagmaWithInverses', 'IsNearAdditiveMagmaWithZero', 'IsNearlyCharacterTable', 'IsNearRingElement', 'IsNearRingElementWithInverse', 'IsNearRingElementWithOne', 'IsNegInfinity',
    'IsNegRat', 'IsNilpotent', 'IsNilpotentElement', 'IsNilpotentGroup', 'IsNilpotentTom', 'IsNInfinity', 'IsNonassocWord', 'IsNonassocWordCollection',
    'IsNonassocWordWithOne', 'IsNonassocWordWithOneCollection', 'IsNonnegativeIntegers', 'IsNonSPGeneralMapping', 'IsNonTrivial', 'IsNormal', 'IsNormalBasis', 'IsNotIdenticalObj',
    'IsNumberField', 'IsObject', 'IsOddInt', 'IsomorphicSubgroups', 'IsomorphismFpAlgebra', 'IsomorphismFpGroup', 'IsomorphismFpGroupByGenerators', 'IsomorphismFpGroupByGeneratorsNC',
    'IsomorphismFpGroupByPcgs', 'IsomorphismFpSemigroup', 'IsomorphismGroups', 'IsomorphismMatrixAlgebra', 'IsomorphismPartialPermMonoid', 'IsomorphismPartialPermSemigroup', 'IsomorphismPcGroup', 'IsomorphismPermGroup',
    'IsomorphismPermGroupImfGroup', 'IsomorphismReesMatrixSemigroup', 'IsomorphismReesZeroMatrixSemigroup', 'IsomorphismRefinedPcGroup', 'IsomorphismRepStruct', 'IsomorphismSCAlgebra', 'IsomorphismSimplifiedFpGroup', 'IsomorphismSpecialPcGroup',
    'IsomorphismTransformationMonoid', 'IsomorphismTransformationSemigroup', 'IsomorphismTypeInfoFiniteSimpleGroup', 'IsOne', 'IsOperation', 'IsOrdering', 'IsOrderingOnFamilyOfAssocWords', 'IsOrdinaryMatrix',
    'IsOrdinaryTable', 'IsOutputStream', 'IsOutputTextNone', 'IsOutputTextStream', 'IsPackageMarkedForLoading', 'IsPadicExtensionNumber', 'IsPadicExtensionNumberFamily', 'IsParentPcgsFamilyPcgs',
    'IsPartialOrderBinaryRelation', 'IsPartialPerm', 'IsPartialPermCollection', 'IsPartialPermMonoid', 'IsPartialPermSemigroup', 'IsPcGroup', 'IsPcGroupGeneralMappingByImages', 'IsPcGroupHomomorphismByImages',
    'IsPcgs', 'IsPcgsCentralSeries', 'IsPcgsChiefSeries', 'IsPcgsElementaryAbelianSeries', 'IsPcgsPCentralSeriesPGroup', 'IsPerfect', 'IsPerfectGroup', 'IsPerfectTom',
    'IsPerm', 'IsPermCollColl', 'IsPermCollection', 'IsPermGroup', 'IsPermGroupGeneralMapping', 'IsPermGroupGeneralMappingByImages', 'IsPermGroupHomomorphism', 'IsPermGroupHomomorphismByImages',
    'IsPGroup', 'IsPInfinity', 'IsPNilpotent', 'IsPolycyclicGroup', 'IsPolynomial', 'IsPolynomialDefaultRep', 'IsPolynomialFunction', 'IsPolynomialFunctionsFamily',
    'IsPolynomialRing', 'IsPosInt', 'IsPositiveIntegers', 'IsPosRat', 'IsPreimagesByAsGroupGeneralMappingByImages', 'IsPreOrderBinaryRelation', 'IsPrime', 'IsPrimeField',
    'IsPrimeInt', 'IsPrimeOrdersPcgs', 'IsPrimePowerInt', 'IsPrimitive', 'IsPrimitiveCharacter', 'IsPrimitivePolynomial', 'IsPrimitiveRootMod', 'IsProbablyPrimeInt',
    'IsPseudoCanonicalBasisFullHomModule', 'IsPSolubleCharacterTable', 'IsPSolubleCharacterTableOp', 'IsPSolvable', 'IsPSolvableCharacterTable', 'IsPSolvableCharacterTableOp', 'IsPurePadicNumber', 'IsPurePadicNumberFamily',
    'IsQuasiPrimitive', 'IsQuaternion', 'IsQuaternionCollColl', 'IsQuaternionCollection', 'IsQuickPositionList', 'IsQuotientSemigroup', 'IsRandomSource', 'IsRange',
    'IsRat', 'IsRationalFunction', 'IsRationalFunctionDefaultRep', 'IsRationalFunctionsFamily', 'IsRationalMatrixGroup', 'IsRationals', 'IsRationalsPolynomialRing', 'IsRDistributive',
    'IsReadableFile', 'IsReadOnlyGlobal', 'IsRecord', 'IsRecordCollColl', 'IsRecordCollection', 'IsRectangularTable', 'IsReduced', 'IsReductionOrdering',
    'IsReesCongruence', 'IsReesCongruenceSemigroup', 'IsReesMatrixSemigroup', 'IsReesMatrixSemigroupElement', 'IsReesMatrixSubsemigroup', 'IsReesZeroMatrixSemigroup', 'IsReesZeroMatrixSemigroupElement', 'IsReesZeroMatrixSubsemigroup',
    'IsReflexiveBinaryRelation', 'IsRegular', 'IsRegular', 'IsRegularDClass', 'IsRegularSemigroup', 'IsRegularSemigroupElement', 'IsRelativelySM', 'IsRestrictedJacobianElement',
    'IsRestrictedJacobianElementCollColl', 'IsRestrictedJacobianElementCollection', 'IsRestrictedLieAlgebra', 'IsRestrictedLieObject', 'IsRestrictedLieObjectCollection', 'IsRewritingSystem', 'IsRightAlgebraModuleElement', 'IsRightAlgebraModuleElementCollection',
    'IsRightCoset', 'IsRightIdeal', 'IsRightIdealInParent', 'IsRightModule', 'IsRightOperatorAdditiveGroup', 'IsRightSemigroupIdeal', 'IsRing', 'IsRingElement',
    'IsRingElementWithInverse', 'IsRingElementWithOne', 'IsRingGeneralMapping', 'IsRingHomomorphism', 'IsRingWithOne', 'IsRingWithOneGeneralMapping', 'IsRingWithOneHomomorphism', 'IsRootSystem',
    'IsRootSystemFromLieAlgebra', 'IsRowModule', 'IsRowSpace', 'IsRowVector', 'IsScalar', 'IsSemiEchelonized', 'IsSemigroup', 'IsSemigroupCongruence',
    'IsSemigroupIdeal', 'IsSemilatticeAsSemigroup', 'IsSemiRegular', 'IsSet', 'IsShortLexLessThanOrEqual', 'IsShortLexOrdering', 'IsSimple', 'IsSimpleAlgebra',
    'IsSimpleGroup', 'IsSimpleSemigroup', 'IsSingleValued', 'IsSL', 'IsSolvable', 'IsSolvableGroup', 'IsSolvableTom', 'IsSortedList',
    'IsSpecialLinearGroup', 'IsSpecialPcgs', 'IsSPGeneralMapping', 'IsSporadicSimple', 'IsSSortedList', 'IsStandardIterator', 'IsStraightLineProgElm', 'IsStraightLineProgram',
    'IsStream', 'IsString', 'IsStringRep', 'IsStruct', 'IsSubgroup', 'IsSubgroupFpGroup', 'IsSubgroupOfWholeGroupByQuotientRep', 'IsSubgroupSL',
    'IsSubmonoidFpMonoid', 'IsSubnormal', 'IsSubnormallyMonomial', 'IsSubsemigroup', 'IsSubsemigroupFpSemigroup', 'IsSubset', 'IsSubsetBlist', 'IsSubsetLocallyFiniteGroup',
    'IsSubsetSet', 'IsSubspacesVectorSpace', 'IsSubstruct', 'IsSupersolvable', 'IsSupersolvableGroup', 'IsSurjective', 'IsSyllableAssocWordRep', 'IsSyllableWordsFamily',
    'IsSymmetricBinaryRelation', 'IsSymmetricGroup', 'IsSymmetricInverseMonoid', 'IsSymmetricInverseSemigroup', 'IsTable', 'IsTableOfMarks', 'IsTableOfMarksWithGens', 'IsToPcGroupGeneralMappingByImages',
    'IsToPcGroupHomomorphismByImages', 'IsToPermGroupGeneralMappingByImages', 'IsToPermGroupHomomorphismByImages', 'IsTotal', 'IsTotalOrdering', 'IsTransformation', 'IsTransformationCollection', 'IsTransformationMonoid',
    'IsTransformationSemigroup', 'IsTransitive', 'IsTransitiveBinaryRelation', 'IsTranslationInvariantOrdering', 'IsTrivial', 'IsTwoSidedIdeal', 'IsTwoSidedIdealInParent', 'IsUEALatticeElement',
    'IsUEALatticeElementCollection', 'IsUEALatticeElementFamily', 'IsUniqueFactorizationRing', 'IsUnit', 'IsUnivariatePolynomial', 'IsUnivariatePolynomialRing', 'IsUnivariateRationalFunction', 'IsUnknown',
    'IsUpperAlphaChar', 'IsUpperTriangularMat', 'IsValidIdentifier', 'IsVector', 'IsVectorSpace', 'IsVirtualCharacter', 'IsWeightLexOrdering', 'IsWeightRepElement',
    'IsWeightRepElementCollection', 'IsWeightRepElementFamily', 'IsWellFoundedOrdering', 'IsWeylGroup', 'IsWholeFamily', 'IsWLetterAssocWordRep', 'IsWLetterWordsFamily', 'IsWord',
    'IsWordCollection', 'IsWordWithInverse', 'IsWordWithOne', 'IsWreathProductOrdering', 'IsWritableFile', 'IsXInfinity', 'IsZero', 'IsZeroGroup',
    'IsZeroSimpleSemigroup', 'IsZeroSquaredElement', 'IsZeroSquaredElementCollColl', 'IsZeroSquaredElementCollection', 'IsZeroSquaredRing', 'IsZmodnZObj', 'IsZmodnZObjNonprime', 'IsZmodpZObj',
    'IsZmodpZObjLarge', 'IsZmodpZObjSmall', 'Iterated', 'Iterator', 'IteratorByBasis', 'IteratorByFunctions', 'IteratorList', 'IteratorOfCartesianProduct',
    'IteratorOfCombinations', 'IteratorOfPartitions', 'IteratorOfTuples', 'IteratorSorted', 'IteratorStabChain', 'Jacobi', 'JenningsLieAlgebra', 'JenningsSeries',
    'JoinEquivalenceRelations', 'JoinOfIdempotentPartialPermsNC', 'JoinOfPartialPerms', 'JoinStringsWithSeparator', 'JordanDecomposition', 'KappaPerp', 'KB_REW', 'KernelOfAdditiveGeneralMapping',
    'KernelOfCharacter', 'KernelOfMultiplicativeGeneralMapping', 'KernelOfTransformation', 'KeyDependentOperation', 'KillingMatrix', 'KnownAttributesOfObject', 'KnownPropertiesOfObject', 'KnownTruePropertiesOfObject',
    'KnowsDictionary', 'KnowsHowToDecompose', 'KnuthBendixRewritingSystem', 'Krasner-Kaloujnine', 'KroneckerProduct', 'KuKGenerators', 'Lambda', 'LargerQuotientBySubgroupAbelianization',
    'LargestElementGroup', 'LargestElementStabChain', 'LargestImageOfMovedPoint', 'LargestMovedPoint', 'LargestUnknown', 'LastSystemError', 'LaTeX', 'LaTeXStringDecompositionMatrix',
    'LatticeByCyclicExtension', 'LatticeGeneratorsInUEA', 'LatticeSubgroups', 'LatticeSubgroupsByTom', 'LaurentPolynomialByCoefficients', 'LaurentPolynomialByExtRep', 'LaurentPolynomialByExtRepNC', 'LClassOfHClass',
    'Lcm', 'LcmInt', 'LcmOp', 'LeadCoeffsIGS', 'LeadingCoefficient', 'LeadingCoefficientOfPolynomial', 'LeadingExponentOfPcElement', 'LeadingMonomial',
    'LeadingMonomialOfPolynomial', 'LeadingTermOfPolynomial', 'LeftActingAlgebra', 'LeftActingDomain', 'LeftActingRingOfIdeal', 'LeftAlgebraModule', 'LeftAlgebraModuleByGenerators', 'LeftDerivations',
    'LeftIdeal', 'LeftIdealByGenerators', 'LeftIdealNC', 'LeftModuleByGenerators', 'LeftModuleByHomomorphismToMatAlg', 'LeftModuleGeneralMappingByImages', 'LeftModuleHomomorphismByImages', 'LeftModuleHomomorphismByImagesNC',
    'LeftModuleHomomorphismByMatrix', 'LeftOne', 'LeftQuotient', 'LeftShiftRowVector', 'Legendre', 'Length', 'LengthsTom', 'LengthWPObj',
    'LenstraBase', 'LessThanFunction', 'LessThanOrEqualFunction', 'LetterRepAssocWord', 'LevelsOfGenerators', 'LeviMalcevDecomposition', 'LexicographicOrdering', 'LGFirst',
    'LGLayers', 'LGLength', 'LGWeights', 'LieAlgebra', 'LieAlgebraByStructureConstants', 'LieBracket', 'LieCenter', 'LieCentralizer',
    'LieCentre', 'LieCoboundaryOperator', 'LieDerivedSeries', 'LieDerivedSubalgebra', 'LieFamily', 'LieLowerCentralSeries', 'LieNilRadical', 'LieNormalizer',
    'LieObject', 'LieSolvableRadical', 'LieUpperCentralSeries', 'LiftedInducedPcgs', 'LiftedPcElement', 'LinearAction', 'LinearActionLayer', 'LinearCharacters',
    'LinearCombination', 'LinearCombinationPcgs', 'LinearIndependentColumns', 'LinearOperation', 'LinearOperationLayer', 'LinesOfStraightLineProgram', 'List', 'ListBlist',
    'ListN', 'ListOfDigits', 'ListPerm', 'ListStabChain', 'ListTransformation', 'ListWithIdenticalEntries', 'ListX', 'LLL',
    'LLLReducedBasis', 'LLLReducedGramMat', 'LoadDynamicModule', 'LoadPackage', 'Log', 'Log10', 'Log1p', 'Log2',
    'LogFFE', 'Logical', 'LogInt', 'LogMod', 'LogModShanks', 'LogPackageLoadingMessage', 'LogTo', 'LongestWeylWordPerm',
    'LookupDictionary', 'LowercaseString', 'LowerCentralSeriesOfGroup', 'LowIndexSubgroupsFpGroup', 'LowIndexSubgroupsFpGroupIterator', 'LQUO', 'Lucas', 'Magma',
    'MagmaByGenerators', 'MagmaByMultiplicationTable', 'MagmaElement', 'MagmaHomomorphismByFunctionNC', 'MagmaRingModuloSpanOfZero', 'MagmaWithInverses', 'MagmaWithInversesByGenerators', 'MagmaWithInversesByMultiplicationTable',
    'MagmaWithOne', 'MagmaWithOneByGenerators', 'MagmaWithOneByMultiplicationTable', 'MagmaWithZeroAdjoined', 'MakeConfluent', 'MakeFloat', 'MakeImmutable', 'MakeReadOnlyGlobal',
    'MakeReadWriteGlobal', 'MappedWord', 'MappingByFunction', 'MappingGeneratorsImages', 'MappingPermListList', 'MarksTom', 'MatAlgebra', 'MatClassMultCoeffsCharTable',
    'MathieuGroup', 'MatLieAlgebra', 'Matrix', 'MatrixAlgebra', 'MatrixAutomorphisms', 'MatrixByBlockMatrix', 'MatrixLieAlgebra', 'MatrixOfAction',
    'MatScalarProducts', 'MatTom', 'MaximalAbelianQuotient', 'MaximalBlocks', 'MaximalNormalSubgroups', 'MaximalSubgroupClassReps', 'MaximalSubgroups', 'MaximalSubgroupsLattice',
    'MaximalSubgroupsTom', 'Maximum', 'MaximumList', 'MeetEquivalenceRelations', 'MeetMaps', 'MeetOfPartialPerms', 'MemoryUsage', 'Mid',
    'MinimalElementCosetStabChain', 'MinimalGeneratingSet', 'MinimalNonmonomialGroup', 'MinimalNormalSubgroups', 'MinimalPolynomial', 'MinimalStabChain', 'MinimalSupergroupsLattice', 'MinimalSupergroupsTom',
    'MinimizedBombieriNorm', 'Minimum', 'MinimumList', 'MinusCharacter', 'ModuleByRestriction', 'ModuleOfExtension', 'ModuloPcgs', 'MoebiusMu',
    'MoebiusTom', 'MolienSeries', 'MolienSeriesInfo', 'MolienSeriesWithGivenDenominator', 'Monoid', 'MonoidByGenerators', 'MonoidByMultiplicationTable', 'MonoidOfRewritingSystem',
    'MonomialComparisonFunction', 'MonomialExtGrlexLess', 'MonomialExtrepComparisonFun', 'MonomialGrevlexOrdering', 'MonomialGrlexOrdering', 'MonomialLexOrdering', 'MonomialTotalDegreeLess', 'MorClassLoop',
    'MostFrequentGeneratorFpGroup', 'MovedPoints', 'MTX', 'MTX.BasesCompositionSeries', 'MTX.BasesMaximalSubmodules', 'MTX.BasesMinimalSubmodules', 'MTX.BasesMinimalSupermodules', 'MTX.BasesSubmodules',
    'MTX.BasisInOrbit', 'MTX.BasisModuleEndomorphisms', 'MTX.BasisModuleHomomorphisms', 'MTX.BasisRadical', 'MTX.BasisSocle', 'MTX.CollectedFactors', 'MTX.CompositionFactors', 'MTX.DegreeSplittingField',
    'MTX.Dimension', 'MTX.Distinguish', 'MTX.Field', 'MTX.Generators', 'MTX.HomogeneousComponents', 'MTX.Homomorphism', 'MTX.Homomorphisms', 'MTX.Indecomposition',
    'MTX.InducedAction', 'MTX.InducedActionFactorMatrix', 'MTX.InducedActionFactorModule', 'MTX.InducedActionMatrix', 'MTX.InducedActionMatrixNB', 'MTX.InducedActionSubmodule', 'MTX.InducedActionSubmoduleNB', 'MTX.InvariantBilinearForm',
    'MTX.InvariantQuadraticForm', 'MTX.InvariantSesquilinearForm', 'MTX.IsAbsolutelyIrreducible', 'MTX.IsEquivalent', 'MTX.IsIndecomposable', 'MTX.IsIrreducible', 'MTX.IsomorphismIrred', 'MTX.IsomorphismModules',
    'MTX.ModuleAutomorphisms', 'MTX.NormedBasisAndBaseChange', 'MTX.OrthogonalSign', 'MTX.ProperSubmoduleBasis', 'MTX.SubGModule', 'MTX.SubmoduleGModule', 'MultiplicationTable', 'MultiplicativeNeutralElement',
    'MultiplicativeZero', 'MultiplicativeZeroOp', 'Multiplier', 'MultRowVector', 'Murnaghan', 'MutableBasis', 'MutableBasisOfClosureUnderAction', 'MutableBasisOfIdealInNonassociativeAlgebra',
    'MutableBasisOfNonassociativeAlgebra', 'MutableIdentityMat', 'MutableNullMat', 'Name', 'NameFunction', 'NameRNam', 'NamesFilter', 'NamesGVars',
    'NamesLocalVariablesFunction', 'NamesOfComponents', 'NamesOfFusionSources', 'NamesSystemGVars', 'NamesUserGVars', 'NaturalCharacter', 'NaturalHomomorphismByGenerators', 'NaturalHomomorphismByIdeal',
    'NaturalHomomorphismByNormalSubgroup', 'NaturalHomomorphismByNormalSubgroupNC', 'NaturalHomomorphismBySubAlgebraModule', 'NaturalHomomorphismBySubspace', 'NaturalHomomorphismOfLieAlgebraFromNilpotentGroup', 'NaturalLeqPartialPerm', 'NaturalPartialOrder', 'NearAdditiveGroup',
    'NearAdditiveGroupByGenerators', 'NearAdditiveMagma', 'NearAdditiveMagmaByGenerators', 'NearAdditiveMagmaWithZero', 'NearAdditiveMagmaWithZeroByGenerators', 'NearlyCharacterTablesFamily', 'NegativeRoots', 'NegativeRootVectors',
    'NestingDepthA', 'NestingDepthM', 'NewAttribute', 'NewCategory', 'NewConstructor', 'NewDictionary', 'NewFamily', 'NewFilter',
    'NewFloat', 'NewInfoClass', 'NewmanInfinityCriterion', 'NewOperation', 'NewProperty', 'NewRepresentation', 'NewType', 'NextIterator',
    'NextPrimeInt', 'NF', 'NiceAlgebraMonomorphism', 'NiceBasis', 'NiceBasisFiltersInfo', 'NiceFreeLeftModule', 'NiceFreeLeftModuleInfo', 'NiceMonomorphism',
    'NiceMonomorphismAutomGroup', 'NiceObject', 'NiceVector', 'NilpotencyClassOfGroup', 'NilpotentQuotientOfFpLieAlgebra', 'NK', 'NOAUTO', 'NonabelianExteriorSquare',
    'NonnegativeIntegers', 'NonnegIntScalarProducts', 'NonNilpotentElement', 'Norm', 'NormalBase', 'NormalClosure', 'NormalFormIntMat', 'NormalIntersection',
    'NormalizedElementOfMagmaRingModuloRelations', 'NormalizedWhitespace', 'Normalizer', 'NormalizerInGLnZ', 'NormalizerInGLnZBravaisGroup', 'NormalizersTom', 'NormalizerTom', 'NormalizeWhitespace',
    'NormalSeriesByPcgs', 'NormalSubgroupClasses', 'NormalSubgroupClassesInfo', 'NormalSubgroups', 'NormedRowVector', 'NormedRowVectors', 'NormedVectors', 'NrArrangements',
    'NrBasisVectors', 'NrCombinations', 'NrComponentsOfPartialPerm', 'NrComponentsOfTransformation', 'NrConjugacyClasses', 'NrConjugacyClassesGL', 'NrConjugacyClassesGU', 'NrConjugacyClassesPGL',
    'NrConjugacyClassesPGU', 'NrConjugacyClassesPSL', 'NrConjugacyClassesPSU', 'NrConjugacyClassesSL', 'NrConjugacyClassesSLIsogeneous', 'NrConjugacyClassesSU', 'NrConjugacyClassesSUIsogeneous', 'NrDerangements',
    'NrFixedPoints', 'NrInputsOfStraightLineProgram', 'NrMovedPoints', 'NrOrderedPartitions', 'NrPartitions', 'NrPartitionsSet', 'NrPartitionTuples', 'NrPermutationsList',
    'NrPolyhedralSubgroups', 'NrPrimitiveGroups', 'NrRestrictedPartitions', 'NrSubsTom', 'NrTransitiveGroups', 'NrTuples', 'NrUnorderedTuples', 'NthRootsInGroup',
    'NullAlgebra', 'NullMat', 'NullspaceIntMat', 'NullspaceMat', 'NullspaceMatDestructive', 'NullspaceModQ', 'Number', 'NumberArgumentsFunction',
    'NumberFFVector', 'NumberIrreducibleSolvableGroups', 'NumberPerfectGroups', 'NumberPerfectLibraryGroups', 'NumberSmallGroups', 'NumberSmallRings', 'NumbersString', 'NumberSyllables',
    'NumberTransformation', 'NumeratorOfModuloPcgs', 'NumeratorOfRationalFunction', 'NumeratorRat', 'ObjByExtRep', 'Objectify', 'ObjectifyWithAttributes', 'OCOneCocycles',
    'OctaveAlgebra', 'OldGeneratorsOfPresentation', 'Omega', 'OmniGraffle', 'ONanScottType', 'OnBreak', 'OnBreakMessage', 'One',
    'OneAttr', 'OneCoboundaries', 'OneCocycles', 'OneFactorBound', 'OneImmutable', 'OneIrreducibleSolvableGroup', 'OneLibraryGroup', 'OneMutable',
    'OneOfPcgs', 'OneOp', 'OnePrimitiveGroup', 'OneSameMutability', 'OneSM', 'OneSmallGroup', 'OneTransitiveGroup', 'OnIndeterminates',
    'OnLeftInverse', 'OnLines', 'OnPairs', 'OnPoints', 'OnQuit', 'OnRight', 'OnSets', 'OnSetsDisjointSets',
    'OnSetsSets', 'OnSetsTuples', 'OnSubspacesByCanonicalBasis', 'OnSubspacesByCanonicalBasisConcatenations', 'OnTuples', 'OnTuplesSets', 'OnTuplesTuples', 'PCore',
    'Operation', 'OperationAlgebraHomomorphism', 'OperationHomomorphism', 'Operations', 'Orbit', 'OrbitFusions', 'OrbitishFO', 'OrbitLength',
    'OrbitLengths', 'OrbitLengthsDomain', 'OrbitPerms', 'OrbitPowerMaps', 'Orbits', 'OrbitsDomain', 'OrbitsishOperation', 'OrbitsPerms',
    'OrbitStabChain', 'OrbitStabilizer', 'OrbitStabilizerAlgorithm', 'Order', 'OrderedPartitions', 'OrderingByLessThanFunctionNC', 'OrderingByLessThanOrEqualFunctionNC', 'OrderingOfRewritingSystem',
    'OrderingOnGenerators', 'OrderingsFamily', 'OrderMod', 'OrderOfRewritingSystem', 'OrdersClassRepresentatives', 'OrdersTom', 'Ordinal', 'OrdinaryCharacterTable',
    'OrthogonalComponents', 'OrthogonalEmbeddings', 'OrthogonalEmbeddingsSpecialDimension', 'OutputLogTo', 'OutputTextFile', 'OutputTextNone', 'OutputTextString', 'OutputTextUser',
    'Overlaps', 'PACKAGE_DEBUG', 'PACKAGE_ERROR', 'PACKAGE_INFO', 'PACKAGE_WARNING', 'PackageVariablesInfo', 'PadicCoefficients', 'PadicExtensionNumberFamily',
    'PadicNumber', 'PadicValuation', 'Pager', 'PageSource', 'Parametrized', 'Parent', 'ParentPcgs', 'ParseRelators',
    'PartialFactorization', 'PartialOrderByOrderingFunction', 'PartialOrderOfHasseDiagram', 'PartialPerm', 'PartialPermFamily', 'PartialPermOp', 'PartialPermOpNC', 'Partitions',
    'PartitionsGreatestEQ', 'PartitionsGreatestLE', 'PartitionsSet', 'PartitionTuples', 'PcElementByExponents', 'PcElementByExponentsNC', 'PCentralLieAlgebra', 'PCentralNormalSeriesByPcgsPGroup',
    'PCentralSeries', 'PcGroupCode', 'PcGroupFpGroup', 'PcGroupWithPcgs', 'Pcgs', 'Pcgs_OrbitStabilizer', 'PcgsByPcSequence', 'PcgsByPcSequenceNC',
    'PcgsCentralSeries', 'PcgsChiefSeries', 'PcgsElementaryAbelianSeries', 'PcgsPCentralSeriesPGroup', 'PClassPGroup', 'PCore', 'PcSeries', 'PerfectGroup',
    'PerfectIdentification', 'PerfectResiduum', 'Perform', 'Permanent', 'PermBounds', 'PermCharInfo', 'PermCharInfoRelative', 'PermChars',
    'PermCharsTom', 'PermComb', 'PermLeftQuoPartialPerm', 'PermLeftQuoPartialPermNC', 'PermLeftQuoTransformation', 'PermLeftQuoTransformationNC', 'PermList', 'PermListList',
    'Permutation', 'PermutationCharacter', 'PermutationCycle', 'PermutationGModule', 'PermutationMat', 'PermutationOfImage', 'PermutationsFamily', 'PermutationsList',
    'PermutationTom', 'Permuted', 'PGL', 'PGU', 'Phi', 'PolynomialByExtRep', 'PolynomialByExtRepNC', 'PolynomialCoefficientsOfPolynomial',
    'PolynomialDivisionAlgorithm', 'PolynomialModP', 'PolynomialReducedRemainder', 'PolynomialReduction', 'PolynomialRing', 'POmega', 'PopOptions', 'Position',
    'PositionBound', 'PositionCanonical', 'PositionFirstComponent', 'PositionNonZero', 'PositionNot', 'PositionNthOccurrence', 'PositionProperty', 'Positions',
    'PositionSet', 'PositionsOp', 'PositionSorted', 'PositionSortedOp', 'PositionsProperty', 'PositionStream', 'PositionSublist', 'PositionWord',
    'PositiveIntegers', 'PositiveRoots', 'PositiveRootVectors', 'PossibleClassFusions', 'PossibleFusionsCharTableTom', 'PossiblePowerMaps', 'PowerMap', 'PowerMapByComposition',
    'PowerMapOp', 'PowerMapsAllowedBySymmetrizations', 'PowerMod', 'PowerModCoeffs', 'PowerModInt', 'PowerPartition', 'PowerSubalgebraSeries', 'PQuotient',
    'PrecisionFloat', 'Prefix', 'PrefrattiniSubgroup', 'PreImage', 'PreImageElm', 'PreImagePartialPerm', 'PreImages', 'PreImagesElm',
    'PreImagesOfTransformation', 'PreImagesRange', 'PreImagesRepresentative', 'PreImagesSet', 'PresentationFpGroup', 'PresentationNormalClosure', 'PresentationNormalClosureRrs', 'PresentationSubgroup',
    'PresentationSubgroupMtc', 'PresentationSubgroupRrs', 'PresentationViaCosetTable', 'PrevPrimeInt', 'PrimalityProof', 'PrimaryGeneratorWords', 'PrimeBlocks', 'PrimeBlocksOp',
    'PrimeDivisors', 'PrimeField', 'PrimePGroup', 'PrimePowersInt', 'PrimeResidues', 'Primes', 'PRIMITIVE_INDICES_MAGMA', 'PrimitiveElement',
    'PrimitiveGroup', 'PrimitiveGroupsIterator', 'PrimitiveIdentification', 'PrimitiveIndexIrreducibleSolvableGroup', 'PrimitivePolynomial', 'PrimitiveRoot', 'PrimitiveRootMod', 'Print',
    'PrintAmbiguity', 'PrintArray', 'PrintCharacterTable', 'PrintCSV', 'PrintFactorsInt', 'PrintFormattingStatus', 'PrintObj', 'PrintString',
    'PrintTo', 'ProbabilityShapes', 'Process', 'PROD_GF2MAT_GF2MAT_ADVANCED', 'PROD_GF2MAT_GF2MAT_SIMPLE', 'Product', 'ProductCoeffs', 'ProductOfStraightLinePrograms',
    'ProductSpace', 'ProductX', 'ProfileFunctions', 'ProfileGlobalFunctions', 'ProfileLineByLine', 'ProfileMethods', 'ProfileOperations', 'ProfileOperationsAndMethods',
    'ProjectedInducedPcgs', 'ProjectedPcElement', 'Projection', 'ProjectionMap', 'ProjectiveActionHomomorphismMatrixGroup', 'ProjectiveActionOnFullSpace', 'ProjectiveGeneralLinearGroup', 'ProjectiveGeneralUnitaryGroup',
    'ProjectiveOmega', 'ProjectiveOrder', 'ProjectiveSpecialLinearGroup', 'ProjectiveSpecialUnitaryGroup', 'ProjectiveSymplecticGroup', 'PRump', 'PseudoRandom', 'PSL',
    'PSP', 'PSp', 'PSU', 'PthPowerImage', 'PthPowerImages', 'PurePadicNumberFamily', 'PushOptions', 'Quadratic',
    'QuaternionAlgebra', 'QuaternionGroup', 'QUIET', 'QUIT_GAP', 'QUITTING', 'QuoInt', 'Quotient',
    'QuotientFromSCTable', 'QuotientMod', 'QuotientPolynomialsExtRep', 'QuotientRemainder', 'QuotientSemigroupCongruence', 'QuotientSemigroupHomomorphism', 'QuotientSemigroupPreimage', 'QuotRemLaurpols',
    'RadicalGroup', 'RadicalOfAlgebra', 'Random', 'RandomBinaryRelationOnPoints', 'RandomInvertibleMat', 'RandomIsomorphismTest', 'RandomList', 'RandomMat',
    'RandomPartialPerm', 'RandomPrimitivePolynomial', 'RandomSource', 'RandomTransformation', 'RandomUnimodularMat', 'Range', 'RankAction', 'RankFilter',
    'RankMat', 'RankOfPartialPerm', 'RankOfPartialPermCollection', 'RankOfPartialPermSemigroup', 'RankOfTransformation', 'RankPGroup', 'Rat', 'RationalClass',
    'RationalClasses', 'RationalFunctionByExtRep', 'RationalFunctionByExtRepNC', 'RationalFunctionByExtRepWithCancellation', 'RationalFunctionsFamily', 'RationalizedMat', 'Rationals', 'RClassOfHClass',
    'Read', 'ReadAll', 'ReadAllLine', 'ReadAsFunction', 'ReadByte', 'ReadCommandLineHistory', 'ReadCSV', 'ReadLine',
    'ReadlineInitLine', 'ReadPackage', 'ReadPkg', 'RealClasses', 'RealizableBrauerCharacters', 'RealPart', 'RecNames', 'RedispatchOnCondition',
    'ReduceCoeffs', 'ReduceCoeffsMod', 'ReducedAdditiveInverse', 'ReducedCharacters', 'ReducedClassFunctions', 'ReducedComm', 'ReducedConfluentRewritingSystem', 'ReducedConjugate',
    'ReducedDifference', 'ReducedForm', 'ReducedGroebnerBasis', 'ReducedInverse', 'ReducedLeftQuotient', 'ReducedOne', 'ReducedPcElement', 'ReducedPower',
    'ReducedProduct', 'ReducedQuotient', 'ReducedScalarProduct', 'ReducedSum', 'ReducedZero', 'ReduceRules', 'ReduceStabChain', 'Ree',
    'ReeGroup', 'ReesCongruenceOfSemigroupIdeal', 'ReesMatrixSemigroup', 'ReesMatrixSemigroupElement', 'ReesMatrixSubsemigroup', 'ReesZeroMatrixSemigroup', 'ReesZeroMatrixSemigroupElement', 'ReesZeroMatrixSubsemigroup',
    'RefinedPcGroup', 'ReflectionMat', 'ReflexiveClosureBinaryRelation', 'RegularActionHomomorphism', 'RegularModule', 'RelationsOfFpSemigroup', 'RelativeBasis', 'RelativeBasisNC',
    'RelativeDiameter', 'RelativeOrderOfPcElement', 'RelativeOrders', 'RelativeOrders', 'RelatorsOfFpGroup', 'RemInt', 'Remove', 'RemoveCharacters',
    'RemoveFile', 'RemoveOuterCoeffs', 'RemoveRelator', 'RemoveSet', 'RemoveStabChain', 'ReplacedString', 'RepresentationsOfObject', 'Representative',
    'RepresentativeAction', 'RepresentativeLinearOperation', 'RepresentativeOperation', 'RepresentativesContainedRightCosets', 'RepresentativesFusions', 'RepresentativeSmallest', 'RepresentativesMinimalBlocks', 'RepresentativesPerfectSubgroups',
    'RepresentativesPowerMaps', 'RepresentativesSimpleSubgroups', 'RepresentativeTom', 'RepresentativeTomByGenerators', 'RepresentativeTomByGeneratorsNC', 'RequirePackage', 'Reread', 'REREADING',
    'RereadPackage', 'RereadPkg', 'Reset', 'ResetFilterObj', 'ResetOptionsStack', 'RespectsAddition', 'RespectsAdditiveInverses', 'RespectsInverses',
    'RespectsMultiplication', 'RespectsOne', 'RespectsScalarMultiplication', 'RespectsZero', 'RestrictedClassFunction', 'RestrictedClassFunctions', 'RestrictedLieAlgebraByStructureConstants', 'RestrictedMapping',
    'RestrictedPartialPerm', 'RestrictedPartitions', 'RestrictedPerm', 'RestrictedPermNC', 'RestrictedTransformation', 'RestrictedTransformationNC', 'RestrictOutputsOfSLP', 'Resultant',
    'ResultOfStraightLineProgram', 'ReturnFail', 'ReturnFalse', 'ReturnFirst', 'ReturnNothing', 'ReturnTrue', 'Reversed', 'ReverseNaturalPartialOrder',
    'RewindStream', 'RewriteWord', 'RightActingAlgebra', 'RightActingRingOfIdeal', 'RightAlgebraModule', 'RightAlgebraModuleByGenerators', 'RightCoset', 'RightCosets',
    'RightCosetsNC', 'RightDerivations', 'RightIdeal', 'RightIdealByGenerators', 'RightIdealNC', 'RightModuleByHomomorphismToMatAlg', 'RightOne', 'RightShiftRowVector',
    'RightTransversal', 'Ring', 'Ring', 'RingByGenerators', 'RingByStructureConstants', 'RingGeneralMappingByImages', 'RingHomomorphismByImages', 'RingHomomorphismByImagesNC',
    'RingWithOne', 'RingWithOneByGenerators', 'RNamObj', 'RootInt', 'RootMod', 'RootOfDefiningPolynomial', 'RootsMod', 'RootsOfPolynomial',
    'RootsOfUPol', 'RootsUnityMod', 'RootSystem', 'Round', 'RoundCyc', 'Rows', 'RREF', 'Rules',
    'Runtime', 'Runtimes', 'SameBlock', 'SaveCommandLineHistory', 'SaveOnExitFile', 'SaveWorkspace', 'ScalarProduct', 'Schreier',
    'Schreier-Sims', 'Schur', 'SchurCover', 'SchurCoverOfSymmetricGroup', 'Sec', 'Sech', 'SecHMSM', 'SecondsDMYhms',
    'SeekPositionStream', 'SemidirectProduct', 'SemiEchelonBasis', 'SemiEchelonBasisNC', 'SemiEchelonMat', 'SemiEchelonMatDestructive', 'SemiEchelonMats', 'SemiEchelonMatsDestructive',
    'SemiEchelonMatTransformation', 'Semigroup', 'SemigroupByGenerators', 'SemigroupByMultiplicationTable', 'SemigroupIdealByGenerators', 'SemigroupOfRewritingSystem', 'SemiSimpleType', 'Set',
    'SetAssertionLevel', 'SetCommutator', 'SetConjugate', 'SetCrystGroupDefaultAction', 'SetCyclotomicsLimit', 'SetDefaultInfoOutput', 'SetElmWPObj', 'SetEntrySCTable',
    'SetFilterObj', 'SetFloats', 'SetGasmanMessageStatus', 'SetHelpViewer', 'SetIndeterminateName', 'SetInfoHandler', 'SetInfoLevel', 'SetInfoOutput',
    'SetName', 'SetNameObject', 'SetPackagePath', 'SetParent', 'SetPower', 'SetPrintFormattingStatus', 'SetRecursionTrapInterval', 'SetReducedMultiplication',
    'Sets', 'Setter', 'SetUserPreference', 'SetX', 'ShallowCopy', 'ShiftedCoeffs', 'ShiftedPadicNumber', 'ShortestVectors',
    'ShortLexLeqPartialPerm', 'ShortLexOrdering', 'ShowAdditionTable', 'ShowArgument', 'ShowArguments', 'ShowDetails', 'ShowGcd', 'ShowImpliedFilters',
    'ShowMethods', 'ShowMultiplicationTable', 'ShowOtherMethods', 'ShowPackageVariables', 'ShowUserPreferences', 'ShrinkAllocationPlist', 'ShrinkAllocationString', 'ShrinkRowVector',
    'Shuffle', 'SiftedPcElement', 'SiftedPermutation', 'SiftedVector', 'Sigma', 'SigmaL', 'SignFloat', 'SignInt',
    'SignPartition', 'SignPerm', 'SimpleGroup', 'SimpleGroupsIterator', 'SimpleLieAlgebra', 'SimpleSystem', 'SimplifiedFpGroup', 'SimplifyPresentation',
    'SimsNo', 'SimultaneousEigenvalues', 'Sin', 'SinCos', 'SingleCollector', 'Sinh', 'SIntChar', 'Size',
    'SizeBlist', 'SizeConsiderFunction', 'SizeNumbersPerfectGroups', 'SizeOfFieldOfDefinition', 'SizesCentralisers', 'SizesCentralizers', 'SizesConjugacyClasses', 'SizeScreen',
    'SizesPerfectGroups', 'SizeStabChain', 'SL', 'SlotUsagePattern', 'SmallerDegreePermutationRepresentation', 'SmallestGeneratorPerm', 'SmallestIdempotentPower', 'SmallestImageOfMovedPoint',
    'SmallestMovedPoint', 'SmallestRootInt', 'SmallGeneratingSet', 'SmallGroup', 'SmallGroupsInformation', 'SmallRing', 'SmallSimpleGroup', 'Smith',
    'SmithNormalFormIntegerMat', 'SmithNormalFormIntegerMatTransforms', 'SMTX.AbsoluteIrreducibilityTest', 'SMTX.AlgEl', 'SMTX.AlgElCharPol', 'SMTX.AlgElCharPolFac', 'SMTX.AlgElMat', 'SMTX.AlgElNullspaceDimension',
    'SMTX.AlgElNullspaceVec', 'SMTX.CentMat', 'SMTX.CentMatMinPoly', 'SMTX.CompleteBasis', 'SMTX.Getter', 'SMTX.GoodElementGModule', 'SMTX.IrreducibilityTest', 'SMTX.MatrixSum',
    'SMTX.MinimalSubGModule', 'SMTX.MinimalSubGModules', 'SMTX.RandomIrreducibleSubGModule', 'SMTX.Setter', 'SMTX.SortHomGModule', 'SMTX.Subbasis', 'SO', 'Socle',
    'SocleTypePrimitiveGroup', 'SolutionIntMat', 'SolutionMat', 'SolutionMatDestructive', 'SolutionNullspaceIntMat', 'SolvableQuotient', 'Sort', 'SortBy',
    'Sorted', 'SortedCharacters', 'SortedCharacterTable', 'SortedList', 'SortedSparseActionHomomorphism', 'SortedTom', 'Sortex', 'SortingPerm',
    'SortParallel', 'Source', 'SourceOfIsoclinicTable', 'SP', 'Sp', 'SparseActionHomomorphism', 'SparseCartanMatrix', 'SparseHashTable',
    'SparseIntKey', 'SpecialLinearGroup', 'SpecialOrthogonalGroup', 'SpecialPcgs', 'SpecialSemilinearGroup', 'SpecialUnitaryGroup', 'SplitCharacters', 'SplitExtension',
    'SplitString', 'SplittingField', 'Spreadsheet', 'SQ', 'Sqrt', 'Square', 'SquareRoots', 'SSortedList',
    'StabChain', 'StabChainBaseStrongGenerators', 'StabChainImmutable', 'StabChainMutable', 'StabChainOp', 'StabChainOptions', 'Stabilizer', 'StabilizerOfExternalSet',
    'StabilizerPcgs', 'Stack', 'StandardAssociate', 'StandardAssociateUnit', 'StandardizeTable', 'StandardWreathProduct', 'StarCyc', 'START_TEST',
    'StartlineFunc', 'StartsWith', 'State', 'Stirling', 'Stirling1', 'Stirling2', 'STOP_TEST', 'StoredGroebnerBasis',
    'StoreFusion', 'StraightLineProgElm', 'StraightLineProgGens', 'StraightLineProgram', 'StraightLineProgramNC', 'StraightLineProgramNC', 'StraightLineProgramsTom', 'StreamsFamily',
    'StretchImportantSLPElement', 'String', 'StringDate', 'StringFactorizationWord', 'StringNumbers', 'StringOfResultOfStraightLineProgram', 'StringPP', 'StringTime',
    'StripLineBreakCharacters', 'StrongGeneratorsStabChain', 'StronglyConnectedComponents', 'Struct', 'StructByGenerators', 'StructuralCopy', 'StructureConstantsTable', 'StructureDescription',
    'StructWithGenerators', 'SU', 'SubadditiveGroup', 'SubadditiveGroupNC', 'SubadditiveMagma', 'SubadditiveMagmaNC', 'SubadditiveMagmaWithZero', 'SubadditiveMagmaWithZeroNC',
    'Subalgebra', 'SubAlgebraModule', 'SubalgebraNC', 'SubalgebraWithOne', 'SubalgebraWithOneNC', 'SubdirectProduct', 'SubdirectProducts', 'Subdomains',
    'Subfield', 'SubfieldNC', 'Subfields', 'Subgroup', 'SubgroupByPcgs', 'SubgroupByProperty', 'SubgroupNC', 'SubgroupOfWholeGroupByCosetTable',
    'SubgroupOfWholeGroupByQuotientSubgroup', 'SubgroupProperty', 'SubgroupShell', 'SubgroupsSolvableGroup', 'Submagma', 'SubmagmaNC', 'SubmagmaWithInverses', 'SubmagmaWithInversesNC',
    'SubmagmaWithOne', 'SubmagmaWithOneNC', 'Submodule', 'SubmoduleNC', 'Submonoid', 'SubmonoidNC', 'SubnearAdditiveGroup', 'SubnearAdditiveGroupNC',
    'SubnearAdditiveMagma', 'SubnearAdditiveMagmaNC', 'SubnearAdditiveMagmaWithZero', 'SubnearAdditiveMagmaWithZeroNC', 'SubnormalSeries', 'Subring', 'SubringNC', 'Subrings',
    'SubringWithOne', 'SubringWithOneNC', 'Subsemigroup', 'SubsemigroupNC', 'Subspace', 'SubspaceNC', 'Subspaces', 'SubstitutedWord',
    'SubsTom', 'Substruct', 'SubstructNC', 'SubSyllables', 'SubtractBlist', 'SubtractSet', 'Subword', 'Successors',
    'Suffix', 'Sum', 'SumFactorizationFunctionPcgs', 'SumIntersectionMat', 'SumX', 'Sup', 'SupersolvableResiduum', 'SupportedCharacterTableInfo',
    'SurjectiveActionHomomorphismAttr', 'SuzukiGroup', 'SylowComplement', 'SylowSubgroup', 'SylowSystem', 'SymmetricClosureBinaryRelation', 'SymmetricGroup', 'SymmetricInverseMonoid',
    'SymmetricInverseSemigroup', 'SymmetricParentGroup', 'SymmetricParts', 'SymmetricPowerOfAlgebraModule', 'Symmetrizations', 'SymplecticComponents', 'SymplecticGroup', 'Sz',
    'TableAutomorphisms', 'TableOfMarks', 'TableOfMarksByLattice', 'TableOfMarksComponents', 'TableOfMarksCyclic', 'TableOfMarksDihedral', 'TableOfMarksFamily', 'TableOfMarksFrobenius',
    'Tan', 'Tanh', 'Tau', 'TCENUM', 'TeachingMode', 'TemporaryGlobalVarName', 'Tensored', 'TensorProductGModule',
    'TensorProductOfAlgebraModules', 'Test', 'TestConsistencyMaps', 'TestDirectory', 'Tester', 'TestHomogeneous', 'TestInducedFromNormalSubgroup', 'TestJacobi',
    'TestMonomial', 'TestMonomialQuick', 'TestMonomialUseLattice', 'TestPackage', 'TestPackageAvailability', 'TestPerm1', 'TestPerm2', 'TestPerm3',
    'TestPerm4', 'TestPerm5', 'TestQuasiPrimitive', 'TestRelativelySM', 'TestSubnormallyMonomial', 'ThreeGroup', 'TietzeWordAbstractWord', 'Timeouts',
    'Trace', 'TraceAllMethods', 'TracedCosetFpGroup', 'TraceImmediateMethods', 'TraceMat', 'TraceMethods', 'TracePolynomial', 'TransferDiagram',
    'Transformation', 'TransformationByImageAndKernel', 'TransformationFamily', 'TransformationList', 'TransformationListList', 'TransformationNumber', 'TransformationOp', 'TransformationOpNC',
    'TransformingPermutations', 'TransformingPermutationsCharacterTables', 'TransitiveClosureBinaryRelation', 'TransitiveGroup', 'TransitiveIdentification', 'Transitivity', 'TranslatorSubalgebra', 'TransposedMat',
    'TransposedMatAttr', 'TransposedMatDestructive', 'TransposedMatImmutable', 'TransposedMatMutable', 'TransposedMatOp', 'TransposedMatrixGroup', 'TriangulizedIntegerMat', 'TriangulizedIntegerMatTransform',
    'TriangulizedMat', 'TriangulizedNullspaceMat', 'TriangulizedNullspaceMatDestructive', 'TriangulizeIntegerMat', 'TriangulizeMat', 'TrimPartialPerm', 'TrimTransformation', 'TrivialCharacter',
    'TrivialGroup', 'TrivialIterator', 'TrivialSubalgebra', 'TrivialSubgroup', 'TrivialSubmagmaWithOne', 'TrivialSubmodule', 'TrivialSubmonoid', 'TrivialSubnearAdditiveMagmaWithZero',
    'TrivialSubspace', 'Trunc', 'TryCosetTableInWholeGroup', 'TryGcdCancelExtRepPolynomials', 'Tuples', 'TwoClosure', 'TwoCoboundaries',
    'TwoCocycles', 'TwoCohomology', 'TwoGroup', 'TwoSidedIdeal', 'TwoSidedIdealByGenerators', 'TwoSidedIdealNC', 'TwoSquares', 'TypeObj',
    'TypeOfDefaultGeneralMapping', 'TzEliminate', 'TzFindCyclicJoins', 'TzGo', 'TzGoGo', 'TzImagesOldGens', 'TzInitGeneratorImages', 'TzNewGenerator',
    'TzOptions', 'TzPreImagesNewGens', 'TzPrint', 'TzPrintGeneratorImages', 'TzPrintGenerators', 'TzPrintLengths', 'TzPrintOptions', 'TzPrintPairs',
    'TzPrintPresentation', 'TzPrintRelators', 'TzPrintStatus', 'TzSearch', 'TzSearchEqual', 'TzSort', 'TzSubstitute', 'TzSubstitute',
    'TzSubstituteCyclicJoins', 'UglyVector', 'UnbindElmWPObj', 'UnbindGlobal', 'UncoverageLineByLine', 'UnderlyingCharacteristic', 'UnderlyingCharacterTable',
    'UnderlyingElement', 'UnderlyingExternalSet', 'UnderlyingFamily', 'UnderlyingGeneralMapping', 'UnderlyingGroup', 'UnderlyingInjectionZeroMagma', 'UnderlyingLeftModule', 'UnderlyingLieAlgebra',
    'UnderlyingMagma', 'UnderlyingRelation', 'UnderlyingRingElement', 'UnderlyingSemigroup', 'UnInstallCharReadHookFunc', 'Union', 'Union2', 'UnionBlist',
    'Unique', 'UniteBlist', 'UniteBlistList', 'UniteSet', 'Units', 'UnivariatenessTestRationalFunction', 'UnivariatePolynomial', 'UnivariatePolynomialByCoefficients',
    'UnivariatePolynomialRing', 'UnivariateRationalFunctionByCoefficients', 'UniversalEnvelopingAlgebra', 'UNIX', 'UNIXSelect', 'Unknown', 'UnloadSmallGroupsData', 'UnorderedTuples',
    'UnprofileFunctions', 'UnprofileLineByLine', 'UnprofileMethods', 'UntraceAllMethods', 'UntraceImmediateMethods', 'UntraceMethods', 'UntraceMethods', 'UpdateMap',
    'UpEnv', 'UpperCentralSeriesOfGroup', 'UpperSubdiagonal', 'UseBasis', 'UseFactorRelation', 'UseIsomorphismRelation', 'UserPreference', 'UseSubsetRelation',
    'ValidatePackageInfo', 'Valuation', 'Value', 'ValueCochain', 'ValueGlobal', 'ValueMolienSeries', 'ValueOption', 'ValuePol',
    'ValuesOfClassFunction', 'VectorSpace', 'VectorSpaceByPcgsOfElementaryAbelianGroup', 'View', 'ViewObj', 'ViewString', 'VirtualCharacter', 'WeakPointerObj',
    'WedgeGModule', 'WeekDay', 'WeightLexOrdering', 'WeightOfGenerators', 'WeightsTom', 'WeightVecFFE', 'WeylGroup', 'WeylOrbitIterator',
    'Where', 'WordAlp', 'Wreath', 'WreathProduct', 'WreathProductImprimitiveAction', 'WreathProductOrdering', 'WreathProductProductAction', 'WriteAll',
    'WriteByte', 'WriteGapIniFile', 'WriteLine', 'X', 'Z', 'ZClassRepsQClass', 'Zero', 'ZeroAttr',
    'ZeroCoefficient', 'ZeroCoefficientRatFun', 'ZeroImmutable', 'ZeroMapping', 'ZeroMutable', 'ZeroOp', 'ZeroSameMutability', 'ZeroSM',
    'Zeta', 'ZippedProduct', 'ZippedSum', 'ZmodnZ', 'ZmodnZObj', 'ZmodpZ', 'ZmodpZNC', 'ZumbroichBase', 'Zuppos',
    // all francy functions here
    'Canvas', 'Draw', 'DrawSplash', 'Callback', 'NoopCallback', 'RequiredArg', 'Trigger', 'JUPYTER_ViewString', 'Sanitize', 'MergeObjects', 'GenerateID',
    'FrancyMessage', 'Chart', 'Dataset', 'DefaultAxis', 'XAxis', 'YAxis', 'Graph', 'UnsetNodes', 'Shape', 'Link', 'Links', 'Menu'
  ]);
  var keywords = createKeywordRegularExpression(['Assert', 'Info', 'IsBound', 'QUIT', 'TryNextMethod', 'Unbind', 'and',
    'atomic', 'break', 'continue', 'do', 'elif', 'else', 'end', 'false', 'fi', 'for', 'function', 'if', 'in', 'local',
    'mod', 'not', 'od', 'or', 'quit', 'readonly', 'readwrite', 'rec', 'repeat', 'return', 'then', 'true', 'until', 'while']);
  var all = /(?:.)/;
  var comment = /(?:#.*$)/;
  var blockLiterals = /(?:""")/;
  var literals = /(?:")|(?:')/;
  var numbers = /(?:\d*\.?\d+(?![\w@\\]))/;
  var variables = /(?:\\[(),.]?|[\w@]+)/;
  var properties = /(?:\+|-|\*|\/|\^|~|!\.|=|<>|<|<=|>|>=|!\[|:=|\.|\.\.|->|,|;|!{|\[|]|{|}|\(|\)|:)/;
  var indentTokens = /(?:\bfunction\b|\bif\b|\brepeat\b|\bwhile\b|\batomic\b|\bfor\b)/; // indent next line
  var dedentTokens = /(?:\bod\b|\bend\b|\bfi\b|\buntil\b)/; // dedent current line
  var partiallyDedentTokens = /(?:\belse?\b|\belif\b)/; // dedent current line, but keep indent next line

  CodeMirror.defineSimpleMode('gap', {
    start: [
      {regex: indentTokens, token: 'keyword', indent: true},
      {regex: dedentTokens, token: 'keyword', dedent: true},
      {regex: partiallyDedentTokens, token: 'keyword', dedent: true, indent: true},
      {regex: comment, token: 'comment'},
      {regex: blockLiterals, token: 'string', next: 'string2'},
      {regex: literals, token: 'string', next: 'string'},
      {regex: builtin, token: 'builtin'},
      {regex: properties, token: 'property'},
      {regex: numbers, token: 'number'},
      {regex: keywords, token: 'keyword'},
      {regex: variables, token: 'variable'},
      {regex: all, token: null}
    ],
    string: [
      {regex: /(?:[^]|\\.)*?"|(?:[^]|\\.)*?'/, token: 'string', next: 'start'},
      {regex: /.*/, token: 'string'}
    ],
    string2: [
      {regex: /"""(?:[^]|\\.)*?/, token: 'string', next: 'start'},
      {regex: /.*/, token: 'string'}
    ],
    meta: {lineComment: '#', electricInput: all, dontIndentStates: ['comment']}
  });

  CodeMirror.defineMIME('text/x-gap', 'gap');

});
