/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.utils.CommonUtils;

public class SQLCommandHandlerDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sqlCommand";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final boolean interactive;
    private final Expression enablementExpression;

    public SQLCommandHandlerDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.interactive = CommonUtils.getBoolean((String)config.getAttribute("interactive"), (boolean)false);
        this.enablementExpression = SQLCommandHandlerDescriptor.getEnablementExpression((IConfigurationElement)config);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isEnabled() {
        return SQLCommandHandlerDescriptor.isExpressionTrue((Expression)this.enablementExpression, (Object)((Object)this));
    }

    @NotNull
    public SQLControlCommandHandler createHandler() throws DBException {
        return (SQLControlCommandHandler)this.implClass.createInstance(SQLControlCommandHandler.class);
    }
}

