"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const tz = __importStar(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const e = exposes.presets;
exports.definitions = [
    {
        zigbeeModel: ["FLS-PP3", "FLS-PP3\u0000", "FLS-PP3 White\u0000"],
        model: "FLS-PP",
        vendor: "Dresden Elektronik",
        description: "Zigbee Light Link wireless electronic ballast",
        ota: true,
        extend: [
            m.deviceEndpoints({ endpoints: { rgb: 10, white: 11 } }),
            m.light({ colorTemp: { range: [153, 500] }, color: true, endpointNames: ["rgb", "white"] }),
        ],
    },
    {
        zigbeeModel: ["FLS-M"],
        model: "FLS-M",
        vendor: "Dresden Elektronik",
        description: "Universal LED controller (dynamic endpoints)",
        ota: true,
        meta: {
            supportsEnhancedHue: () => false,
        },
        endpoint: (device) => {
            const result = {};
            for (const ep of device.endpoints) {
                if (ep.inputClusters.includes(0x0006) || ep.inputClusters.includes(0x0008) || ep.inputClusters.includes(0x0300)) {
                    result[`light_${ep.ID}`] = ep.ID;
                }
            }
            return result;
        },
        exposes: (device) => {
            const result = [];
            if (!("endpoints" in device))
                return result;
            for (const ep of device.endpoints) {
                const name = `light_${ep.ID}`;
                if (ep.inputClusters.includes(0x0300)) {
                    result.push(e.light_colorhs().withBrightness().withColorTemp([140, 625]).withEndpoint(name));
                }
                else if (ep.inputClusters.includes(0x0008)) {
                    result.push(e.light_brightness().withEndpoint(name));
                }
            }
            return result;
        },
        configure: async (device, coordinatorEndpoint, logger) => {
            for (const ep of device.endpoints) {
                if (ep.inputClusters.includes(0x0300)) {
                    await ep.bind("lightingColorCtrl", coordinatorEndpoint);
                }
                else if (ep.inputClusters.includes(0x0008)) {
                    await ep.bind("genLevelCtrl", coordinatorEndpoint);
                }
                else if (ep.inputClusters.includes(0x0006)) {
                    await ep.bind("genOnOff", coordinatorEndpoint);
                }
            }
        },
        fromZigbee: [fz.on_off, fz.brightness, fz.color_colortemp],
        toZigbee: [tz.on_off, tz.light_onoff_brightness, tz.light_color, tz.light_colortemp],
    },
    {
        zigbeeModel: ["FLS-CT"],
        model: "FLS-CT",
        vendor: "Dresden Elektronik",
        description: "Zigbee Light Link wireless electronic ballast color temperature",
        ota: true,
        extend: [m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["Kobold"],
        model: "Kobold",
        vendor: "Dresden Elektronik",
        description: "Zigbee 3.0 dimm actuator",
        ota: true,
        extend: [m.light()],
    },
    {
        zigbeeModel: ["Hive"],
        model: "Hive",
        vendor: "Phoscon",
        description: "Battery powered smart LED light",
        ota: true,
        extend: [m.light({ colorTemp: { range: [153, 370] }, color: true }), m.battery()],
    },
    {
        zigbeeModel: ["FLS-A lp (1-10V)"],
        model: "FLS-A",
        vendor: "Dresden Elektronik",
        description: "Zigbee controller for 1-10V/PWM",
        meta: { disableDefaultResponse: true },
        ota: true,
        extend: [m.deviceEndpoints({ endpoints: { l1: 11, l2: 12, l3: 13, l4: 14 } }), m.light({ endpointNames: ["l1", "l2", "l3", "l4"] })],
    },
    {
        zigbeeModel: ["FLS-H3"],
        model: "FLS-H",
        vendor: "Dresden Elektronik",
        description: "Zigbee Light Link wireless electronic ballast",
        ota: true,
        extend: [m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["Scene Switch"],
        model: "BN-600085",
        vendor: "Dresden Elektronik",
        description: "3 part zigbee powered scene switch",
        ota: true,
        extend: [m.commandsOnOff(), m.commandsLevelCtrl(), m.commandsColorCtrl(), m.commandsScenes(), m.battery()],
    },
    {
        zigbeeModel: ["Lighting Switch"],
        model: "BN-600087",
        vendor: "Dresden Elektronik",
        description: "2 part zigbee powered light switch",
        ota: true,
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2 } }),
            m.commandsOnOff({ endpointNames: ["1", "2"] }),
            m.commandsLevelCtrl({ endpointNames: ["1", "2"] }),
            m.commandsColorCtrl({ endpointNames: ["1", "2"] }),
            m.battery(),
        ],
    },
];
//# sourceMappingURL=dresden_elektronik.js.map