/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.SunflowAPI;
import org.sunflow.core.AccelerationStructure;
import org.sunflow.core.AccelerationStructureFactory;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.RenderObject;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Tesselatable;
import org.sunflow.core.accel.NullAccelerator;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.system.UI;

public class Geometry
implements RenderObject {
    private Tesselatable tesselatable;
    private PrimitiveList primitives;
    private AccelerationStructure accel;
    private int builtAccel;
    private int builtTess;
    private String acceltype;

    public Geometry(Tesselatable tesselatable) {
        this.tesselatable = tesselatable;
        this.primitives = null;
        this.accel = null;
        this.builtAccel = 0;
        this.builtTess = 0;
        this.acceltype = null;
    }

    public Geometry(PrimitiveList primitiveList) {
        this.tesselatable = null;
        this.primitives = primitiveList;
        this.accel = null;
        this.builtAccel = 0;
        this.builtTess = 1;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.acceltype = parameterList.getString("accel", this.acceltype);
        if (this.tesselatable != null) {
            this.primitives = null;
            this.builtTess = 0;
        }
        this.accel = null;
        this.builtAccel = 0;
        if (this.tesselatable != null) {
            return this.tesselatable.update(parameterList, sunflowAPI);
        }
        return this.primitives.update(parameterList, sunflowAPI);
    }

    int getNumPrimitives() {
        return this.primitives == null ? 0 : this.primitives.getNumPrimitives();
    }

    BoundingBox getWorldBounds(Matrix4 matrix4) {
        if (this.primitives == null) {
            BoundingBox boundingBox = this.tesselatable.getWorldBounds(matrix4);
            if (boundingBox != null) {
                return boundingBox;
            }
            if (this.builtTess == 0) {
                this.tesselate();
            }
            if (this.primitives == null) {
                return null;
            }
        }
        return this.primitives.getWorldBounds(matrix4);
    }

    void intersect(Ray ray, IntersectionState intersectionState) {
        if (this.builtTess == 0) {
            this.tesselate();
        }
        if (this.builtAccel == 0) {
            this.build();
        }
        this.accel.intersect(ray, intersectionState);
    }

    private synchronized void tesselate() {
        if (this.builtTess != 0) {
            return;
        }
        if (this.tesselatable != null && this.primitives == null) {
            UI.printInfo(UI.Module.GEOM, "Tesselating geometry ...", new Object[0]);
            this.primitives = this.tesselatable.tesselate();
            if (this.primitives == null) {
                UI.printError(UI.Module.GEOM, "Tesselation failed - geometry will be discarded", new Object[0]);
            } else {
                UI.printDetailed(UI.Module.GEOM, "Tesselation produced %d primitives", this.primitives.getNumPrimitives());
            }
        }
        this.builtTess = 1;
    }

    private synchronized void build() {
        if (this.builtAccel != 0) {
            return;
        }
        if (this.primitives != null) {
            int n = this.primitives.getNumPrimitives();
            if (n >= 1000) {
                UI.printInfo(UI.Module.GEOM, "Building acceleration structure for %d primitives ...", n);
            }
            this.accel = AccelerationStructureFactory.create(this.acceltype, n, true);
            this.accel.build(this.primitives);
        } else {
            this.accel = new NullAccelerator();
        }
        this.builtAccel = 1;
    }

    void prepareShadingState(ShadingState shadingState) {
        this.primitives.prepareShadingState(shadingState);
    }

    PrimitiveList getBakingPrimitives() {
        if (this.builtTess == 0) {
            this.tesselate();
        }
        if (this.primitives == null) {
            return null;
        }
        return this.primitives.getBakingPrimitives();
    }

    PrimitiveList getPrimitiveList() {
        return this.primitives;
    }
}

