/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.sf.sdedit.util.Ref;
import net.sf.sdedit.util.Utilities;

public final class WindowsRegistry
extends Thread {
    private volatile String result;
    private String category;
    private String key;

    private WindowsRegistry(String category, String key) {
        this.category = category;
        this.key = key;
    }

    @Override
    public void run() {
        try {
            this.result = this.fetchValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getValue(String category, String key) {
        if (key == null) {
            key = "<NO NAME>";
        }
        WindowsRegistry registry = new WindowsRegistry(category, key);
        registry.start();
        try {
            registry.join(2000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return registry.result;
    }

    private String fetchValue() throws IOException {
        this.category = this.category.replace('/', '\\');
        String command = "reg QUERY \"" + this.category + "\"";
        Ref<InputStream> streamRef = new Ref<InputStream>();
        for (String line : Utilities.readLines(command, streamRef, Charset.defaultCharset())) {
            String[] parts = (line = line.replaceAll("\\s+", " ").trim()).split(" ");
            if (parts.length < 3 || !parts[0].trim().equals(this.key)) continue;
            ((InputStream)streamRef.t).close();
            String value = null;
            for (int i = 2; i < parts.length; ++i) {
                value = value == null ? parts[i] : value + " " + parts[i];
            }
            if (value == null) {
                return "";
            }
            return value.trim();
        }
        return null;
    }
}

