/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NodePositionProcessor
implements ILayoutProcessor<TGraph> {
    private int numberOfNodes;

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor set coordinates", 1.0f);
        this.numberOfNodes = tGraph.getNodes().isEmpty() ? 1 : tGraph.getNodes().size();
        TNode root = null;
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!tNode.getProperty(InternalProperties.ROOT).booleanValue()) continue;
            root = tNode;
            KVector pos = tNode.getPosition();
            pos.x = tNode.getProperty(InternalProperties.XCOOR).doubleValue();
            pos.y = tNode.getProperty(InternalProperties.YCOOR).doubleValue();
        }
        LinkedList<TNode> nextLevel = root.getChildrenCopy();
        float subTasks = 1.0f;
        do {
            nextLevel = this.setCoordinates(nextLevel, progressMonitor.subTask(subTasks));
            subTasks = nextLevel.size() / this.numberOfNodes;
        } while (!nextLevel.isEmpty());
        for (TNode n : tGraph.getNodes()) {
            n.getPosition().sub(new KVector(n.getSize().x / 2.0, n.getSize().y / 2.0));
        }
        progressMonitor.done();
    }

    private LinkedList<TNode> setCoordinates(LinkedList<TNode> currentLevel, IElkProgressMonitor progressMonitor) {
        if (!currentLevel.isEmpty()) {
            LinkedList<TNode> nextLevel = new LinkedList<TNode>();
            for (TNode tNode : currentLevel) {
                nextLevel.addAll(tNode.getChildrenCopy());
                KVector pos = tNode.getPosition();
                pos.x = tNode.getProperty(InternalProperties.XCOOR).doubleValue();
                pos.y = tNode.getProperty(InternalProperties.YCOOR).doubleValue();
            }
            return nextLevel;
        }
        return new LinkedList<TNode>();
    }
}

