/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ltr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.ltr.LtrStatName;
import org.opensearch.client.opensearch.ltr.LtrStatsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class LtrStatsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, LtrStatsRequest> {
    @Nonnull
    private final List<String> nodeId;
    @Nonnull
    private final List<LtrStatName> stat;
    @Nullable
    private final Time timeout;
    public static final Endpoint<LtrStatsRequest, LtrStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<LtrStatsRequest, LtrStatsResponse>(request -> "GET", request -> {
        boolean _nodeId = true;
        int _stat = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.stat())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            return "/_plugins/_ltr/stats";
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ltr/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ltr/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/stats/");
            SimpleEndpoint.pathEncode(request.stat.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ltr/stats/");
            SimpleEndpoint.pathEncode(request.stat.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, LtrStatsResponse._DESERIALIZER);

    private LtrStatsRequest(Builder builder) {
        super(builder);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.stat = ApiTypeHelper.unmodifiable(builder.stat);
        this.timeout = builder.timeout;
    }

    public static LtrStatsRequest of(Function<Builder, ObjectBuilder<LtrStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nonnull
    public final List<LtrStatName> stat() {
        return this.stat;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + Objects.hashCode(this.stat);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtrStatsRequest other = (LtrStatsRequest)o;
        return Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.stat, other.stat) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, LtrStatsRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private List<LtrStatName> stat;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(LtrStatsRequest o) {
            super(o);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.stat = Builder._listCopy(o.stat);
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.stat = Builder._listCopy(o.stat);
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        @Nonnull
        public final Builder stat(List<LtrStatName> list) {
            this.stat = Builder._listAddAll(this.stat, list);
            return this;
        }

        @Nonnull
        public final Builder stat(LtrStatName value, LtrStatName ... values) {
            this.stat = Builder._listAdd(this.stat, value, values);
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public LtrStatsRequest build() {
            this._checkSingleUse();
            return new LtrStatsRequest(this);
        }
    }
}

