/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.onnx;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.tribuo.math.la.Matrix;
import org.tribuo.math.la.SGDVector;
import org.tribuo.util.onnx.ONNXContext;
import org.tribuo.util.onnx.ONNXInitializer;

public abstract class ONNXMathUtils {
    private ONNXMathUtils() {
    }

    public static ONNXInitializer floatVector(ONNXContext context, String name, SGDVector vector) {
        return context.floatTensor(name, Collections.singletonList(vector.size()), fb -> vector.forEach(vt -> fb.put(vt.index, (float)vt.value)));
    }

    public static ONNXInitializer floatMatrix(ONNXContext context, String name, Matrix matrix, boolean transpose) {
        List dims = Arrays.stream(matrix.getShape()).boxed().collect(Collectors.toList());
        if (transpose) {
            Collections.reverse(dims);
        }
        return context.floatTensor(name, dims, fb -> matrix.forEach(mt -> {
            int address = transpose ? mt.j * matrix.getDimension1Size() + mt.i : mt.i * matrix.getDimension2Size() + mt.j;
            fb.put(address, (float)mt.value);
        }));
    }
}

