// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { _decryptStream } from './decrypt_stream';
// @ts-ignore
import { finished } from 'readable-stream';
export async function _decrypt(decryptParameters, cmm, ciphertext, { encoding, maxBodySize } = {}) {
    const stream = _decryptStream(decryptParameters, cmm, {
        maxBodySize,
    });
    const plaintext = [];
    let messageHeader = false;
    stream
        .once('MessageHeader', (header) => {
        messageHeader = header;
    })
        .on('data', (chunk) => plaintext.push(chunk));
    // This will check both Uint8Array|Buffer
    if (ciphertext instanceof Uint8Array) {
        stream.end(ciphertext);
    }
    else if (typeof ciphertext === 'string') {
        stream.end(Buffer.from(ciphertext, encoding));
    }
    else if (ciphertext.readable) {
        ciphertext.pipe(stream);
    }
    else {
        throw new Error('Unsupported ciphertext format');
    }
    await finishedAsync(stream);
    if (!messageHeader)
        throw new Error('Unknown format');
    return {
        plaintext: Buffer.concat(plaintext),
        messageHeader,
    };
}
async function finishedAsync(stream) {
    return new Promise((resolve, reject) => {
        finished(stream, (err) => (err ? reject(err) : resolve()));
    });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVjcnlwdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9kZWNyeXB0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7QUFNdEMsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLGtCQUFrQixDQUFBO0FBR2pELGFBQWE7QUFDYixPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0saUJBQWlCLENBQUE7QUFjMUMsTUFBTSxDQUFDLEtBQUssVUFBVSxRQUFRLENBQzVCLGlCQUFvQyxFQUNwQyxHQUF1QyxFQUN2QyxVQUEyRSxFQUMzRSxFQUFFLFFBQVEsRUFBRSxXQUFXLEtBQXFCLEVBQUU7SUFFOUMsTUFBTSxNQUFNLEdBQUcsY0FBYyxDQUFDLGlCQUFpQixFQUFFLEdBQUcsRUFBRTtRQUNwRCxXQUFXO0tBQ1osQ0FBQyxDQUFBO0lBRUYsTUFBTSxTQUFTLEdBQWEsRUFBRSxDQUFBO0lBQzlCLElBQUksYUFBYSxHQUEwQixLQUFLLENBQUE7SUFDaEQsTUFBTTtTQUNILElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQyxNQUFxQixFQUFFLEVBQUU7UUFDL0MsYUFBYSxHQUFHLE1BQU0sQ0FBQTtJQUN4QixDQUFDLENBQUM7U0FDRCxFQUFFLENBQUMsTUFBTSxFQUFFLENBQUMsS0FBYSxFQUFFLEVBQUUsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUE7SUFFdkQseUNBQXlDO0lBQ3pDLElBQUksVUFBVSxZQUFZLFVBQVUsRUFBRTtRQUNwQyxNQUFNLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxDQUFBO0tBQ3ZCO1NBQU0sSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDekMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFBO0tBQzlDO1NBQU0sSUFBSSxVQUFVLENBQUMsUUFBUSxFQUFFO1FBQzlCLFVBQVUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUE7S0FDeEI7U0FBTTtRQUNMLE1BQU0sSUFBSSxLQUFLLENBQUMsK0JBQStCLENBQUMsQ0FBQTtLQUNqRDtJQUVELE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFBO0lBQzNCLElBQUksQ0FBQyxhQUFhO1FBQUUsTUFBTSxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFBO0lBRXJELE9BQU87UUFDTCxTQUFTLEVBQUUsTUFBTSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDbkMsYUFBYTtLQUNkLENBQUE7QUFDSCxDQUFDO0FBRUQsS0FBSyxVQUFVLGFBQWEsQ0FBQyxNQUFjO0lBQ3pDLE9BQU8sSUFBSSxPQUFPLENBQU8sQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7UUFDM0MsUUFBUSxDQUFDLE1BQU0sRUFBRSxDQUFDLEdBQVUsRUFBRSxFQUFFLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFBO0lBQ25FLENBQUMsQ0FBQyxDQUFBO0FBQ0osQ0FBQyJ9