/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.composite;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.codec.composite.composite103.Composite103Codec;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class CompositeCodecFactory {
    public static final String COMPOSITE_CODEC = "Composite103Codec";

    public Map<String, Codec> getCompositeIndexCodecs(MapperService mapperService, Logger logger) {
        HashMap<String, Codec> codecs = new HashMap<String, Codec>();
        codecs.put("default", (Codec)new Composite103Codec(Lucene103Codec.Mode.BEST_SPEED, mapperService, logger));
        codecs.put("lz4", (Codec)new Composite103Codec(Lucene103Codec.Mode.BEST_SPEED, mapperService, logger));
        codecs.put("best_compression", (Codec)new Composite103Codec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        codecs.put("zlib", (Codec)new Composite103Codec(Lucene103Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        return codecs;
    }
}

