/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class TooManyReturnStatementsHint
extends HintRule {
    private static final String HINT_ID = "too.many.return.statements.hint";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.TooManyReturnStatementsHintDesc();
    }

    public String getDisplayName() {
        return Bundle.TooManyReturnStatementsHintDisp();
    }

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }

    private final class CheckVisitor
    extends DefaultVisitor {
        private static final int MAX_NUMBER_OF_STATEMENTS = 1;
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final List<Hint> hints;
        private final Deque<ReturnStatementsHolder> functionStack;

        private CheckVisitor(FileObject fileObject, BaseDocument doc) {
            this.fileObject = fileObject;
            this.baseDocument = doc;
            this.hints = new ArrayList<Hint>();
            this.functionStack = new ArrayDeque<ReturnStatementsHolder>();
        }

        private Collection<? extends Hint> getHints() {
            return this.hints;
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.functionStack.push(new ReturnStatementsHolder());
            super.visit(node);
            this.createHints(this.functionStack.pop());
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.functionStack.push(new ReturnStatementsHolder());
            super.visit(node);
            this.createHints(this.functionStack.pop());
        }

        @Override
        public void visit(ReturnStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            super.visit(node);
            ReturnStatementsHolder returnStatementsHolder = this.functionStack.peek();
            if (returnStatementsHolder != null) {
                returnStatementsHolder.addReturnStatement(node);
            }
        }

        private void createHints(ReturnStatementsHolder returnStatementsHolder) {
            List<ReturnStatement> returnStatements = returnStatementsHolder.getReturnStatements();
            if (returnStatements.size() > 1) {
                for (ReturnStatement returnStatement : returnStatements) {
                    this.hints.add(this.createHint(returnStatement));
                }
            }
        }

        private Hint createHint(ReturnStatement node) {
            Hint result = null;
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (TooManyReturnStatementsHint.this.showHint(offsetRange, this.baseDocument)) {
                result = new Hint((Rule)TooManyReturnStatementsHint.this, Bundle.TooManyReturnStatementsHintText(), this.fileObject, offsetRange, null, 500);
            }
            return result;
        }
    }

    private static final class ReturnStatementsHolder {
        private final List<ReturnStatement> returnStatements = new ArrayList<ReturnStatement>();

        private void addReturnStatement(ReturnStatement node) {
            this.returnStatements.add(node);
        }

        private List<ReturnStatement> getReturnStatements() {
            return this.returnStatements;
        }
    }
}

