/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class Quote
extends Expression {
    private final ArrayList<Expression> expressions = new ArrayList();
    private Type quoteType;

    public Quote(int start, int end, Expression[] expressions, Type type) {
        super(start, end);
        this.expressions.addAll(Arrays.asList(expressions));
        this.quoteType = type;
    }

    public Quote(int start, int end, List<Exception> expressions, Type type) {
        this(start, end, expressions == null ? new Expression[]{} : expressions.toArray(new Expression[0]), type);
    }

    public List<Expression> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public Type getQuoteType() {
        return this.quoteType;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getExpressions()) {
            sb.append(expression).append(",");
        }
        return String.valueOf((Object)this.getQuoteType()) + " " + sb.toString();
    }

    public static enum Type {
        QUOTE,
        SINGLE,
        HEREDOC;

    }
}

