/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuListener;
import org.openide.util.NbBundle;

public class RuntimeComboBox
extends JPanel {
    private static final String noneSelectionMessage = NbBundle.getMessage(RuntimeComboBox.class, (String)"MSG_runtime_none");
    private static final String otherSelectionMessage = NbBundle.getMessage(RuntimeComboBox.class, (String)"MSG_runtime_other");
    private static final String SEPARATOR = "-----";
    private JComboBox combo;

    public RuntimeComboBox() {
        this.initComponents();
        this.combo.setRenderer(new DefaultListCellRenderer(){
            private JSeparator separator = new JSeparator(0);

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (RuntimeComboBox.SEPARATOR.equals(value)) {
                    return this.separator;
                }
                String s = "";
                s = value != null ? (value instanceof Action ? (String)((Action)value).getValue("Name") : value.toString()) : noneSelectionMessage;
                return super.getListCellRendererComponent((JList<?>)list, s, index, isSelected, cellHasFocus);
            }
        });
        this.combo.setModel(new RuntimeListModel());
    }

    private void initComponents() {
        this.combo = new JComboBox();
        this.combo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.combo, 0, 188, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.combo, -2, -1, -2));
    }

    public void showPopup() {
        this.combo.showPopup();
    }

    public void setSelectedItem(Object anObject) {
        this.combo.setSelectedItem(anObject);
    }

    public void setSelectedIndex(int anIndex) {
        this.combo.setSelectedIndex(anIndex);
    }

    public void setPrototypeDisplayValue(Object prototypeDisplayValue) {
        this.combo.setPrototypeDisplayValue(prototypeDisplayValue);
    }

    public void setPopupVisible(boolean v) {
        this.combo.setPopupVisible(v);
    }

    public void setMaximumRowCount(int count) {
        this.combo.setMaximumRowCount(count);
    }

    public void setLightWeightPopupEnabled(boolean aFlag) {
        this.combo.setLightWeightPopupEnabled(aFlag);
    }

    public void setKeySelectionManager(JComboBox.KeySelectionManager aManager) {
        this.combo.setKeySelectionManager(aManager);
    }

    @Override
    public void setEnabled(boolean b) {
        this.combo.setEnabled(b);
    }

    public void setEditor(ComboBoxEditor anEditor) {
        this.combo.setEditor(anEditor);
    }

    public void setEditable(boolean aFlag) {
        this.combo.setEditable(aFlag);
    }

    public boolean selectWithKeyChar(char keyChar) {
        return this.combo.selectWithKeyChar(keyChar);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.combo.removePopupMenuListener(l);
    }

    public void removeItemListener(ItemListener aListener) {
        this.combo.removeItemListener(aListener);
    }

    public void removeActionListener(ActionListener l) {
        this.combo.removeActionListener(l);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        this.combo.processKeyEvent(e);
    }

    public boolean isPopupVisible() {
        return this.combo.isPopupVisible();
    }

    public boolean isLightWeightPopupEnabled() {
        return this.combo.isLightWeightPopupEnabled();
    }

    public boolean isEditable() {
        return this.combo.isEditable();
    }

    public void hidePopup() {
        this.combo.hidePopup();
    }

    public Object[] getSelectedObjects() {
        return this.combo.getSelectedObjects();
    }

    public Object getSelectedItem() {
        return this.combo.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.combo.getSelectedIndex();
    }

    public Object getPrototypeDisplayValue() {
        return this.combo.getPrototypeDisplayValue();
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return this.combo.getPopupMenuListeners();
    }

    public int getMaximumRowCount() {
        return this.combo.getMaximumRowCount();
    }

    public JComboBox.KeySelectionManager getKeySelectionManager() {
        return this.combo.getKeySelectionManager();
    }

    public ItemListener[] getItemListeners() {
        return this.combo.getItemListeners();
    }

    public int getItemCount() {
        return this.combo.getItemCount();
    }

    public Object getItemAt(int index) {
        return this.combo.getItemAt(index);
    }

    public void firePopupMenuWillBecomeVisible() {
        this.combo.firePopupMenuWillBecomeVisible();
    }

    public void firePopupMenuWillBecomeInvisible() {
        this.combo.firePopupMenuWillBecomeInvisible();
    }

    public void firePopupMenuCanceled() {
        this.combo.firePopupMenuCanceled();
    }

    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        this.combo.configureEditor(anEditor, anItem);
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.combo.addPopupMenuListener(l);
    }

    public void addItemListener(ItemListener aListener) {
        this.combo.addItemListener(aListener);
    }

    public void addActionListener(ActionListener l) {
        this.combo.addActionListener(l);
    }

    public void actionPerformed(ActionEvent e) {
        this.combo.actionPerformed(e);
    }

    public <T> void setModel(RuntimeListModel<T> model) {
        this.combo.setModel(model);
    }

    public <T> RuntimeListModel<T> getModel() {
        return (RuntimeListModel)this.combo.getModel();
    }

    public Action getGrowAction() {
        return this.getModel().getGrowAction();
    }

    public void setGrowAction(Action growAction) {
        this.getModel().setGrowAction(growAction);
    }

    static /* synthetic */ String access$100() {
        return otherSelectionMessage;
    }

    public static final class RuntimeListModel<T>
    implements ComboBoxModel {
        private final Set<ListDataListener> listeners = new CopyOnWriteArraySet<ListDataListener>();
        private final List<T> predefinedList = new ArrayList<T>();
        private final List<T> userList = new ArrayList<T>();
        private T selected = null;
        private Action growAction = new AbstractAction(RuntimeComboBox.access$100()){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };

        RuntimeListModel() {
        }

        void setGrowAction(Action ga) {
            this.growAction = ga;
            this.fireDataChanged();
        }

        Action getGrowAction() {
            return this.growAction;
        }

        @Override
        public void setSelectedItem(final Object anItem) {
            if (anItem != null) {
                if (anItem.equals(RuntimeComboBox.SEPARATOR)) {
                    return;
                }
                if (anItem instanceof Action) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ RuntimeListModel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            ((Action)anItem).actionPerformed(new ActionEvent(this, 0, "grow"));
                        }
                    });
                } else {
                    this.selected = anItem;
                }
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.getActionPos() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            int sep = this.getSepPos();
            if (index < sep) {
                int siz;
                int n = siz = this.predefinedList.isEmpty() ? 0 : this.predefinedList.size();
                if (index < siz) {
                    return this.predefinedList.get(index);
                }
                return this.userList.get(index - siz);
            }
            if (index == sep) {
                return RuntimeComboBox.SEPARATOR;
            }
            if (index == this.getActionPos()) {
                return this.growAction;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public final List<T> getPredefined() {
            return Collections.unmodifiableList(this.predefinedList);
        }

        public final List<T> getUserDefined() {
            return Collections.unmodifiableList(this.userList);
        }

        private void fireDataAdded(int start, int stop) {
            if (stop <= start) {
                return;
            }
            for (ListDataListener l : this.listeners) {
                l.intervalAdded(new ListDataEvent(this, 1, start, stop));
            }
        }

        private void fireDataRemoved(int start, int stop) {
            for (ListDataListener l : this.listeners) {
                l.intervalRemoved(new ListDataEvent(this, 2, start, stop));
            }
        }

        private void fireDataChanged() {
            int stop = this.getSize() - 1;
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(new ListDataEvent(this, 0, 0, stop));
            }
        }

        public final void setPredefined(T ... predefined) {
            int stop;
            if (!this.predefinedList.isEmpty()) {
                stop = this.predefinedList.size();
                this.predefinedList.clear();
                this.fireDataRemoved(0, stop);
            }
            this.predefinedList.addAll(Arrays.asList(predefined));
            stop = this.predefinedList.size();
            if (this.selected == null && !this.predefinedList.isEmpty()) {
                this.selected = this.predefinedList.get(0);
            }
            this.fireDataAdded(0, stop);
        }

        public final void setUserDefined(T ... user) {
            int stop;
            int start;
            int n = start = this.predefinedList.isEmpty() ? 0 : this.predefinedList.size();
            if (!this.userList.isEmpty()) {
                stop = this.userList.size();
                this.userList.clear();
                this.fireDataRemoved(start, start + stop);
            }
            this.userList.addAll(Arrays.asList(user));
            stop = this.userList.size();
            if (this.selected == null && !this.userList.isEmpty()) {
                this.selected = this.userList.get(0);
            }
            this.fireDataAdded(start, start + stop);
        }

        public final void addPredefined(T ... predefined) {
            int stop2;
            int stop1 = this.predefinedList.isEmpty() ? 0 : this.predefinedList.size();
            this.predefinedList.addAll(Arrays.asList(predefined));
            int n = stop2 = this.predefinedList.isEmpty() ? 0 : this.predefinedList.size();
            if (this.selected == null && !this.predefinedList.isEmpty()) {
                this.selected = this.predefinedList.get(0);
            }
            this.fireDataAdded(stop1, stop2);
        }

        public final void addUserDefined(T ... userdefined) {
            int stop2;
            int start = this.predefinedList.isEmpty() ? 0 : this.predefinedList.size();
            int stop1 = this.userList.isEmpty() ? 0 : this.userList.size();
            this.userList.addAll(Arrays.asList(userdefined));
            int n = stop2 = this.userList.isEmpty() ? 0 : this.userList.size();
            if (this.selected == null && !this.userList.isEmpty()) {
                this.selected = this.userList.get(0);
            }
            this.fireDataAdded(start + stop1, start + stop2);
        }

        private int getUserListStartPos() {
            return this.predefinedList.isEmpty() ? 0 : this.predefinedList.size();
        }

        private int getActionPos() {
            return this.getSepPos() + 1;
        }

        private int getSepPos() {
            if (this.predefinedList.isEmpty() && this.userList.isEmpty()) {
                return -1;
            }
            if (this.predefinedList.isEmpty()) {
                return this.userList.size();
            }
            if (this.userList.isEmpty()) {
                return this.predefinedList.size();
            }
            return this.predefinedList.size() + this.userList.size();
        }
    }
}

