/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views.debugging;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public final class FiltersDescriptor {
    public static final String SUSPEND_SORT = "suspend_sort";
    public static final String NATURAL_SORT = "natural_sort";
    public static final String ALPHABETIC_SORT = "alphabetic_sort";
    public static final String SHOW_QUALIFIED_NAMES = "show_fqn";
    public static final String SHOW_MONITORS = "show_monitors";
    public static final String SHOW_SYSTEM_THREADS = "show_system_threads";
    public static final String SHOW_SUSPEND_TABLE = "show_suspend_table";
    public static final String SHOW_THREAD_GROUPS = "thread_group";
    public static final String SHOW_SUSPENDED_THREADS_ONLY = "suspended_threads_only";
    public static final String PREF_SORT_ALPHABET = "sort.alphabet";
    public static final String PREF_SORT_NATURAL = "sort.natural";
    public static final String PREF_SORT_SUSPEND = "sort.suspend";
    public static final String PREF_SHOW_MONITORS = "show.monitors";
    public static final String PREF_SHOW_SYSTEM_THREADS = "show.systemThreads";
    public static final String PREF_SHOW_THREAD_GROUPS = "show.threadGroups";
    public static final String PREF_SHOW_SUSPENDED_THREADS_ONLY = "show.suspendedThreadsOnly";
    public static final String PREF_SHOW_SUSPEND_TABLE = "show_suspend_table";
    public static final String PREF_SHOW_PACKAGE_NAMES = "show.packageNames";
    private static FiltersDescriptor instance;
    private List<DebuggingView.DVFilter> filters;
    private Action[] filterActions;
    private FiltersAccessor filtersAccessor;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private FiltersDescriptor() {
        this.filters = Collections.emptyList();
    }

    public static synchronized FiltersDescriptor getInstance() {
        if (instance == null) {
            instance = new FiltersDescriptor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUpFilters(DebuggingView.DVSupport dvs) {
        List<Object> fs = dvs != null ? this.filtersAccessor.getFilters(dvs) : Collections.emptyList();
        FiltersDescriptor filtersDescriptor = this;
        synchronized (filtersDescriptor) {
            this.filters = fs;
            this.filterActions = null;
        }
        this.firePropertyChange("filters", null, null);
    }

    public synchronized Action[] getFilterActions() {
        if (this.filterActions == null) {
            if (this.filters.isEmpty()) {
                this.filterActions = new Action[0];
                return this.filterActions;
            }
            ArrayList<SortAction> list = new ArrayList<SortAction>();
            for (DebuggingView.DVFilter item : this.filters) {
                if (item.getGroup() == null) continue;
                SortAction action = new SortAction(item);
                list.add(action);
            }
            int size = list.size();
            this.filterActions = new Action[size + 2];
            for (int x = 0; x < size; ++x) {
                this.filterActions[x] = (Action)list.get(x);
            }
            this.filterActions[size] = null;
            this.filterActions[size + 1] = new FilterSubmenuAction(this);
        }
        return this.filterActions;
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public String getName(int index) {
        return this.filters.get(index).getName();
    }

    public String getDisplayName(int index) {
        return this.filters.get(index).getDisplayName();
    }

    public String getTooltip(int index) {
        return this.filters.get(index).getTooltip();
    }

    public Icon getSelectedIcon(int index) {
        return this.filters.get(index).getIcon();
    }

    public boolean isSelected(int index) {
        return this.filters.get(index).isSelected();
    }

    public void setSelected(int index, boolean selected) {
        this.filters.get(index).setSelected(selected);
    }

    public void setSelected(String filterName, boolean selected) {
        for (DebuggingView.DVFilter item : this.filters) {
            if (!item.getName().equals(filterName)) continue;
            item.setSelected(selected);
            break;
        }
    }

    public void connectToggleButton(int index, JToggleButton button) {
        FilterImpl impl = FiltersDescriptor.getInstance().filtersAccessor.getImpl(this.filters.get(index));
        impl.setToggleButton(button);
    }

    private static Icon loadIcon(String iconName) {
        return ImageUtilities.loadImageIcon((String)("org/netbeans/modules/debugger/resources/debuggingView/" + iconName), (boolean)false);
    }

    private static String getString(String label) {
        return NbBundle.getMessage(FiltersDescriptor.class, (String)label);
    }

    public void setFiltersAccessor(FiltersAccessor filtersAccessor) {
        this.filtersAccessor = filtersAccessor;
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static interface FiltersAccessor {
        public List<DebuggingView.DVFilter> getFilters(DebuggingView.DVSupport var1);

        public FilterImpl getImpl(DebuggingView.DVFilter var1);
    }

    private static final class SortAction
    extends AbstractAction
    implements Presenter.Popup {
        private DebuggingView.DVFilter filterItem;

        SortAction(DebuggingView.DVFilter item) {
            this.filterItem = item;
            String displayName = item.getDisplayName();
            int i = Mnemonics.findMnemonicAmpersand((String)displayName);
            if (i >= 0) {
                displayName = displayName.substring(0, i) + displayName.substring(i + 1);
            }
            this.putValue("Name", displayName);
            this.putValue("SmallIcon", item.getIcon());
        }

        public final JMenuItem getPopupPresenter() {
            JRadioButtonMenuItem result = this.obtainMenuItem();
            return result;
        }

        protected final JRadioButtonMenuItem obtainMenuItem() {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)menuItem, (String)this.filterItem.getDisplayName());
            menuItem.setAction(this);
            menuItem.addHierarchyListener(new ParentChangeListener(menuItem));
            menuItem.setSelected(this.filterItem.isSelected());
            return menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filterItem.setSelected(!this.filterItem.isSelected());
        }

        private class ParentChangeListener
        implements HierarchyListener {
            private JRadioButtonMenuItem menuItem;

            public ParentChangeListener(JRadioButtonMenuItem menuItem) {
                this.menuItem = menuItem;
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JComponent parent = (JComponent)e.getChangedParent();
                if (parent == null) {
                    return;
                }
                ButtonGroup group = (ButtonGroup)parent.getClientProperty(this.getClass().getName() + " buttonGroup");
                if (group == null) {
                    group = new ButtonGroup();
                }
                group.add(this.menuItem);
                this.menuItem.removeHierarchyListener(this);
            }
        }
    }

    static final class FilterSubmenuAction
    extends AbstractAction
    implements Presenter.Popup {
        private static final String PROP_FILTER_NAME = "nbFilterName";
        private FiltersDescriptor filtersDesc;

        public FilterSubmenuAction(FiltersDescriptor filters) {
            this.filtersDesc = filters;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)source;
                String filterName = (String)menuItem.getClientProperty(PROP_FILTER_NAME);
                this.filtersDesc.setSelected(filterName, menuItem.isSelected());
            }
        }

        public final JMenuItem getPopupPresenter() {
            return this.createSubmenu();
        }

        private JMenuItem createSubmenu() {
            JMenu menu = new JMenu();
            Mnemonics.setLocalizedText((AbstractButton)menu, (String)NbBundle.getMessage(FiltersDescriptor.class, (String)"LBL_FilterSubmenu"));
            for (DebuggingView.DVFilter item : this.filtersDesc.filters) {
                if (item.getGroup() != null) continue;
                String filterName = item.getName();
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(item.getDisplayName(), item.isSelected());
                Mnemonics.setLocalizedText((AbstractButton)menuItem, (String)item.getDisplayName());
                menuItem.addActionListener(this);
                menuItem.putClientProperty(PROP_FILTER_NAME, filterName);
                ((Container)menu).add(menuItem);
            }
            return menu;
        }
    }

    public static class FilterImpl {
        private String name;
        private String displayName;
        private String tooltip;
        private Icon selectedIcon;
        private Preferences prefs;
        private String prefKey;
        private PreferenceChangeListener pchl;
        private boolean isSelected;
        private DebuggingView.DVFilter.Group group;
        private Reference<JToggleButton> toggleButtonRef = new WeakReference<Object>(null);

        public static FilterImpl createDefault(DebuggingView.DVFilter.DefaultFilter df) {
            FilterImpl fimpl;
            switch (df) {
                case showMonitors: {
                    fimpl = new FilterImpl(FiltersDescriptor.SHOW_MONITORS, FiltersDescriptor.getString("LBL_MONITORS"), FiltersDescriptor.getString("LBL_MONITORS_TIP"), FiltersDescriptor.loadIcon("monitor_acquired_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SHOW_MONITORS, false);
                    break;
                }
                case showQualifiedNames: {
                    fimpl = new FilterImpl(FiltersDescriptor.SHOW_QUALIFIED_NAMES, FiltersDescriptor.getString("LBL_QUALIFIED_NAMES"), FiltersDescriptor.getString("LBL_QUALIFIED_NAMES_TIP"), FiltersDescriptor.loadIcon("show_fqn_option_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SHOW_PACKAGE_NAMES, false);
                    break;
                }
                case showSuspendTable: {
                    fimpl = new FilterImpl("show_suspend_table", FiltersDescriptor.getString("LBL_SUSPEND_TABLE"), FiltersDescriptor.getString("LBL_SUSPEND_TABLE_TIP"), FiltersDescriptor.loadIcon("show_suspend_table_option_16.png"), FilterImpl.getDefaultPreferences(), "show_suspend_table", true);
                    break;
                }
                case showSuspendedThreadsOnly: {
                    fimpl = new FilterImpl(FiltersDescriptor.SHOW_SUSPENDED_THREADS_ONLY, FiltersDescriptor.getString("LBL_SUPSENDED_THREADS_ONLY"), FiltersDescriptor.getString("LBL_SUPSENDED_THREADS_ONLY_TIP"), FiltersDescriptor.loadIcon("show_suspended_threads_option_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SHOW_SUSPENDED_THREADS_ONLY, false);
                    break;
                }
                case showSystemThreads: {
                    fimpl = new FilterImpl(FiltersDescriptor.SHOW_SYSTEM_THREADS, FiltersDescriptor.getString("LBL_SYSTEM_THREADS"), FiltersDescriptor.getString("LBL_SYSTEM_THREADS_TIP"), FiltersDescriptor.loadIcon("show_system_threads_option_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SHOW_SYSTEM_THREADS, false);
                    break;
                }
                case showThreadGroups: {
                    fimpl = new FilterImpl(FiltersDescriptor.SHOW_THREAD_GROUPS, FiltersDescriptor.getString("LBL_THREAD_GROUPS"), FiltersDescriptor.getString("LBL_THREAD_GROUPS_TIP"), FiltersDescriptor.loadIcon("thread_group_mixed_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SHOW_THREAD_GROUPS, false);
                    break;
                }
                case sortAlphabetic: {
                    fimpl = new FilterImpl(FiltersDescriptor.ALPHABETIC_SORT, FiltersDescriptor.getString("LBL_ALPHABETIC_SORT"), FiltersDescriptor.getString("LBL_ALPHABETIC_SORT_TIP"), FiltersDescriptor.loadIcon("alphabetic_sort_order_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SORT_ALPHABET, false);
                    break;
                }
                case sortNatural: {
                    fimpl = new FilterImpl(FiltersDescriptor.NATURAL_SORT, FiltersDescriptor.getString("LBL_NATURAL_SORT"), FiltersDescriptor.getString("LBL_NATURAL_SORT_TIP"), FiltersDescriptor.loadIcon("natural_sort_order_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SORT_NATURAL, true);
                    break;
                }
                case sortSuspend: {
                    fimpl = new FilterImpl(FiltersDescriptor.SUSPEND_SORT, FiltersDescriptor.getString("LBL_SUSPEND_SORT"), FiltersDescriptor.getString("LBL_SUSPEND_SORT_TIP"), FiltersDescriptor.loadIcon("suspend_property_sort_order_16.png"), FilterImpl.getDefaultPreferences(), FiltersDescriptor.PREF_SORT_SUSPEND, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(df.name());
                }
            }
            return fimpl;
        }

        public FilterImpl(String name, String displayName, String tooltip, Icon selectedIcon, Preferences prefs, String prefKey, boolean isSelectedDefault) {
            this.name = name;
            this.displayName = displayName;
            this.tooltip = tooltip;
            this.selectedIcon = selectedIcon;
            this.isSelected = isSelectedDefault;
            this.prefs = prefs;
            this.prefKey = prefKey;
            this.readValue();
        }

        private DebuggingView.DVFilter.Group getGroup() {
            return this.group;
        }

        public void setGroup(DebuggingView.DVFilter.Group group) {
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public Icon getIcon() {
            return this.selectedIcon;
        }

        public Preferences getPreferences() {
            return this.prefs;
        }

        public String getPrefKey() {
            return this.prefKey;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean state) {
            if (this.isSelected == state) {
                return;
            }
            this.isSelected = state;
            this.setState(state);
            this.writeValue();
        }

        public void assureButtonSelected(boolean selected) {
            JToggleButton toggleButton = this.toggleButtonRef.get();
            if (toggleButton != null) {
                toggleButton.setSelected(selected);
            }
        }

        private void setState(boolean state) {
            JToggleButton toggleButton = this.toggleButtonRef.get();
            if (toggleButton != null) {
                toggleButton.setSelected(state);
            }
            if (state && this.group != null) {
                for (DebuggingView.DVFilter item : this.group.getItems()) {
                    FilterImpl impl = FiltersDescriptor.getInstance().filtersAccessor.getImpl(item);
                    if (impl == this || !item.isSelected()) continue;
                    item.setSelected(false);
                }
            }
        }

        public void setToggleButton(JToggleButton button) {
            this.toggleButtonRef = new WeakReference<JToggleButton>(button);
        }

        private void readValue() {
            this.isSelected = this.prefs.getBoolean(this.prefKey, this.isSelected);
            if (this.pchl == null) {
                this.pchl = new PreferenceChangeListener(){

                    @Override
                    public void preferenceChange(PreferenceChangeEvent evt) {
                        boolean wasSelected = isSelected;
                        this.readValue();
                        final boolean newSelected = isSelected;
                        if (wasSelected != newSelected) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this.setState(newSelected);
                                }
                            });
                        }
                    }
                };
                this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.pchl, (Object)this.prefs));
            }
        }

        private void writeValue() {
            this.prefs.putBoolean(this.prefKey, this.isSelected);
        }

        private static Preferences getDefaultPreferences() {
            final Preferences origPrefs = NbPreferences.root().node("org/netbeans/modules/debugger/jpda/ui").node("debugging");
            final Preferences preferences = NbPreferences.forModule(FilterImpl.class).node("debugging");
            return new AbstractPreferences(null, ""){

                @Override
                protected void putSpi(String key, String value) {
                    preferences.put(key, value);
                }

                @Override
                protected String getSpi(String key) {
                    String value = preferences.get(key, null);
                    if (value == null) {
                        value = origPrefs.get(key, null);
                    }
                    return value;
                }

                @Override
                protected void removeSpi(String key) {
                }

                @Override
                protected void removeNodeSpi() throws BackingStoreException {
                }

                @Override
                protected String[] keysSpi() throws BackingStoreException {
                    return preferences.keys();
                }

                @Override
                protected String[] childrenNamesSpi() throws BackingStoreException {
                    return preferences.childrenNames();
                }

                @Override
                protected AbstractPreferences childSpi(String name) {
                    return null;
                }

                @Override
                protected void syncSpi() throws BackingStoreException {
                    origPrefs.sync();
                    preferences.sync();
                }

                @Override
                protected void flushSpi() throws BackingStoreException {
                    preferences.flush();
                }

                @Override
                public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
                    preferences.addPreferenceChangeListener(pcl);
                }

                @Override
                public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
                    preferences.removePreferenceChangeListener(pcl);
                }
            };
        }
    }
}

