/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class TextSearchHighlighting
extends AbstractHighlightsContainer
implements PropertyChangeListener,
HighlightsChangeListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(TextSearchHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.TextSearchHighlighting";
    private static final RequestProcessor RP = new RequestProcessor("org.netbeans.modules.editor.lib2.highlighting.TextSearchHighlighting", 1, false, false);
    private final MimePath mimePath;
    private final JTextComponent component;
    private final Document document;
    private final OffsetsBag bag;

    public TextSearchHighlighting(JTextComponent component) {
        String mimeType = TextSearchHighlighting.getMimeType(component);
        this.mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        this.component = component;
        this.document = component.getDocument();
        this.document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)this.document));
        this.bag = new OffsetsBag(this.document);
        this.bag.addHighlightsChangeListener((HighlightsChangeListener)this);
        EditorFindSupport.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorFindSupport.getInstance()));
        this.fillInTheBag();
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return this.bag.getHighlights(startOffset, endOffset);
    }

    public void highlightChanged(HighlightsChangeEvent event) {
        this.fireHighlightsChange(event.getStartOffset(), event.getEndOffset());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "find-what".equals(evt.getPropertyName()) || "find-highlight-search".equals(evt.getPropertyName())) {
            this.fillInTheBag();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.bag.removeHighlights(Math.max(e.getOffset() - 1, 0), Math.min(e.getOffset() + 1, this.document.getLength()), false);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.bag.removeHighlights(e.getOffset(), e.getOffset() + e.getLength(), false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void fillInTheBag() {
        final Document d = this.document;
        final OffsetsBag b = this.bag;
        RP.post(new Runnable(){
            private boolean documentLocked = false;
            final /* synthetic */ TextSearchHighlighting this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!this.documentLocked) {
                    this.documentLocked = true;
                    d.render(this);
                    return;
                }
                OffsetsBag newBag = new OffsetsBag(d);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "TSH: filling the bag; enabled = {0}", this.this$0.isEnabled());
                }
                if (this.this$0.isEnabled() && this.this$0.component.equals(EditorFindSupport.getInstance().getFocusedTextComponent())) {
                    try {
                        int[] blocks = EditorFindSupport.getInstance().getBlocks(new int[]{-1, -1}, d, 0, d.getLength());
                        assert (blocks.length % 2 == 0) : "Wrong number of block offsets";
                        AttributeSet attribs = this.this$0.getAttribs();
                        for (int i = 0; i < blocks.length / 2; ++i) {
                            newBag.addHighlight(blocks[2 * i], blocks[2 * i + 1], attribs);
                        }
                    }
                    catch (BadLocationException e) {
                        LOG.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                b.setHighlights(newBag);
            }
        });
    }

    private boolean isEnabled() {
        Object prop = EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
        return prop instanceof Boolean && (Boolean)prop != false;
    }

    private AttributeSet getAttribs() {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
        AttributeSet attribs = fcs.getFontColors("highlight-search");
        return attribs == null ? SimpleAttributeSet.EMPTY : attribs;
    }

    static String getMimeType(JTextComponent component) {
        EditorKit kit;
        Document doc = component.getDocument();
        String mimeType = (String)doc.getProperty("mimeType");
        if (mimeType == null && (kit = component.getUI().getEditorKit(component)) != null) {
            mimeType = kit.getContentType();
        }
        return mimeType;
    }

    public static final class FactoryImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            ArrayList<HighlightsLayer> layers = new ArrayList<HighlightsLayer>();
            layers.add(HighlightsLayer.create((String)TextSearchHighlighting.LAYER_TYPE_ID, (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(200), (boolean)true, (HighlightsContainer)new TextSearchHighlighting(context.getComponent())));
            layers.add(HighlightsLayer.create((String)"org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/BLOCK_SEARCH", (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(100), (boolean)true, (HighlightsContainer)new SearchBlockHighlighting("org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/BLOCK_SEARCH", context.getComponent())));
            layers.add(HighlightsLayer.create((String)"org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH", (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(300), (boolean)true, (HighlightsContainer)new SearchBlockHighlighting("org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting/INC_SEARCH", context.getComponent())));
            return layers.toArray(new HighlightsLayer[0]);
        }

        public static final class SearchBlockHighlighting
        extends BlockHighlighting {
            public SearchBlockHighlighting(String layerId, JTextComponent component) {
                super(layerId, component);
                EditorFindSupport.getInstance().hookLayer(this, component);
            }
        }
    }
}

