/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.javaee.project.api.ant.ui.wizard.ProjectLocationWizardPanel;
import org.netbeans.modules.javaee.project.api.ant.ui.wizard.ProjectServerWizardPanel;
import org.netbeans.modules.javaee.project.api.ui.UserProjectSettings;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.modules.web.project.ui.wizards.PanelSupportedFrameworks;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewWebProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    boolean isIstantiating = false;
    private transient int index;
    private transient int panelsCount;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private String[] createSteps() {
        String[] steps = WebFrameworks.getFrameworks().size() > 0 ? new String[]{NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectServer"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP2_Frameworks")} : new String[]{NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectServer")};
        return steps;
    }

    public Set instantiate() throws IOException {
        assert (false) : "This method cannot be called if the class implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        List selectedExtenders;
        Ear ear;
        this.isIstantiating = true;
        handle.start(4);
        handle.progress(NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NewWebProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String servInstID = (String)this.wiz.getProperty("serverInstanceID");
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dirF);
        createData.setName((String)this.wiz.getProperty("name"));
        createData.setServerInstanceID(servInstID);
        if (createData.getSourceStructure() == null) {
            createData.setSourceStructure("BluePrints");
        }
        createData.setJavaEEProfile((Profile)this.wiz.getProperty("j2eeLevel"));
        createData.setContextPath((String)this.wiz.getProperty("contextPath"));
        createData.setJavaPlatformName((String)this.wiz.getProperty("setJavaPlatform"));
        createData.setSourceLevel((String)this.wiz.getProperty("setSourceLevel"));
        createData.setLibrariesDefinition(SharabilityUtility.getLibraryLocation((String)((String)this.wiz.getProperty("sharedLibraries"))));
        createData.setWebXmlRequired(this.checkFrameworksForWebXml());
        createData.setCDIEnabled((Boolean)this.wiz.getProperty("cdi"));
        AntProjectHelper h = WebProjectUtilities.createProject(createData);
        handle.progress(2);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        this.wiz.putProperty("name", null);
        Project earProject = (Project)this.wiz.getProperty("earApplication");
        WebProject createdWebProject = (WebProject)ProjectManager.getDefault().findProject(dir);
        if (earProject != null && createdWebProject != null && (ear = Ear.getEar((FileObject)earProject.getProjectDirectory())) != null) {
            ear.addWebModule(createdWebProject.getAPIWebModule());
        }
        UserProjectSettings.getDefault().setLastUsedServer(servInstID);
        SharableLibrariesUtils.setLastProjectSharable((createData.getLibrariesDefinition() != null ? 1 : 0) != 0);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        resultSet.add(dir);
        WebModule apiWebModule = null;
        if (createdWebProject != null) {
            apiWebModule = createdWebProject.getAPIWebModule();
        }
        if ((selectedExtenders = (List)this.wiz.getProperty("extenders")) != null && apiWebModule != null) {
            handle.progress(NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NewWebProjectWizardIterator_WizardProgress_AddingFrameworks"), 3);
            for (int i = 0; i < selectedExtenders.size(); ++i) {
                Set o = ((WebModuleExtender)selectedExtenders.get(i)).extend(apiWebModule);
                if (o == null) continue;
                resultSet.addAll(o);
            }
        }
        FileObject webRoot = h.getProjectDirectory().getFileObject("web");
        if (apiWebModule != null) {
            FileObject dd = apiWebModule.getDeploymentDescriptor();
            resultSet.addAll(WebProjectUtilities.ensureWelcomePage(webRoot, dd, createData.getJavaEEProfile()));
        }
        handle.progress(NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NewWebProjectWizardIterator_WizardProgress_PreparingToOpen"), 4);
        List selectedFrameworkNames = (List)this.wiz.getProperty("frameworkNames");
        int frameworkCount = selectedFrameworkNames != null ? selectedFrameworkNames.size() : 0;
        Object[] parameters = new Object[5 + frameworkCount];
        parameters[0] = Deployment.getDefault().getServerID(createData.getServerInstanceID());
        parameters[1] = createData.getServerInstanceID();
        parameters[2] = createData.getJavaEEVersion();
        parameters[3] = createData.getSourceLevel();
        parameters[4] = createData.getSourceStructure();
        if (selectedFrameworkNames != null) {
            for (int i = 0; i < selectedFrameworkNames.size(); ++i) {
                parameters[5 + i] = selectedFrameworkNames.get(i);
            }
        }
        Utils.logUI(NbBundle.getBundle(NewWebProjectWizardIterator.class), "UI_WEB_PROJECT_CREATE", parameters);
        Object[] parameters2 = new Object[5];
        parameters2[0] = "";
        try {
            if (servInstID != null) {
                parameters2[0] = Deployment.getDefault().getServerInstance(servInstID).getServerDisplayName();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        parameters2[1] = createData.getJavaEEVersion();
        parameters2[2] = createData.getSourceLevel();
        parameters2[3] = createData.getSourceStructure();
        StringBuffer sb = new StringBuffer(50);
        if (selectedFrameworkNames != null) {
            for (int i = 0; i < selectedFrameworkNames.size(); ++i) {
                sb.append((String)selectedFrameworkNames.get(i));
                if (i + 1 >= selectedFrameworkNames.size()) continue;
                sb.append("|");
            }
        }
        parameters2[4] = sb;
        Utils.logUsage(NewWebProjectWizardIterator.class, "USG_PROJECT_CREATE_WEB", parameters2);
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = WebFrameworks.getFrameworks().size() > 0 ? new WizardDescriptor.Panel[]{new ProjectLocationWizardPanel(J2eeModule.WAR, NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"TXT_NewWebApp"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NPW1_DefaultProjectName")), new ProjectServerWizardPanel(J2eeModule.WAR, NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectServer"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"TXT_NewWebApp"), true, false, true, false, false, true), new PanelSupportedFrameworks(this)} : new WizardDescriptor.Panel[]{new ProjectLocationWizardPanel(J2eeModule.WAR, NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectTitleName"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"TXT_NewWebApp"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NPW1_DefaultProjectName")), new ProjectServerWizardPanel(J2eeModule.WAR, NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_NWP1_ProjectServer"), NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"TXT_NewWebApp"), true, false, true, false, false, true)};
        this.panelsCount = this.panels.length;
        String[] steps = this.createSteps();
        for (int i = 0; i < steps.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz = null;
        }
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewWebProjectWizardIterator.class, (String)"LBL_WizardStepsCount"), Integer.toString(this.index + 1), Integer.toString(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panelsCount - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            StringBuilder sb = new StringBuilder();
            sb.append("panelsCount: ");
            sb.append(this.panelsCount);
            sb.append("\n panels size: ");
            sb.append(this.panels.length);
            throw new NoSuchElementException(sb.toString());
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private boolean checkFrameworksForWebXml() {
        boolean res = false;
        List frameworkNames = (List)this.wiz.getProperty("frameworkNames");
        if (frameworkNames != null) {
            block0: for (String fName : frameworkNames) {
                for (WebFrameworkProvider wfp : WebFrameworks.getFrameworks()) {
                    if (!wfp.getName().equals(fName)) continue;
                    res |= wfp.requiresWebXml();
                    continue block0;
                }
            }
        }
        return res;
    }
}

