/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.FailoverDataGuardAssociationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class FailoverDataGuardAssociationRequest
extends BmcRequest<FailoverDataGuardAssociationDetails> {
    private String databaseId;
    private String dataGuardAssociationId;
    private FailoverDataGuardAssociationDetails failoverDataGuardAssociationDetails;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public FailoverDataGuardAssociationDetails getFailoverDataGuardAssociationDetails() {
        return this.failoverDataGuardAssociationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public FailoverDataGuardAssociationDetails getBody$() {
        return this.failoverDataGuardAssociationDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).dataGuardAssociationId(this.dataGuardAssociationId).failoverDataGuardAssociationDetails(this.failoverDataGuardAssociationDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",dataGuardAssociationId=").append(String.valueOf(this.dataGuardAssociationId));
        sb.append(",failoverDataGuardAssociationDetails=").append(String.valueOf((Object)this.failoverDataGuardAssociationDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FailoverDataGuardAssociationRequest)) {
            return false;
        }
        FailoverDataGuardAssociationRequest other = (FailoverDataGuardAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.dataGuardAssociationId, other.dataGuardAssociationId) && Objects.equals((Object)this.failoverDataGuardAssociationDetails, (Object)other.failoverDataGuardAssociationDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.dataGuardAssociationId == null ? 43 : this.dataGuardAssociationId.hashCode());
        result = result * 59 + (this.failoverDataGuardAssociationDetails == null ? 43 : this.failoverDataGuardAssociationDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private String dataGuardAssociationId = null;
        private FailoverDataGuardAssociationDetails failoverDataGuardAssociationDetails = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public Builder failoverDataGuardAssociationDetails(FailoverDataGuardAssociationDetails failoverDataGuardAssociationDetails) {
            this.failoverDataGuardAssociationDetails = failoverDataGuardAssociationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(FailoverDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.failoverDataGuardAssociationDetails(o.getFailoverDataGuardAssociationDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public FailoverDataGuardAssociationRequest build() {
            FailoverDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(FailoverDataGuardAssociationDetails body) {
            this.failoverDataGuardAssociationDetails(body);
            return this;
        }

        public FailoverDataGuardAssociationRequest buildWithoutInvocationCallback() {
            FailoverDataGuardAssociationRequest request = new FailoverDataGuardAssociationRequest();
            request.databaseId = this.databaseId;
            request.dataGuardAssociationId = this.dataGuardAssociationId;
            request.failoverDataGuardAssociationDetails = this.failoverDataGuardAssociationDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

