/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPFrame;
import org.netbeans.modules.lsp.client.debugger.DAPVariable;
import org.netbeans.modules.lsp.client.debugger.models.CurrentFrameTracker;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class WatchesModel
extends CurrentFrameTracker
implements TreeModelFilter,
NodeModelFilter,
TableModel {
    private static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    private final DAPDebugger debugger;
    private final Map<Watch, EvalWatch> evalWatches = new HashMap<Watch, EvalWatch>();
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public WatchesModel(ContextProvider contextProvider) {
        super(contextProvider);
        this.debugger = (DAPDebugger)contextProvider.lookupFirst(null, DAPDebugger.class);
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        Object[] watches = original.getChildren(parent, from, to);
        Map<Watch, EvalWatch> map = this.evalWatches;
        synchronized (map) {
            for (int i = 0; i < watches.length; ++i) {
                Watch w;
                EvalWatch ew;
                Object watchObj = watches[i];
                if (!(watchObj instanceof Watch) || (ew = this.evalWatches.get(w = (Watch)watchObj)) != null) continue;
                ew = new EvalWatch(w);
                this.evalWatches.put(w, ew);
            }
        }
        return watches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        EvalWatch ew;
        Map<Watch, EvalWatch> map = this.evalWatches;
        synchronized (map) {
            ew = this.evalWatches.get(node);
        }
        if (ew != null) {
            switch (ew.getStatus().ordinal()) {
                case 2: {
                    DAPVariable result = ew.getResult();
                    return result.getTotalChildren();
                }
            }
        }
        return original.getChildrenCount(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        EvalWatch ew;
        Map<Watch, EvalWatch> map = this.evalWatches;
        synchronized (map) {
            ew = this.evalWatches.get(node);
        }
        if (ew != null) {
            switch (ew.getStatus().ordinal()) {
                case 2: {
                    DAPVariable result = ew.getResult();
                    return result.getTotalChildren() == 0;
                }
            }
        }
        return true;
    }

    public String getDisplayName(NodeModel model, Object node) throws UnknownTypeException {
        return model.getDisplayName(node);
    }

    public String getIconBase(NodeModel model, Object node) throws UnknownTypeException {
        return model.getIconBase(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(NodeModel model, Object node) throws UnknownTypeException {
        EvalWatch ew;
        Map<Watch, EvalWatch> map = this.evalWatches;
        synchronized (map) {
            ew = this.evalWatches.get(node);
        }
        if (ew != null) {
            ew.startEvaluate();
            switch (ew.getStatus().ordinal()) {
                case 2: {
                    DAPVariable result = ew.getResult();
                    return ew.getExpression() + " = " + result.getValue();
                }
                case 3: {
                    Exception exc = ew.getException();
                    return exc.getLocalizedMessage();
                }
            }
        }
        return model.getShortDescription(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        boolean showValue;
        boolean bl = showValue = columnID == "WatchValue";
        if (showValue || columnID == "WatchType") {
            EvalWatch ew;
            Map<Watch, EvalWatch> map = this.evalWatches;
            synchronized (map) {
                ew = this.evalWatches.get(node);
            }
            if (ew != null) {
                ew.startEvaluate();
                switch (ew.getStatus().ordinal()) {
                    case 2: {
                        DAPVariable result = ew.getResult();
                        if (showValue) {
                            return result.getValue();
                        }
                        return result.getType();
                    }
                    case 3: {
                        if (!showValue) break;
                        Exception exc = ew.getException();
                        return exc.getLocalizedMessage();
                    }
                }
                return "";
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ((columnID == "WatchValue" || columnID == "WatchType") && node instanceof Watch) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    void fireChanges() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    void fireChanged(Object node) {
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void frameChanged() {
        Map<Watch, EvalWatch> map = this.evalWatches;
        synchronized (map) {
            this.evalWatches.values().forEach(EvalWatch::ensureRecalculated);
        }
        this.fireChanges();
    }

    private final class EvalWatch
    implements PropertyChangeListener {
        private final Watch watch;
        private volatile AtomicReference<EvalStatus> status = new AtomicReference<EvalStatus>(EvalStatus.NEW);
        private volatile String expression;
        private volatile DAPVariable result;
        private volatile Exception exception;

        private EvalWatch(Watch watch) {
            this.watch = watch;
            watch.addPropertyChangeListener((PropertyChangeListener)this);
        }

        EvalStatus getStatus() {
            return this.status.get();
        }

        void startEvaluate() {
            DAPFrame frame = WatchesModel.this.getCurrentFrame();
            if (frame == null || !this.watch.isEnabled()) {
                this.status.compareAndSet(EvalStatus.NEW, EvalStatus.SKIPPED);
                return;
            }
            if (this.status.compareAndSet(EvalStatus.NEW, EvalStatus.EVALUATING)) {
                String expression;
                this.result = null;
                this.exception = null;
                this.expression = expression = this.watch.getExpression();
                ((CompletableFuture)WatchesModel.this.debugger.evaluate(frame, expression).thenAccept(variable -> {
                    this.result = variable;
                    this.status.set(EvalStatus.READY);
                    WatchesModel.this.fireChanged(this.watch);
                })).exceptionally(exc -> {
                    this.exception = (Exception)exc;
                    this.status.set(EvalStatus.FAILED);
                    WatchesModel.this.fireChanged(this.watch);
                    return null;
                });
            }
        }

        String getExpression() {
            return this.expression;
        }

        DAPVariable getResult() {
            return this.result;
        }

        Exception getException() {
            return this.exception;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.ensureRecalculated();
        }

        private void ensureRecalculated() {
            if (this.status.getAndSet(EvalStatus.NEW) != EvalStatus.NEW) {
                this.startEvaluate();
            }
        }
    }

    static enum EvalStatus {
        NEW,
        EVALUATING,
        READY,
        FAILED,
        SKIPPED;

    }
}

